/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base;

import com.jme3.network.ConnectionListener;
import com.jme3.network.Filter;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Server;
import com.jme3.network.base.KernelAdapter;
import com.jme3.network.base.KernelFactory;
import com.jme3.network.base.MessageListenerRegistry;
import com.jme3.network.base.MessageProtocol;
import com.jme3.network.kernel.Endpoint;
import com.jme3.network.kernel.Kernel;
import com.jme3.network.message.ChannelInfoMessage;
import com.jme3.network.message.ClientRegistrationMessage;
import com.jme3.network.message.DisconnectMessage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServer
implements Server {
    static Logger log = Logger.getLogger(DefaultServer.class.getName());
    private static final int CH_RELIABLE = 0;
    private static final int CH_UNRELIABLE = 1;
    private static final int CH_FIRST = 2;
    private boolean isRunning = false;
    private AtomicInteger nextId = new AtomicInteger(0);
    private String gameName;
    private int version;
    private KernelFactory kernelFactory = KernelFactory.DEFAULT;
    private KernelAdapter reliableAdapter;
    private KernelAdapter fastAdapter;
    private List<KernelAdapter> channels = new ArrayList<KernelAdapter>();
    private List<Integer> alternatePorts = new ArrayList<Integer>();
    private Redispatch dispatcher = new Redispatch();
    private Map<Integer, HostedConnection> connections = new ConcurrentHashMap<Integer, HostedConnection>();
    private Map<Endpoint, HostedConnection> endpointConnections = new ConcurrentHashMap<Endpoint, HostedConnection>();
    private Map<Long, Connection> connecting = new ConcurrentHashMap<Long, Connection>();
    private MessageListenerRegistry<HostedConnection> messageListeners = new MessageListenerRegistry();
    private List<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();

    public DefaultServer(String gameName, int version, Kernel reliable, Kernel fast) {
        if (reliable == null) {
            throw new IllegalArgumentException("Default server reqiures a reliable kernel instance.");
        }
        this.gameName = gameName;
        this.version = version;
        this.reliableAdapter = new KernelAdapter(this, reliable, this.dispatcher, true);
        this.channels.add(this.reliableAdapter);
        if (fast != null) {
            this.fastAdapter = new KernelAdapter(this, fast, this.dispatcher, false);
            this.channels.add(this.fastAdapter);
        }
    }

    @Override
    public String getGameName() {
        return this.gameName;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int addChannel(int port) {
        if (this.isRunning) {
            throw new IllegalStateException("Channels cannot be added once server is started.");
        }
        if (this.channels.size() - 2 != this.alternatePorts.size()) {
            throw new IllegalStateException("Channel and port lists do not match.");
        }
        try {
            int result = this.alternatePorts.size();
            this.alternatePorts.add(port);
            Kernel kernel = this.kernelFactory.createKernel(result, port);
            this.channels.add(new KernelAdapter(this, kernel, this.dispatcher, true));
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Error adding channel for port:" + port, e);
        }
    }

    protected void checkChannel(int channel) {
        if (channel < 0 || channel >= this.alternatePorts.size()) {
            throw new IllegalArgumentException("Channel is undefined:" + channel);
        }
    }

    @Override
    public void start() {
        if (this.isRunning) {
            throw new IllegalStateException("Server is already started.");
        }
        for (KernelAdapter ka : this.channels) {
            ka.initialize();
        }
        for (KernelAdapter ka : this.channels) {
            ka.start();
        }
        this.isRunning = true;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void close() {
        if (!this.isRunning) {
            throw new IllegalStateException("Server is not started.");
        }
        try {
            for (KernelAdapter ka : this.channels) {
                ka.close();
            }
            this.isRunning = false;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while closing", e);
        }
    }

    @Override
    public void broadcast(Message message) {
        this.broadcast(null, message);
    }

    @Override
    public void broadcast(Filter<? super HostedConnection> filter, Message message) {
        FilterAdapter adapter;
        if (this.connections.isEmpty()) {
            return;
        }
        ByteBuffer buffer = MessageProtocol.messageToBuffer(message, null);
        FilterAdapter filterAdapter = adapter = filter == null ? null : new FilterAdapter(filter);
        if (message.isReliable() || this.fastAdapter == null) {
            this.reliableAdapter.broadcast(adapter, buffer, true, false);
        } else {
            this.fastAdapter.broadcast(adapter, buffer, false, false);
        }
    }

    @Override
    public void broadcast(int channel, Filter<? super HostedConnection> filter, Message message) {
        if (this.connections.isEmpty()) {
            return;
        }
        this.checkChannel(channel);
        ByteBuffer buffer = MessageProtocol.messageToBuffer(message, null);
        FilterAdapter adapter = filter == null ? null : new FilterAdapter(filter);
        this.channels.get(channel + 2).broadcast(adapter, buffer, true, false);
    }

    @Override
    public HostedConnection getConnection(int id) {
        return this.connections.get(id);
    }

    @Override
    public boolean hasConnections() {
        return !this.connections.isEmpty();
    }

    @Override
    public Collection<HostedConnection> getConnections() {
        return Collections.unmodifiableCollection(this.connections.values());
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    @Override
    public void addMessageListener(MessageListener<? super HostedConnection> listener) {
        this.messageListeners.addMessageListener(listener);
    }

    @Override
    public void addMessageListener(MessageListener<? super HostedConnection> listener, Class ... classes) {
        this.messageListeners.addMessageListener(listener, classes);
    }

    @Override
    public void removeMessageListener(MessageListener<? super HostedConnection> listener) {
        this.messageListeners.removeMessageListener(listener);
    }

    @Override
    public void removeMessageListener(MessageListener<? super HostedConnection> listener, Class ... classes) {
        this.messageListeners.removeMessageListener(listener, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(HostedConnection source, Message m) {
        if (source == null) {
            this.messageListeners.messageReceived(source, m);
        } else {
            HostedConnection hostedConnection = source;
            synchronized (hostedConnection) {
                this.messageListeners.messageReceived(source, m);
            }
        }
    }

    protected void fireConnectionAdded(HostedConnection conn) {
        for (ConnectionListener l : this.connectionListeners) {
            l.connectionAdded(this, conn);
        }
    }

    protected void fireConnectionRemoved(HostedConnection conn) {
        for (ConnectionListener l : this.connectionListeners) {
            l.connectionRemoved(this, conn);
        }
    }

    protected int getChannel(KernelAdapter ka) {
        return this.channels.indexOf(ka);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerClient(KernelAdapter ka, Endpoint p, ClientRegistrationMessage m) {
        Connection addedConnection = null;
        DefaultServer defaultServer = this;
        synchronized (defaultServer) {
            long tempId = m.getId();
            Connection c = this.connecting.remove(tempId);
            if (c == null) {
                c = new Connection(this.channels.size());
                log.log(Level.FINE, "Registering client for endpoint, pass 1:{0}.", p);
            } else {
                log.log(Level.FINE, "Refining client registration for endpoint:{0}.", p);
            }
            int channel = this.getChannel(ka);
            c.setChannel(channel, p);
            log.log(Level.FINE, "Setting up channel:{0}", channel);
            if (channel == 0) {
                if (!this.getGameName().equals(m.getGameName()) || this.getVersion() != m.getVersion()) {
                    log.log(Level.INFO, "Kicking client due to name/version mismatch:{0}.", c);
                    c.close("Server client mismatch, server:" + this.getGameName() + " v" + this.getVersion() + "  client:" + m.getGameName() + " v" + m.getVersion());
                    return;
                }
                if (!this.alternatePorts.isEmpty()) {
                    ChannelInfoMessage cim = new ChannelInfoMessage(m.getId(), this.alternatePorts);
                    c.send(cim);
                }
            }
            if (c.isComplete()) {
                if (this.connections.put(c.getId(), c) == null) {
                    for (Endpoint cp : c.channels) {
                        if (cp == null) continue;
                        this.endpointConnections.put(cp, c);
                    }
                    addedConnection = c;
                }
            } else {
                this.connecting.put(tempId, c);
            }
        }
        if (addedConnection != null) {
            log.log(Level.INFO, "Client registered:{0}.", addedConnection);
            m = new ClientRegistrationMessage();
            m.setId(addedConnection.getId());
            m.setReliable(true);
            addedConnection.send(m);
            this.fireConnectionAdded(addedConnection);
        }
    }

    protected HostedConnection getConnection(Endpoint endpoint) {
        return this.endpointConnections.get(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(Endpoint p) {
        if (p.isConnected()) {
            log.log(Level.INFO, "Connection closed:{0}.", p);
        } else {
            log.log(Level.FINE, "Connection closed:{0}.", p);
        }
        Connection removed = null;
        DefaultServer defaultServer = this;
        synchronized (defaultServer) {
            this.connecting.values().remove(p);
            removed = (Connection)this.endpointConnections.remove(p);
            if (removed != null) {
                this.connections.remove(removed.getId());
            }
            log.log(Level.FINE, "Connections size:{0}", this.connections.size());
            log.log(Level.FINE, "Endpoint mappings size:{0}", this.endpointConnections.size());
        }
        if (removed != null && !removed.closed) {
            log.log(Level.INFO, "Client closed:{0}.", removed);
            removed.closeConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Connection
    implements HostedConnection {
        private int id;
        private boolean closed;
        private Endpoint[] channels;
        private int setChannelCount = 0;
        private Map<String, Object> sessionData = new ConcurrentHashMap<String, Object>();

        public Connection(int channelCount) {
            this.id = DefaultServer.this.nextId.getAndIncrement();
            this.channels = new Endpoint[channelCount];
        }

        void setChannel(int channel, Endpoint p) {
            if (this.channels[channel] != null && this.channels[channel] != p) {
                throw new RuntimeException("Channel has already been set:" + channel + " = " + this.channels[channel] + ", cannot be set to:" + p);
            }
            this.channels[channel] = p;
            if (p != null) {
                ++this.setChannelCount;
            }
        }

        boolean isComplete() {
            return this.setChannelCount == this.channels.length;
        }

        @Override
        public Server getServer() {
            return DefaultServer.this;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getAddress() {
            return this.channels[0] == null ? null : this.channels[0].getAddress();
        }

        @Override
        public void send(Message message) {
            ByteBuffer buffer = MessageProtocol.messageToBuffer(message, null);
            if (message.isReliable() || this.channels[1] == null) {
                this.channels[0].send(buffer);
            } else {
                this.channels[1].send(buffer);
            }
        }

        @Override
        public void send(int channel, Message message) {
            DefaultServer.this.checkChannel(channel);
            ByteBuffer buffer = MessageProtocol.messageToBuffer(message, null);
            this.channels[channel + 2].send(buffer);
        }

        protected void closeConnection() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (Endpoint p : this.channels) {
                if (p == null) continue;
                p.close();
            }
            DefaultServer.this.fireConnectionRemoved(this);
        }

        @Override
        public void close(String reason) {
            DisconnectMessage m = new DisconnectMessage();
            m.setType("Kick");
            m.setReason(reason);
            m.setReliable(true);
            this.send(m);
            if (this.channels[0] != null) {
                this.channels[0].close(true);
            }
        }

        @Override
        public Object setAttribute(String name, Object value) {
            if (value == null) {
                return this.sessionData.remove(name);
            }
            return this.sessionData.put(name, value);
        }

        @Override
        public <T> T getAttribute(String name) {
            return (T)this.sessionData.get(name);
        }

        @Override
        public Set<String> attributeNames() {
            return Collections.unmodifiableSet(this.sessionData.keySet());
        }

        public String toString() {
            return "Connection[ id=" + this.id + ", reliable=" + this.channels[0] + ", fast=" + this.channels[1] + " ]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FilterAdapter
    implements Filter<Endpoint> {
        private Filter<? super HostedConnection> delegate;

        public FilterAdapter(Filter<? super HostedConnection> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean apply(Endpoint input) {
            HostedConnection conn = DefaultServer.this.getConnection(input);
            if (conn == null) {
                return false;
            }
            return this.delegate.apply(conn);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Redispatch
    implements MessageListener<HostedConnection> {
        protected Redispatch() {
        }

        @Override
        public void messageReceived(HostedConnection source, Message m) {
            DefaultServer.this.dispatch(source, m);
        }
    }
}

