/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network;

import com.jme3.network.Filter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    public static <T> Filter<T> in(T ... values) {
        return Filters.in(new HashSet<T>(Arrays.asList(values)));
    }

    public static <T> Filter<T> in(Collection<? extends T> collection) {
        return new InFilter<T>(collection);
    }

    public static <T> Filter<T> notIn(T ... values) {
        return Filters.not(Filters.in(values));
    }

    public static <T> Filter<T> notIn(Collection<? extends T> collection) {
        return Filters.not(Filters.in(collection));
    }

    public static <T> Filter<T> equalTo(T value) {
        return new EqualToFilter<T>(value);
    }

    public static <T> Filter<T> notEqualTo(T value) {
        return Filters.not(Filters.equalTo(value));
    }

    public static <T> Filter<T> not(Filter<T> f) {
        return new NotFilter<T>(f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EqualToFilter<T>
    implements Filter<T> {
        private T value;

        public EqualToFilter(T value) {
            this.value = value;
        }

        @Override
        public boolean apply(T input) {
            return this.value == input || this.value != null && this.value.equals(input);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InFilter<T>
    implements Filter<T> {
        private Collection<? extends T> collection;

        public InFilter(Collection<? extends T> collection) {
            this.collection = collection;
        }

        @Override
        public boolean apply(T input) {
            return this.collection.contains(input);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotFilter<T>
    implements Filter<T> {
        private Filter<T> delegate;

        public NotFilter(Filter<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean apply(T input) {
            return !this.delegate.apply(input);
        }
    }
}

