/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.nifty.tools.TimeProvider;
import de.lessvoid.nifty.tools.pulsate.Pulsator;

public class TextSizePulsate
implements EffectImpl {
    private SizeValue startSize = new SizeValue("0%");
    private SizeValue endSize = new SizeValue("100%");
    private Pulsator pulsator;
    private boolean activated = false;

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        String endSizeString;
        String startSizeString = parameter.getProperty("startSize");
        if (startSizeString != null) {
            this.startSize = new SizeValue(startSizeString);
        }
        if ((endSizeString = parameter.getProperty("endSize")) != null) {
            this.endSize = new SizeValue(endSizeString);
        }
        this.pulsator = new Pulsator(parameter, new TimeProvider());
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        if (!this.activated && normalizedTime > 0.0f) {
            this.activated = true;
            this.pulsator.reset();
        }
        if (this.activated) {
            float value = this.pulsator.update();
            float size = this.startSize.getValue(1.0f) + value * (this.endSize.getValue(1.0f) - this.startSize.getValue(1.0f));
            TextRenderer textRenderer = element.getRenderer(TextRenderer.class);
            if (textRenderer != null) {
                String text = textRenderer.getWrappedText();
                RenderFont font = textRenderer.getFont();
                float originalWidth = font.getWidth(text, 1.0f);
                float sizedWidth = font.getWidth(text, size);
                float originalHeight = font.getHeight();
                float sizedHeight = (float)font.getHeight() * size;
                r.moveTo(-(sizedWidth - originalWidth) / 2.0f, -(sizedHeight - originalHeight) / 2.0f);
            }
            r.setRenderTextSize(size);
        }
    }

    @Override
    public void deactivate() {
        this.activated = true;
    }
}

