/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.List;

public class NiftyInputControl {
    private Controller controller;
    private NiftyInputMapping inputMapper;
    private List<KeyInputHandler> preInputHandler = new ArrayList<KeyInputHandler>();
    private List<KeyInputHandler> postInputHandler = new ArrayList<KeyInputHandler>();

    public NiftyInputControl(Controller controllerParam, NiftyInputMapping inputMapperParam) {
        this.controller = controllerParam;
        this.inputMapper = inputMapperParam;
    }

    public boolean keyEvent(Nifty nifty, KeyboardInputEvent inputEvent, String elementId) {
        NiftyInputEvent converted = this.inputMapper.convert(inputEvent);
        for (KeyInputHandler handler : this.preInputHandler) {
            if (!handler.keyEvent(converted)) continue;
            return true;
        }
        if (converted != null) {
            nifty.publishEvent(elementId, converted);
        }
        if (this.controller.inputEvent(converted)) {
            return true;
        }
        for (KeyInputHandler handler : this.postInputHandler) {
            if (!handler.keyEvent(converted)) continue;
            return true;
        }
        return false;
    }

    public void addInputHandler(KeyInputHandler handler) {
        this.postInputHandler.add(handler);
    }

    public void addPreInputHandler(KeyInputHandler handler) {
        this.preInputHandler.add(handler);
    }

    public void onStartScreen(Nifty nifty, Screen screen) {
        this.controller.onStartScreen();
    }

    public void onEndScreen(Nifty nifty, Screen screen, String elementId) {
        nifty.unsubscribeAnnotations(this.controller);
        nifty.unsubscribeElement(screen, elementId);
    }

    public void onFocus(boolean getFocus) {
        this.controller.onFocus(getFocus);
    }

    public Controller getController() {
        return this.controller;
    }

    public <T extends Controller> T getControl(Class<T> requestedControlClass) {
        if (requestedControlClass.isInstance(this.controller)) {
            return (T)((Controller)requestedControlClass.cast(this.controller));
        }
        return null;
    }

    public <T extends NiftyControl> T getNiftyControl(Class<T> requestedControlClass) {
        if (requestedControlClass.isInstance(this.controller)) {
            return (T)((NiftyControl)requestedControlClass.cast(this.controller));
        }
        return null;
    }

    public void bindControl(Nifty nifty, Screen screen, Element element, Attributes attributes) {
        if (this.controller != null) {
            this.controller.bind(nifty, screen, element, attributes.createProperties(), attributes);
        }
    }

    public void initControl(Attributes attributes) {
        if (this.controller != null) {
            this.controller.init(attributes.createProperties(), attributes);
        }
    }
}

