/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.shader.VarType;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DefineList
implements Savable {
    private final SortedMap<String, String> defines = new TreeMap<String, String>();
    private String compiled = null;

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        String[] keys = new String[this.defines.size()];
        String[] vals = new String[this.defines.size()];
        int i = 0;
        for (Map.Entry<String, String> define : this.defines.entrySet()) {
            keys[i] = define.getKey();
            vals[i] = define.getValue();
            ++i;
        }
        oc.write(keys, "keys", null);
        oc.write(vals, "vals", null);
        oc.write(this.compiled, "compiled", null);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        String[] keys = ic.readStringArray("keys", null);
        String[] vals = ic.readStringArray("vals", null);
        for (int i = 0; i < keys.length; ++i) {
            this.defines.put(keys[i], vals[i]);
        }
        this.compiled = ic.readString("compiled", null);
    }

    public void clear() {
        this.defines.clear();
        this.compiled = "";
    }

    public String get(String key) {
        return (String)this.defines.get(key);
    }

    public boolean set(String key, VarType type, Object val) {
        if (val == null) {
            this.defines.remove(key);
            this.compiled = null;
            return true;
        }
        switch (type) {
            case Boolean: {
                if (((Boolean)val).booleanValue()) {
                    if (this.defines.put(key, "1") == "1") break;
                    this.compiled = null;
                    return true;
                }
                if (!this.defines.containsKey(key)) break;
                this.defines.remove(key);
                this.compiled = null;
                return true;
            }
            case Float: 
            case Int: {
                String original = this.defines.put(key, val.toString());
                if (val.equals(original)) break;
                this.compiled = null;
                return true;
            }
            default: {
                if (this.defines.put(key, "1") == "1") break;
                this.compiled = null;
                return true;
            }
        }
        return false;
    }

    public boolean remove(String key) {
        if (this.defines.remove(key) != null) {
            this.compiled = null;
            return true;
        }
        return false;
    }

    public void addFrom(DefineList other) {
        if (other == null) {
            return;
        }
        this.compiled = null;
        this.defines.putAll(other.defines);
    }

    public String getCompiled() {
        if (this.compiled == null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.defines.entrySet()) {
                sb.append("#define ").append(entry.getKey()).append(" ");
                sb.append(entry.getValue()).append('\n');
            }
            this.compiled = sb.toString();
        }
        return this.compiled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : this.defines.entrySet()) {
            sb.append(entry.getKey());
            if (i != this.defines.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }
}

