/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer;

import com.jme3.shader.Shader;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Caps {
    FrameBuffer,
    FrameBufferMRT,
    FrameBufferMultisample,
    TextureMultisample,
    OpenGL20,
    OpenGL21,
    OpenGL30,
    OpenGL31,
    OpenGL32,
    ARBprogram,
    GLSL100,
    GLSL110,
    GLSL120,
    GLSL130,
    GLSL140,
    GLSL150,
    GLSL330,
    VertexTextureFetch,
    GeometryShader,
    TextureArray,
    TextureBuffer,
    FloatTexture,
    FloatColorBuffer,
    FloatDepthBuffer,
    PackedFloatTexture,
    SharedExponentTexture,
    PackedFloatColorBuffer,
    SharedExponentColorBuffer,
    TextureCompressionLATC,
    NonPowerOfTwoTextures,
    MeshInstancing,
    VertexBufferArray,
    Multisample,
    PackedDepthStencilBuffer;


    public static boolean supports(Collection<Caps> caps, Texture tex) {
        if (tex.getType() == Texture.Type.TwoDimensionalArray && !caps.contains((Object)TextureArray)) {
            return false;
        }
        Image img = tex.getImage();
        if (img == null) {
            return true;
        }
        Image.Format fmt = img.getFormat();
        switch (fmt) {
            case Depth24Stencil8: {
                return caps.contains((Object)PackedDepthStencilBuffer);
            }
            case Depth32F: {
                return caps.contains((Object)FloatDepthBuffer);
            }
            case LATC: {
                return caps.contains((Object)TextureCompressionLATC);
            }
            case RGB16F_to_RGB111110F: 
            case RGB111110F: {
                return caps.contains((Object)PackedFloatTexture);
            }
            case RGB16F_to_RGB9E5: 
            case RGB9E5: {
                return caps.contains((Object)SharedExponentTexture);
            }
        }
        if (fmt.isFloatingPont()) {
            return caps.contains((Object)FloatTexture);
        }
        return true;
    }

    private static boolean supportsColorBuffer(Collection<Caps> caps, FrameBuffer.RenderBuffer colorBuf) {
        Image.Format colorFmt = colorBuf.getFormat();
        if (colorFmt.isDepthFormat()) {
            return false;
        }
        if (colorFmt.isCompressed()) {
            return false;
        }
        switch (colorFmt) {
            case RGB111110F: {
                return caps.contains((Object)PackedFloatColorBuffer);
            }
            case RGB16F_to_RGB111110F: 
            case RGB16F_to_RGB9E5: 
            case RGB9E5: {
                return false;
            }
        }
        if (colorFmt.isFloatingPont()) {
            return caps.contains((Object)FloatColorBuffer);
        }
        return true;
    }

    public static boolean supports(Collection<Caps> caps, FrameBuffer fb) {
        if (!caps.contains((Object)FrameBuffer)) {
            return false;
        }
        if (fb.getSamples() > 1 && !caps.contains((Object)FrameBufferMultisample)) {
            return false;
        }
        FrameBuffer.RenderBuffer depthBuf = fb.getDepthBuffer();
        if (depthBuf != null) {
            Image.Format depthFmt = depthBuf.getFormat();
            if (!depthFmt.isDepthFormat()) {
                return false;
            }
            if (depthFmt == Image.Format.Depth32F && !caps.contains((Object)FloatDepthBuffer)) {
                return false;
            }
            if (depthFmt == Image.Format.Depth24Stencil8 && !caps.contains((Object)PackedDepthStencilBuffer)) {
                return false;
            }
        }
        for (int i = 0; i < fb.getNumColorBuffers(); ++i) {
            if (Caps.supportsColorBuffer(caps, fb.getColorBuffer(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean supports(Collection<Caps> caps, Shader shader) {
        String lang = shader.getLanguage();
        if (lang.startsWith("GLSL")) {
            int ver = Integer.parseInt(lang.substring(4));
            switch (ver) {
                case 100: {
                    return caps.contains((Object)GLSL100);
                }
                case 110: {
                    return caps.contains((Object)GLSL110);
                }
                case 120: {
                    return caps.contains((Object)GLSL120);
                }
                case 130: {
                    return caps.contains((Object)GLSL130);
                }
                case 140: {
                    return caps.contains((Object)GLSL140);
                }
                case 150: {
                    return caps.contains((Object)GLSL150);
                }
                case 330: {
                    return caps.contains((Object)GLSL330);
                }
            }
            return false;
        }
        return false;
    }
}

