/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.input.JoyInput;
import com.jme3.input.Joystick;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.TouchInput;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.JoyAxisTrigger;
import com.jme3.input.controls.JoyButtonTrigger;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.TouchListener;
import com.jme3.input.controls.TouchTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.input.event.InputEvent;
import com.jme3.input.event.JoyAxisEvent;
import com.jme3.input.event.JoyButtonEvent;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.input.event.TouchEvent;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.util.IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InputManager
implements RawInputListener {
    private static final Logger logger = Logger.getLogger(InputManager.class.getName());
    private final KeyInput keys;
    private final MouseInput mouse;
    private final JoyInput joystick;
    private final TouchInput touch;
    private float frameTPF;
    private long lastLastUpdateTime = 0L;
    private long lastUpdateTime = 0L;
    private long frameDelta = 0L;
    private long firstTime = 0L;
    private boolean eventsPermitted = false;
    private boolean mouseVisible = true;
    private boolean safeMode = false;
    private float axisDeadZone = 0.05f;
    private Vector2f cursorPos = new Vector2f();
    private Joystick[] joysticks;
    private final IntMap<ArrayList<Mapping>> bindings = new IntMap();
    private final HashMap<String, Mapping> mappings = new HashMap();
    private final IntMap<Long> pressedButtons = new IntMap();
    private final IntMap<Float> axisValues = new IntMap();
    private ArrayList<RawInputListener> rawListeners = new ArrayList();
    private RawInputListener[] rawListenerArray = null;
    private ArrayList<InputEvent> inputQueue = new ArrayList();

    public InputManager(MouseInput mouse, KeyInput keys, JoyInput joystick, TouchInput touch) {
        if (keys == null || mouse == null) {
            throw new NullPointerException("Mouse or keyboard cannot be null");
        }
        this.keys = keys;
        this.mouse = mouse;
        this.joystick = joystick;
        this.touch = touch;
        keys.setInputListener(this);
        mouse.setInputListener(this);
        if (joystick != null) {
            joystick.setInputListener(this);
            this.joysticks = joystick.loadJoysticks(this);
        }
        if (touch != null) {
            touch.setInputListener(this);
        }
        this.firstTime = keys.getInputTimeNanos();
    }

    private void invokeActions(int hash, boolean pressed) {
        ArrayList<Mapping> maps = this.bindings.get(hash);
        if (maps == null) {
            return;
        }
        int size = maps.size();
        for (int i = size - 1; i >= 0; --i) {
            Mapping mapping = maps.get(i);
            ArrayList listeners = mapping.listeners;
            int listenerSize = listeners.size();
            for (int j = listenerSize - 1; j >= 0; --j) {
                InputListener listener = (InputListener)listeners.get(j);
                if (!(listener instanceof ActionListener)) continue;
                ((ActionListener)listener).onAction(mapping.name, pressed, this.frameTPF);
            }
        }
    }

    private float computeAnalogValue(long timeDelta) {
        if (this.safeMode || this.frameDelta == 0L) {
            return 1.0f;
        }
        return FastMath.clamp((float)timeDelta / (float)this.frameDelta, 0.0f, 1.0f);
    }

    private void invokeTimedActions(int hash, long time, boolean pressed) {
        if (!this.bindings.containsKey(hash)) {
            return;
        }
        if (pressed) {
            this.pressedButtons.put(hash, time);
        } else {
            long lastUpdate;
            Long pressTimeObj = this.pressedButtons.remove(hash);
            if (pressTimeObj == null) {
                return;
            }
            long releaseTime = time;
            long pressTime = pressTimeObj;
            long timeDelta = releaseTime - Math.max(pressTime, lastUpdate = this.lastLastUpdateTime);
            if (timeDelta > 0L) {
                this.invokeAnalogs(hash, this.computeAnalogValue(timeDelta), false);
            }
        }
    }

    private void invokeUpdateActions() {
        int hash;
        for (IntMap.Entry<Long> entry : this.pressedButtons) {
            hash = entry.getKey();
            long pressTime = entry.getValue();
            long timeDelta = this.lastUpdateTime - Math.max(this.lastLastUpdateTime, pressTime);
            if (timeDelta <= 0L) continue;
            this.invokeAnalogs(hash, this.computeAnalogValue(timeDelta), false);
        }
        for (IntMap.Entry<Number> entry : this.axisValues) {
            hash = entry.getKey();
            float value = ((Float)entry.getValue()).floatValue();
            this.invokeAnalogs(hash, value * this.frameTPF, true);
        }
    }

    private void invokeAnalogs(int hash, float value, boolean isAxis) {
        ArrayList<Mapping> maps = this.bindings.get(hash);
        if (maps == null) {
            return;
        }
        if (!isAxis) {
            value *= this.frameTPF;
        }
        int size = maps.size();
        for (int i = size - 1; i >= 0; --i) {
            Mapping mapping = maps.get(i);
            ArrayList listeners = mapping.listeners;
            int listenerSize = listeners.size();
            for (int j = listenerSize - 1; j >= 0; --j) {
                InputListener listener = (InputListener)listeners.get(j);
                if (!(listener instanceof AnalogListener)) continue;
                ((AnalogListener)listener).onAnalog(mapping.name, value, this.frameTPF);
            }
        }
    }

    private void invokeAnalogsAndActions(int hash, float value, boolean applyTpf) {
        boolean valueChanged;
        if (value < this.axisDeadZone) {
            this.invokeAnalogs(hash, value, !applyTpf);
            return;
        }
        ArrayList<Mapping> maps = this.bindings.get(hash);
        if (maps == null) {
            return;
        }
        boolean bl = valueChanged = !this.axisValues.containsKey(hash);
        if (applyTpf) {
            value *= this.frameTPF;
        }
        int size = maps.size();
        for (int i = size - 1; i >= 0; --i) {
            Mapping mapping = maps.get(i);
            ArrayList listeners = mapping.listeners;
            int listenerSize = listeners.size();
            for (int j = listenerSize - 1; j >= 0; --j) {
                InputListener listener = (InputListener)listeners.get(j);
                if (listener instanceof ActionListener && valueChanged) {
                    ((ActionListener)listener).onAction(mapping.name, true, this.frameTPF);
                }
                if (!(listener instanceof AnalogListener)) continue;
                ((AnalogListener)listener).onAnalog(mapping.name, value, this.frameTPF);
            }
        }
    }

    public void beginInput() {
    }

    public void endInput() {
    }

    private void onJoyAxisEventQueued(JoyAxisEvent evt) {
        int joyId = evt.getJoyIndex();
        int axis = evt.getAxisIndex();
        float value = evt.getValue();
        if (value < this.axisDeadZone && value > -this.axisDeadZone) {
            int hash1 = JoyAxisTrigger.joyAxisHash(joyId, axis, true);
            int hash2 = JoyAxisTrigger.joyAxisHash(joyId, axis, false);
            Float val1 = this.axisValues.get(hash1);
            Float val2 = this.axisValues.get(hash2);
            if (val1 != null && val1.floatValue() > this.axisDeadZone) {
                this.invokeActions(hash1, false);
            }
            if (val2 != null && val2.floatValue() > this.axisDeadZone) {
                this.invokeActions(hash2, false);
            }
            this.axisValues.remove(hash1);
            this.axisValues.remove(hash2);
        } else if (value < 0.0f) {
            int hash = JoyAxisTrigger.joyAxisHash(joyId, axis, true);
            int otherHash = JoyAxisTrigger.joyAxisHash(joyId, axis, false);
            this.invokeAnalogsAndActions(hash, -value, true);
            this.axisValues.put(hash, Float.valueOf(-value));
            this.axisValues.remove(otherHash);
        } else {
            int hash = JoyAxisTrigger.joyAxisHash(joyId, axis, false);
            int otherHash = JoyAxisTrigger.joyAxisHash(joyId, axis, true);
            this.invokeAnalogsAndActions(hash, value, true);
            this.axisValues.put(hash, Float.valueOf(value));
            this.axisValues.remove(otherHash);
        }
    }

    public void onJoyAxisEvent(JoyAxisEvent evt) {
        if (!this.eventsPermitted) {
            throw new UnsupportedOperationException("JoyInput has raised an event at an illegal time.");
        }
        this.inputQueue.add(evt);
    }

    private void onJoyButtonEventQueued(JoyButtonEvent evt) {
        int hash = JoyButtonTrigger.joyButtonHash(evt.getJoyIndex(), evt.getButtonIndex());
        this.invokeActions(hash, evt.isPressed());
        this.invokeTimedActions(hash, evt.getTime(), evt.isPressed());
    }

    public void onJoyButtonEvent(JoyButtonEvent evt) {
        if (!this.eventsPermitted) {
            throw new UnsupportedOperationException("JoyInput has raised an event at an illegal time.");
        }
        this.inputQueue.add(evt);
    }

    private void onMouseMotionEventQueued(MouseMotionEvent evt) {
        float val;
        if (evt.getDX() != 0) {
            val = (float)Math.abs(evt.getDX()) / 1024.0f;
            this.invokeAnalogsAndActions(MouseAxisTrigger.mouseAxisHash(0, evt.getDX() < 0), val, false);
        }
        if (evt.getDY() != 0) {
            val = (float)Math.abs(evt.getDY()) / 1024.0f;
            this.invokeAnalogsAndActions(MouseAxisTrigger.mouseAxisHash(1, evt.getDY() < 0), val, false);
        }
        if (evt.getDeltaWheel() != 0) {
            val = (float)Math.abs(evt.getDeltaWheel()) / 100.0f;
            this.invokeAnalogsAndActions(MouseAxisTrigger.mouseAxisHash(2, evt.getDeltaWheel() < 0), val, false);
        }
    }

    public void onMouseMotionEvent(MouseMotionEvent evt) {
        if (!this.eventsPermitted) {
            throw new UnsupportedOperationException("MouseInput has raised an event at an illegal time.");
        }
        this.cursorPos.set(evt.getX(), evt.getY());
        this.inputQueue.add(evt);
    }

    private void onMouseButtonEventQueued(MouseButtonEvent evt) {
        int hash = MouseButtonTrigger.mouseButtonHash(evt.getButtonIndex());
        this.invokeActions(hash, evt.isPressed());
        this.invokeTimedActions(hash, evt.getTime(), evt.isPressed());
    }

    public void onMouseButtonEvent(MouseButtonEvent evt) {
        if (!this.eventsPermitted) {
            throw new UnsupportedOperationException("MouseInput has raised an event at an illegal time.");
        }
        this.cursorPos.set(evt.getX(), evt.getY());
        this.inputQueue.add(evt);
    }

    private void onKeyEventQueued(KeyInputEvent evt) {
        if (evt.isRepeating()) {
            return;
        }
        int hash = KeyTrigger.keyHash(evt.getKeyCode());
        this.invokeActions(hash, evt.isPressed());
        this.invokeTimedActions(hash, evt.getTime(), evt.isPressed());
    }

    public void onKeyEvent(KeyInputEvent evt) {
        if (!this.eventsPermitted) {
            throw new UnsupportedOperationException("KeyInput has raised an event at an illegal time.");
        }
        this.inputQueue.add(evt);
    }

    public void setAxisDeadZone(float deadZone) {
        this.axisDeadZone = deadZone;
    }

    public float getAxisDeadZone() {
        return this.axisDeadZone;
    }

    public void addListener(InputListener listener, String ... mappingNames) {
        for (String mappingName : mappingNames) {
            Mapping mapping = this.mappings.get(mappingName);
            if (mapping == null) {
                mapping = new Mapping(mappingName);
                this.mappings.put(mappingName, mapping);
            }
            if (mapping.listeners.contains(listener)) continue;
            mapping.listeners.add(listener);
        }
    }

    public void removeListener(InputListener listener) {
        for (Mapping mapping : this.mappings.values()) {
            mapping.listeners.remove(listener);
        }
    }

    public void addMapping(String mappingName, Trigger ... triggers) {
        Mapping mapping = this.mappings.get(mappingName);
        if (mapping == null) {
            mapping = new Mapping(mappingName);
            this.mappings.put(mappingName, mapping);
        }
        for (Trigger trigger : triggers) {
            int hash = trigger.triggerHashCode();
            ArrayList<Mapping> names = this.bindings.get(hash);
            if (names == null) {
                names = new ArrayList();
                this.bindings.put(hash, names);
            }
            if (!names.contains(mapping)) {
                names.add(mapping);
                mapping.triggers.add(hash);
                continue;
            }
            logger.log(Level.WARNING, "Attempted to add mapping \"{0}\" twice to trigger.", mappingName);
        }
    }

    public boolean hasMapping(String mappingName) {
        return this.mappings.containsKey(mappingName);
    }

    public void deleteMapping(String mappingName) {
        Mapping mapping = this.mappings.remove(mappingName);
        if (mapping == null) {
            throw new IllegalArgumentException("Cannot find mapping: " + mappingName);
        }
        ArrayList triggers = mapping.triggers;
        for (int i = triggers.size() - 1; i >= 0; --i) {
            int hash = (Integer)triggers.get(i);
            ArrayList<Mapping> maps = this.bindings.get(hash);
            maps.remove(mapping);
        }
    }

    public void deleteTrigger(String mappingName, Trigger trigger) {
        Mapping mapping = this.mappings.get(mappingName);
        if (mapping == null) {
            throw new IllegalArgumentException("Cannot find mapping: " + mappingName);
        }
        ArrayList<Mapping> maps = this.bindings.get(trigger.triggerHashCode());
        maps.remove(mapping);
    }

    public void clearMappings() {
        this.mappings.clear();
        this.bindings.clear();
        this.reset();
    }

    public void reset() {
        this.pressedButtons.clear();
        this.axisValues.clear();
    }

    public boolean isCursorVisible() {
        return this.mouseVisible;
    }

    public void setCursorVisible(boolean visible) {
        if (this.mouseVisible != visible) {
            this.mouseVisible = visible;
            this.mouse.setCursorVisible(this.mouseVisible);
        }
    }

    public Vector2f getCursorPosition() {
        return this.cursorPos;
    }

    public Joystick[] getJoysticks() {
        return this.joysticks;
    }

    public void addRawInputListener(RawInputListener listener) {
        this.rawListeners.add(listener);
        this.rawListenerArray = null;
    }

    public void removeRawInputListener(RawInputListener listener) {
        this.rawListeners.remove(listener);
        this.rawListenerArray = null;
    }

    public void clearRawInputListeners() {
        this.rawListeners.clear();
        this.rawListenerArray = null;
    }

    private RawInputListener[] getRawListenerArray() {
        if (this.rawListenerArray == null) {
            this.rawListenerArray = this.rawListeners.toArray(new RawInputListener[this.rawListeners.size()]);
        }
        return this.rawListenerArray;
    }

    public void setSimulateMouse(boolean value) {
        if (this.touch != null) {
            this.touch.setSimulateMouse(value);
        }
    }

    public boolean getSimulateMouse() {
        if (this.touch != null) {
            return this.touch.getSimulateMouse();
        }
        return false;
    }

    public void setSimulateKeyboard(boolean value) {
        if (this.touch != null) {
            this.touch.setSimulateKeyboard(value);
        }
    }

    private void processQueue() {
        RawInputListener[] array;
        int queueSize = this.inputQueue.size();
        for (RawInputListener listener : array = this.getRawListenerArray()) {
            listener.beginInput();
            for (int j = 0; j < queueSize; ++j) {
                InputEvent event = this.inputQueue.get(j);
                if (event.isConsumed()) continue;
                if (event instanceof MouseMotionEvent) {
                    listener.onMouseMotionEvent((MouseMotionEvent)event);
                    continue;
                }
                if (event instanceof KeyInputEvent) {
                    listener.onKeyEvent((KeyInputEvent)event);
                    continue;
                }
                if (event instanceof MouseButtonEvent) {
                    listener.onMouseButtonEvent((MouseButtonEvent)event);
                    continue;
                }
                if (event instanceof JoyAxisEvent) {
                    listener.onJoyAxisEvent((JoyAxisEvent)event);
                    continue;
                }
                if (event instanceof JoyButtonEvent) {
                    listener.onJoyButtonEvent((JoyButtonEvent)event);
                    continue;
                }
                if (event instanceof TouchEvent) {
                    listener.onTouchEvent((TouchEvent)event);
                    continue;
                }
                assert (false);
            }
            listener.endInput();
        }
        for (int i = 0; i < queueSize; ++i) {
            InputEvent event = this.inputQueue.get(i);
            if (event.isConsumed()) continue;
            if (event instanceof MouseMotionEvent) {
                this.onMouseMotionEventQueued((MouseMotionEvent)event);
            } else if (event instanceof KeyInputEvent) {
                this.onKeyEventQueued((KeyInputEvent)event);
            } else if (event instanceof MouseButtonEvent) {
                this.onMouseButtonEventQueued((MouseButtonEvent)event);
            } else if (event instanceof JoyAxisEvent) {
                this.onJoyAxisEventQueued((JoyAxisEvent)event);
            } else if (event instanceof JoyButtonEvent) {
                this.onJoyButtonEventQueued((JoyButtonEvent)event);
            } else if (event instanceof TouchEvent) {
                this.onTouchEventQueued((TouchEvent)event);
            } else assert (false);
            event.setConsumed();
        }
        this.inputQueue.clear();
    }

    public void update(float tpf) {
        this.frameTPF = tpf;
        this.safeMode = tpf < 0.015f;
        long currentTime = this.keys.getInputTimeNanos();
        this.frameDelta = currentTime - this.lastUpdateTime;
        this.eventsPermitted = true;
        this.keys.update();
        this.mouse.update();
        if (this.joystick != null) {
            this.joystick.update();
        }
        if (this.touch != null) {
            this.touch.update();
        }
        this.eventsPermitted = false;
        this.processQueue();
        this.invokeUpdateActions();
        this.lastLastUpdateTime = this.lastUpdateTime;
        this.lastUpdateTime = currentTime;
    }

    public void onTouchEventQueued(TouchEvent evt) {
        ArrayList<Mapping> maps = this.bindings.get(TouchTrigger.touchHash(evt.getKeyCode()));
        if (maps == null) {
            return;
        }
        int size = maps.size();
        for (int i = size - 1; i >= 0; --i) {
            Mapping mapping = maps.get(i);
            ArrayList listeners = mapping.listeners;
            int listenerSize = listeners.size();
            for (int j = listenerSize - 1; j >= 0; --j) {
                InputListener listener = (InputListener)listeners.get(j);
                if (!(listener instanceof TouchListener)) continue;
                ((TouchListener)listener).onTouch(mapping.name, evt, this.frameTPF);
            }
        }
    }

    public void onTouchEvent(TouchEvent evt) {
        if (!this.eventsPermitted) {
            throw new UnsupportedOperationException("TouchInput has raised an event at an illegal time.");
        }
        this.inputQueue.add(evt);
    }

    private static class Mapping {
        private final String name;
        private final ArrayList<Integer> triggers = new ArrayList();
        private final ArrayList<InputListener> listeners = new ArrayList();

        public Mapping(String name) {
            this.name = name;
        }
    }
}

