/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Quaternion;
import com.jme3.scene.Spatial;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
public class RotationTrack
extends AbstractCinematicEvent {
    private static final Logger log = Logger.getLogger(RotationTrack.class.getName());
    private Quaternion startRotation = new Quaternion();
    private Quaternion endRotation = new Quaternion();
    private Spatial spatial;
    private String spatialName = "";
    private float value = 0.0f;

    public void initEvent(Application app, Cinematic cinematic) {
        super.initEvent(app, cinematic);
        if (this.spatial == null) {
            this.spatial = cinematic.getScene().getChild(this.spatialName);
            if (this.spatial != null) {
                log.log(Level.WARNING, "spatial {0} not found in the scene", this.spatialName);
            }
        }
    }

    public RotationTrack() {
    }

    public RotationTrack(Spatial spatial, Quaternion endRotation) {
        this.endRotation.set(endRotation);
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public RotationTrack(Spatial spatial, Quaternion endRotation, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.endRotation.set(endRotation);
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public RotationTrack(Spatial spatial, Quaternion endRotation, LoopMode loopMode) {
        super(loopMode);
        this.endRotation.set(endRotation);
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public RotationTrack(Spatial spatial, Quaternion endRotation, float initialDuration) {
        super(initialDuration);
        this.endRotation.set(endRotation);
        this.spatial = spatial;
        this.spatialName = spatial.getName();
    }

    public void onPlay() {
        if (this.playState != PlayState.Paused) {
            this.startRotation.set(this.spatial.getWorldRotation());
        }
        if (this.initialDuration == 0.0f && this.spatial != null) {
            this.spatial.setLocalRotation(this.endRotation);
            this.stop();
        }
    }

    public void onUpdate(float tpf) {
        if (this.spatial != null) {
            this.value = Math.min(this.time / this.initialDuration, 1.0f);
            TempVars vars = TempVars.get();
            Quaternion q = vars.quat1;
            q.set(this.startRotation).slerp(this.endRotation, this.value);
            this.spatial.setLocalRotation(q);
            vars.release();
        }
    }

    public void onStop() {
        this.value = 0.0f;
    }

    public void onPause() {
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.spatialName, "spatialName", "");
        oc.write(this.endRotation, "endRotation", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.spatialName = ic.readString("spatialName", "");
        this.endRotation = (Quaternion)ic.readSavable("endRotation", null);
    }
}

