/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public final class Pose
implements Savable,
Cloneable {
    private String name;
    private int targetMeshIndex;
    private Vector3f[] offsets;
    private int[] indices;
    private final transient Vector3f tempVec = new Vector3f();
    private final transient Vector3f tempVec2 = new Vector3f();

    public Pose(String name, int targetMeshIndex, Vector3f[] offsets, int[] indices) {
        this.name = name;
        this.targetMeshIndex = targetMeshIndex;
        this.offsets = offsets;
        this.indices = indices;
    }

    public int getTargetMeshIndex() {
        return this.targetMeshIndex;
    }

    public void apply(float blend, FloatBuffer vertbuf) {
        for (int i = 0; i < this.indices.length; ++i) {
            Vector3f offset = this.offsets[i];
            int vertIndex = this.indices[i];
            this.tempVec.set(offset).multLocal(blend);
            BufferUtils.populateFromBuffer(this.tempVec2, vertbuf, vertIndex);
            this.tempVec2.addLocal(this.tempVec);
            BufferUtils.setInBuffer(this.tempVec2, vertbuf, vertIndex);
        }
    }

    public Pose clone() {
        try {
            Pose result = (Pose)super.clone();
            result.indices = (int[])this.indices.clone();
            if (this.offsets != null) {
                result.offsets = new Vector3f[this.offsets.length];
                for (int i = 0; i < this.offsets.length; ++i) {
                    result.offsets[i] = this.offsets[i].clone();
                }
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public void write(JmeExporter e) throws IOException {
        OutputCapsule out = e.getCapsule(this);
        out.write(this.name, "name", "");
        out.write(this.targetMeshIndex, "meshIndex", -1);
        out.write(this.offsets, "offsets", null);
        out.write(this.indices, "indices", (int[])null);
    }

    public void read(JmeImporter i) throws IOException {
        InputCapsule in = i.getCapsule(this);
        this.name = in.readString("name", "");
        this.targetMeshIndex = in.readInt("meshIndex", -1);
        this.offsets = (Vector3f[])in.readSavableArray("offsets", null);
        this.indices = in.readIntArray("indices", null);
    }
}

