/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.math.ColorRGBA;
import com.jme3.terrain.heightmap.AbstractHeightMap;
import com.jme3.terrain.heightmap.ImageHeightmap;
import com.jme3.texture.Image;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class ImageBasedHeightMap
extends AbstractHeightMap
implements ImageHeightmap {
    protected Image colorImage;

    public void setImage(Image image) {
        this.colorImage = image;
    }

    public ImageBasedHeightMap(Image colorImage) {
        this.colorImage = colorImage;
    }

    public ImageBasedHeightMap(Image colorImage, float heightScale) {
        this.colorImage = colorImage;
        this.heightScale = heightScale;
    }

    public boolean load() {
        return this.load(false, false);
    }

    protected float calculateHeight(float red, float green, float blue) {
        return (float)(0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue);
    }

    public boolean load(boolean flipX, boolean flipY) {
        int imageHeight;
        int imageWidth = this.colorImage.getWidth();
        if (imageWidth != (imageHeight = this.colorImage.getHeight())) {
            throw new RuntimeException("imageWidth: " + imageWidth + " != imageHeight: " + imageHeight);
        }
        this.size = imageWidth;
        ByteBuffer buf = this.colorImage.getData(0);
        this.heightData = new float[imageWidth * imageHeight];
        ColorRGBA colorStore = new ColorRGBA();
        int index = 0;
        if (flipY) {
            for (int h = 0; h < imageHeight; ++h) {
                int baseIndex;
                int w;
                if (flipX) {
                    for (w = imageWidth - 1; w >= 0; --w) {
                        baseIndex = h * imageWidth + w;
                        this.heightData[index++] = this.getHeightAtPostion(buf, this.colorImage, baseIndex, colorStore) * this.heightScale;
                    }
                    continue;
                }
                for (w = 0; w < imageWidth; ++w) {
                    baseIndex = h * imageWidth + w;
                    this.heightData[index++] = this.getHeightAtPostion(buf, this.colorImage, baseIndex, colorStore) * this.heightScale;
                }
            }
        } else {
            for (int h = imageHeight - 1; h >= 0; --h) {
                int baseIndex;
                int w;
                if (flipX) {
                    for (w = imageWidth - 1; w >= 0; --w) {
                        baseIndex = h * imageWidth + w;
                        this.heightData[index++] = this.getHeightAtPostion(buf, this.colorImage, baseIndex, colorStore) * this.heightScale;
                    }
                    continue;
                }
                for (w = 0; w < imageWidth; ++w) {
                    baseIndex = h * imageWidth + w;
                    this.heightData[index++] = this.getHeightAtPostion(buf, this.colorImage, baseIndex, colorStore) * this.heightScale;
                }
            }
        }
        return true;
    }

    protected float getHeightAtPostion(ByteBuffer buf, Image image, int position, ColorRGBA store) {
        switch (image.getFormat()) {
            case RGBA8: {
                buf.position(position * 4);
                store.set(this.byte2float(buf.get()), this.byte2float(buf.get()), this.byte2float(buf.get()), this.byte2float(buf.get()));
                return this.calculateHeight(store.r, store.g, store.b);
            }
            case ABGR8: {
                buf.position(position * 4);
                float a = this.byte2float(buf.get());
                float b = this.byte2float(buf.get());
                float g = this.byte2float(buf.get());
                float r = this.byte2float(buf.get());
                store.set(r, g, b, a);
                return this.calculateHeight(store.r, store.g, store.b);
            }
            case RGB8: {
                buf.position(position * 3);
                store.set(this.byte2float(buf.get()), this.byte2float(buf.get()), this.byte2float(buf.get()), 1.0f);
                return this.calculateHeight(store.r, store.g, store.b);
            }
            case Luminance8: {
                buf.position(position);
                return this.byte2float(buf.get()) * 255.0f * this.heightScale;
            }
            case Luminance16: {
                ShortBuffer sbuf = buf.asShortBuffer();
                sbuf.position(position);
                return (float)(sbuf.get() & 0xFFFF) / 65535.0f * 255.0f * this.heightScale;
            }
        }
        throw new UnsupportedOperationException("Image format: " + image.getFormat());
    }

    private float byte2float(byte b) {
        return (float)(b & 0xFF) / 255.0f;
    }
}

