/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.geomipmap;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.terrain.geomipmap.TerrainQuad;
import java.io.IOException;

public class NormalRecalcControl
extends AbstractControl {
    private TerrainQuad terrain;

    public NormalRecalcControl() {
    }

    public NormalRecalcControl(TerrainQuad terrain) {
        this.terrain = terrain;
    }

    protected void controlUpdate(float tpf) {
        this.terrain.updateNormals();
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public Control cloneForSpatial(Spatial spatial) {
        NormalRecalcControl control = new NormalRecalcControl(this.terrain);
        control.setSpatial(spatial);
        control.setEnabled(true);
        return control;
    }

    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        if (spatial instanceof TerrainQuad) {
            this.terrain = (TerrainQuad)spatial;
        }
    }

    public TerrainQuad getTerrain() {
        return this.terrain;
    }

    public void setTerrain(TerrainQuad terrain) {
        this.terrain = terrain;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write((Savable)this.terrain, "terrain", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.terrain = (TerrainQuad)ic.readSavable("terrain", null);
    }
}

