/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import org.bushe.swing.event.CleanupEvent;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.Logger;
import org.bushe.swing.event.Prioritized;
import org.bushe.swing.event.ProxySubscriber;
import org.bushe.swing.event.PublicationStatus;
import org.bushe.swing.event.PublicationStatusTracker;
import org.bushe.swing.event.SubscriberTimingEvent;
import org.bushe.swing.event.VetoEventListener;
import org.bushe.swing.event.VetoTopicEventListener;
import org.bushe.swing.event.annotation.ReferenceStrength;
import org.bushe.swing.exception.SwingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadSafeEventService
implements EventService {
    public static final Integer CLEANUP_START_THRESHOLD_DEFAULT = 250;
    public static final Integer CLEANUP_STOP_THRESHOLD_DEFAULT = 100;
    public static final Long CLEANUP_PERIOD_MS_DEFAULT = 1200000L;
    protected static final Logger LOG = Logger.getLogger(EventService.class.getName());
    private Map subscribersByEventType = new HashMap();
    private Map subscribersByEventClass = new HashMap();
    private Map subscribersByExactEventClass = new HashMap();
    private Map subscribersByTopic = new HashMap();
    private Map subscribersByTopicPattern = new HashMap();
    private Map vetoListenersByClass = new HashMap();
    private Map vetoListenersByExactClass = new HashMap();
    private Map vetoListenersByTopic = new HashMap();
    private Map vetoListenersByTopicPattern = new HashMap();
    private final Object listenerLock = new Object();
    private final Object cacheLock = new Object();
    private Long timeThresholdForEventTimingEventPublication;
    private Map<Class, List> cacheByEvent = new HashMap<Class, List>();
    private int defaultCacheSizePerClassOrTopic = 0;
    private Map<Class, Integer> cacheSizesForEventClass;
    private Map<Class, Integer> rawCacheSizesForEventClass;
    private boolean rawCacheSizesForEventClassChanged;
    private Map<String, List> cacheByTopic = new HashMap<String, List>();
    private Map<String, Integer> cacheSizesForTopic;
    private Map<String, Integer> rawCacheSizesForTopic;
    private boolean rawCacheSizesForTopicChanged;
    private Map<PatternWrapper, Integer> rawCacheSizesForPattern;
    private boolean rawCacheSizesForPatternChanged;
    private Integer cleanupStartThreshhold;
    private Integer cleanupStopThreshold;
    private Long cleanupPeriodMS;
    private int weakRefPlusProxySubscriberCount;
    private Timer cleanupTimer;
    private TimerTask cleanupTimerTask;
    private static final Comparator PRIORITIZED_SUBSCRIBER_COMPARATOR = new PrioritizedSubscriberComparator();
    private boolean hasEverUsedPrioritized;

    public ThreadSafeEventService() {
        this(null, false, null, null, null);
    }

    public ThreadSafeEventService(Long timeThresholdForEventTimingEventPublication) {
        this(timeThresholdForEventTimingEventPublication, false, null, null, null);
    }

    public ThreadSafeEventService(Long timeThresholdForEventTimingEventPublication, boolean subscribeTimingEventsInternally) {
        this(timeThresholdForEventTimingEventPublication, subscribeTimingEventsInternally, null, null, null);
    }

    public ThreadSafeEventService(Integer cleanupStartThreshold, Integer cleanupStopThreshold, Long cleanupPeriodMS) {
        this(null, false, cleanupStartThreshold, cleanupStopThreshold, cleanupPeriodMS);
    }

    public ThreadSafeEventService(Long timeThresholdForEventTimingEventPublication, boolean subscribeTimingEventsInternally, Integer cleanupStartThreshold, Integer cleanupStopThreshold, Long cleanupPeriodMS) {
        if (timeThresholdForEventTimingEventPublication == null && subscribeTimingEventsInternally) {
            throw new IllegalArgumentException("null, true in constructor is not valid.  If you want to send timing messages for all events and subscribe them internally, pass 0, true");
        }
        this.timeThresholdForEventTimingEventPublication = timeThresholdForEventTimingEventPublication;
        if (subscribeTimingEventsInternally) {
            this.subscribeStrongly(SubscriberTimingEvent.class, new EventSubscriber(){

                public void onEvent(Object event) {
                    ThreadSafeEventService.this.subscribeTiming((SubscriberTimingEvent)event);
                }
            });
        }
        this.cleanupStartThreshhold = cleanupStartThreshold == null ? CLEANUP_START_THRESHOLD_DEFAULT : cleanupStartThreshold;
        this.cleanupStopThreshold = cleanupStopThreshold == null ? CLEANUP_STOP_THRESHOLD_DEFAULT : cleanupStopThreshold;
        this.cleanupPeriodMS = cleanupPeriodMS == null ? CLEANUP_PERIOD_MS_DEFAULT : cleanupPeriodMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCleanupStartThreshhold() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.cleanupStartThreshhold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupStartThreshhold(Integer cleanupStartThreshhold) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.cleanupStartThreshhold = cleanupStartThreshhold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCleanupStopThreshold() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.cleanupStopThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupStopThreshold(Integer cleanupStopThreshold) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.cleanupStopThreshold = cleanupStopThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getCleanupPeriodMS() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.cleanupPeriodMS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCleanupPeriodMS(Long cleanupPeriodMS) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.cleanupPeriodMS = cleanupPeriodMS;
        }
    }

    @Override
    public boolean subscribe(Class cl, EventSubscriber eh) {
        if (cl == null) {
            throw new IllegalArgumentException("Event class must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by class, class:" + cl + ", subscriber:" + eh);
        }
        return this.subscribe(cl, this.subscribersByEventClass, new WeakReference<EventSubscriber>(eh));
    }

    @Override
    public boolean subscribe(Type type, EventSubscriber eh) {
        return this.subscribe(type, this.subscribersByEventType, new WeakReference<EventSubscriber>(eh));
    }

    @Override
    public boolean subscribeExactly(Class cl, EventSubscriber eh) {
        if (cl == null) {
            throw new IllegalArgumentException("Event class must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by class, class:" + cl + ", subscriber:" + eh);
        }
        return this.subscribe(cl, this.subscribersByExactEventClass, new WeakReference<EventSubscriber>(eh));
    }

    @Override
    public boolean subscribe(String topic, EventTopicSubscriber eh) {
        if (topic == null) {
            throw new IllegalArgumentException("Topic must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event topic subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by topic name, name:" + topic + ", subscriber:" + eh);
        }
        return this.subscribe(topic, this.subscribersByTopic, new WeakReference<EventTopicSubscriber>(eh));
    }

    @Override
    public boolean subscribe(Pattern pat, EventTopicSubscriber eh) {
        if (pat == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by pattern, pattern:" + pat + ", subscriber:" + eh);
        }
        PatternWrapper patternWrapper = new PatternWrapper(pat);
        return this.subscribe(patternWrapper, this.subscribersByTopicPattern, new WeakReference<EventTopicSubscriber>(eh));
    }

    @Override
    public boolean subscribeStrongly(Class cl, EventSubscriber eh) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing weakly by class, class:" + cl + ", subscriber:" + eh);
        }
        if (eh == null) {
            throw new IllegalArgumentException("Subscriber cannot be null.");
        }
        return this.subscribe(cl, this.subscribersByEventClass, eh);
    }

    @Override
    public boolean subscribeExactlyStrongly(Class cl, EventSubscriber eh) {
        if (cl == null) {
            throw new IllegalArgumentException("Event class must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by class, class:" + cl + ", subscriber:" + eh);
        }
        return this.subscribe(cl, this.subscribersByExactEventClass, eh);
    }

    @Override
    public boolean subscribeStrongly(String name, EventTopicSubscriber eh) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing weakly by topic name, name:" + name + ", subscriber:" + eh);
        }
        if (eh == null) {
            throw new IllegalArgumentException("Subscriber cannot be null.");
        }
        return this.subscribe(name, this.subscribersByTopic, eh);
    }

    @Override
    public boolean subscribeStrongly(Pattern pat, EventTopicSubscriber eh) {
        if (pat == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        if (eh == null) {
            throw new IllegalArgumentException("Event subscriber must not be null");
        }
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("Subscribing by pattern, pattern:" + pat + ", subscriber:" + eh);
        }
        PatternWrapper patternWrapper = new PatternWrapper(pat);
        return this.subscribe(patternWrapper, this.subscribersByTopicPattern, eh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllSubscribers() {
        Object object = this.listenerLock;
        synchronized (object) {
            this.unsubscribeAllInMap(this.subscribersByEventType);
            this.unsubscribeAllInMap(this.subscribersByEventClass);
            this.unsubscribeAllInMap(this.subscribersByExactEventClass);
            this.unsubscribeAllInMap(this.subscribersByTopic);
            this.unsubscribeAllInMap(this.subscribersByTopicPattern);
            this.unsubscribeAllInMap(this.vetoListenersByClass);
            this.unsubscribeAllInMap(this.vetoListenersByExactClass);
            this.unsubscribeAllInMap(this.vetoListenersByTopic);
            this.unsubscribeAllInMap(this.vetoListenersByTopicPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeAllInMap(Map subscriberMap) {
        Object object = this.listenerLock;
        synchronized (object) {
            Set subscriptionKeys = subscriberMap.keySet();
            for (Object key : subscriptionKeys) {
                List subscribers = (List)subscriberMap.get(key);
                while (!subscribers.isEmpty()) {
                    this.unsubscribe(key, subscriberMap, subscribers.get(0));
                }
            }
        }
    }

    @Override
    public boolean subscribeVetoListener(Class eventClass, VetoEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoEventListener cannot be null.");
        }
        if (eventClass == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(eventClass, this.vetoListenersByClass, new WeakReference<VetoEventListener>(vetoListener));
    }

    @Override
    public boolean subscribeVetoListenerExactly(Class eventClass, VetoEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoEventListener cannot be null.");
        }
        if (eventClass == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(eventClass, this.vetoListenersByExactClass, new WeakReference<VetoEventListener>(vetoListener));
    }

    @Override
    public boolean subscribeVetoListener(String topic, VetoTopicEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoEventListener cannot be null.");
        }
        if (topic == null) {
            throw new IllegalArgumentException("topic cannot be null.");
        }
        return this.subscribeVetoListener(topic, this.vetoListenersByTopic, new WeakReference<VetoTopicEventListener>(vetoListener));
    }

    @Override
    public boolean subscribeVetoListener(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoEventListener cannot be null.");
        }
        if (topicPattern == null) {
            throw new IllegalArgumentException("topicPattern cannot be null.");
        }
        PatternWrapper patternWrapper = new PatternWrapper(topicPattern);
        return this.subscribeVetoListener(patternWrapper, this.vetoListenersByTopicPattern, new WeakReference<VetoTopicEventListener>(vetoListener));
    }

    @Override
    public boolean subscribeVetoListenerStrongly(Class eventClass, VetoEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoEventListener cannot be null.");
        }
        if (eventClass == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(eventClass, this.vetoListenersByClass, vetoListener);
    }

    @Override
    public boolean subscribeVetoListenerExactlyStrongly(Class eventClass, VetoEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoEventListener cannot be null.");
        }
        if (eventClass == null) {
            throw new IllegalArgumentException("eventClass cannot be null.");
        }
        return this.subscribeVetoListener(eventClass, this.vetoListenersByExactClass, vetoListener);
    }

    @Override
    public boolean subscribeVetoListenerStrongly(String topic, VetoTopicEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoListener cannot be null.");
        }
        if (topic == null) {
            throw new IllegalArgumentException("topic cannot be null.");
        }
        return this.subscribeVetoListener(topic, this.vetoListenersByTopic, vetoListener);
    }

    @Override
    public boolean subscribeVetoListenerStrongly(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        if (vetoListener == null) {
            throw new IllegalArgumentException("VetoTopicEventListener cannot be null.");
        }
        if (topicPattern == null) {
            throw new IllegalArgumentException("topicPattern cannot be null.");
        }
        PatternWrapper patternWrapper = new PatternWrapper(topicPattern);
        return this.subscribeVetoListener(patternWrapper, this.vetoListenersByTopicPattern, vetoListener);
    }

    protected boolean subscribeVetoListener(Object subscription, Map vetoListenerMap, Object vetoListener) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("subscribeVetoListener(" + subscription + "," + vetoListener + ")");
        }
        if (vetoListener == null) {
            throw new IllegalArgumentException("Can't subscribe null veto listener to " + subscription);
        }
        if (subscription == null) {
            throw new IllegalArgumentException("Can't subscribe veto listener to null.");
        }
        return this.subscribe(subscription, vetoListenerMap, vetoListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean subscribe(Object classTopicOrPatternWrapper, Map<Object, Object> subscriberMap, Object subscriber) {
        if (classTopicOrPatternWrapper == null) {
            throw new IllegalArgumentException("Can't subscribe to null.");
        }
        if (subscriber == null) {
            throw new IllegalArgumentException("Can't subscribe null subscriber to " + classTopicOrPatternWrapper);
        }
        boolean alreadyExists = false;
        Object realSubscriber = subscriber;
        boolean isWeakRef = subscriber instanceof WeakReference;
        if (isWeakRef) {
            realSubscriber = ((WeakReference)subscriber).get();
        }
        if (realSubscriber instanceof Prioritized) {
            this.hasEverUsedPrioritized = true;
        }
        boolean isWeakProxySubscriber = false;
        if (subscriber instanceof ProxySubscriber) {
            ProxySubscriber proxySubscriber = (ProxySubscriber)subscriber;
            if (proxySubscriber instanceof Prioritized) {
                this.hasEverUsedPrioritized = true;
            }
            boolean bl = isWeakProxySubscriber = proxySubscriber.getReferenceStrength() == ReferenceStrength.WEAK;
            if (isWeakProxySubscriber) {
                realSubscriber = ((ProxySubscriber)subscriber).getProxiedSubscriber();
            }
        }
        if (isWeakRef && isWeakProxySubscriber) {
            throw new IllegalArgumentException("ProxySubscribers should always be subscribed strongly.");
        }
        if (realSubscriber == null) {
            return false;
        }
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<Object> currentSubscribers = (ArrayList<Object>)subscriberMap.get(classTopicOrPatternWrapper);
            if (currentSubscribers == null) {
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Creating new subscriber map for:" + classTopicOrPatternWrapper);
                }
                currentSubscribers = new ArrayList<Object>();
                subscriberMap.put(classTopicOrPatternWrapper, currentSubscribers);
            } else {
                Iterator iterator = currentSubscribers.iterator();
                while (iterator.hasNext()) {
                    Object currentSubscriber = iterator.next();
                    Object realCurrentSubscriber = this.getRealSubscriberAndCleanStaleSubscriberIfNecessary(iterator, currentSubscriber);
                    if (!realSubscriber.equals(realCurrentSubscriber)) continue;
                    iterator.remove();
                    alreadyExists = true;
                }
            }
            currentSubscribers.add(subscriber);
            if (isWeakProxySubscriber || isWeakRef) {
                this.incWeakRefPlusProxySubscriberCount();
            }
            return !alreadyExists;
        }
    }

    @Override
    public boolean unsubscribe(Class cl, EventSubscriber eh) {
        return this.unsubscribe(cl, this.subscribersByEventClass, eh);
    }

    @Override
    public boolean unsubscribeExactly(Class cl, EventSubscriber eh) {
        return this.unsubscribe(cl, this.subscribersByExactEventClass, eh);
    }

    @Override
    public boolean unsubscribe(String name, EventTopicSubscriber eh) {
        return this.unsubscribe(name, this.subscribersByTopic, eh);
    }

    @Override
    public boolean unsubscribe(Pattern topicPattern, EventTopicSubscriber eh) {
        PatternWrapper patternWrapper = new PatternWrapper(topicPattern);
        return this.unsubscribe(patternWrapper, this.subscribersByTopicPattern, eh);
    }

    @Override
    public boolean unsubscribe(Class eventClass, Object subscribedByProxy) {
        EventSubscriber subscriber = (EventSubscriber)((Object)this.getProxySubscriber(eventClass, subscribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribe(eventClass, subscriber);
    }

    @Override
    public boolean unsubscribeExactly(Class eventClass, Object subscribedByProxy) {
        EventSubscriber subscriber = (EventSubscriber)((Object)this.getProxySubscriber(eventClass, subscribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribeExactly(eventClass, subscriber);
    }

    @Override
    public boolean unsubscribe(String topic, Object subscribedByProxy) {
        EventTopicSubscriber subscriber = (EventTopicSubscriber)((Object)this.getProxySubscriber(topic, subscribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribe(topic, subscriber);
    }

    @Override
    public boolean unsubscribe(Pattern pattern, Object subscribedByProxy) {
        EventTopicSubscriber subscriber = (EventTopicSubscriber)((Object)this.getProxySubscriber(pattern, subscribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribe(pattern, subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unsubscribe(Object o, Map subscriberMap, Object subscriber) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("unsubscribe(" + o + "," + subscriber + ")");
        }
        if (o == null) {
            throw new IllegalArgumentException("Can't unsubscribe to null.");
        }
        if (subscriber == null) {
            throw new IllegalArgumentException("Can't unsubscribe null subscriber to " + o);
        }
        Object object = this.listenerLock;
        synchronized (object) {
            return this.removeFromSetResolveWeakReferences(subscriberMap, o, subscriber);
        }
    }

    @Override
    public boolean unsubscribeVeto(Class eventClass, Object subscribedByProxy) {
        VetoEventListener subscriber = (VetoEventListener)((Object)this.getVetoProxySubscriber(eventClass, subscribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribeVetoListener(eventClass, subscriber);
    }

    @Override
    public boolean unsubscribeVetoExactly(Class eventClass, Object subscribedByProxy) {
        VetoEventListener subscriber = (VetoEventListener)((Object)this.getVetoProxySubscriber(eventClass, subscribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribeVetoListenerExactly(eventClass, subscriber);
    }

    @Override
    public boolean unsubscribeVeto(String topic, Object subscribedByProxy) {
        VetoTopicEventListener subscriber = (VetoTopicEventListener)((Object)this.getVetoProxySubscriber(topic, subscribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribeVetoListener(topic, subscriber);
    }

    @Override
    public boolean unsubscribeVeto(Pattern pattern, Object subscribedByProxy) {
        VetoTopicEventListener subscriber = (VetoTopicEventListener)((Object)this.getVetoProxySubscriber(pattern, subscribedByProxy));
        if (subscriber == null) {
            return false;
        }
        return this.unsubscribeVetoListener(pattern, subscriber);
    }

    @Override
    public boolean unsubscribeVetoListener(Class eventClass, VetoEventListener vetoListener) {
        return this.unsubscribeVetoListener(eventClass, this.vetoListenersByClass, vetoListener);
    }

    @Override
    public boolean unsubscribeVetoListenerExactly(Class eventClass, VetoEventListener vetoListener) {
        return this.unsubscribeVetoListener(eventClass, this.vetoListenersByExactClass, vetoListener);
    }

    @Override
    public boolean unsubscribeVetoListener(String topic, VetoTopicEventListener vetoListener) {
        return this.unsubscribeVetoListener(topic, this.vetoListenersByTopic, vetoListener);
    }

    @Override
    public boolean unsubscribeVetoListener(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        PatternWrapper patternWrapper = new PatternWrapper(topicPattern);
        return this.unsubscribeVetoListener(patternWrapper, this.vetoListenersByTopicPattern, vetoListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unsubscribeVetoListener(Object o, Map vetoListenerMap, Object vl) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            LOG.debug("unsubscribeVetoListener(" + o + "," + vl + ")");
        }
        if (o == null) {
            throw new IllegalArgumentException("Can't unsubscribe veto listener to null.");
        }
        if (vl == null) {
            throw new IllegalArgumentException("Can't unsubscribe null veto listener to " + o);
        }
        Object object = this.listenerLock;
        synchronized (object) {
            return this.removeFromSetResolveWeakReferences(vetoListenerMap, o, vl);
        }
    }

    private ProxySubscriber getProxySubscriber(Class eventClass, Object subscribedByProxy) {
        List subscribers = this.getSubscribers(eventClass);
        return this.getProxySubscriber(subscribers, subscribedByProxy);
    }

    private ProxySubscriber getProxySubscriber(String topic, Object subscribedByProxy) {
        List subscribers = this.getSubscribers(topic);
        return this.getProxySubscriber(subscribers, subscribedByProxy);
    }

    private ProxySubscriber getProxySubscriber(Pattern pattern, Object subscribedByProxy) {
        List subscribers = this.getSubscribersToPattern(pattern);
        return this.getProxySubscriber(subscribers, subscribedByProxy);
    }

    private ProxySubscriber getVetoProxySubscriber(Class eventClass, Object subscribedByProxy) {
        List subscribers = this.getVetoSubscribers(eventClass);
        return this.getProxySubscriber(subscribers, subscribedByProxy);
    }

    private ProxySubscriber getVetoProxySubscriber(String topic, Object subscribedByProxy) {
        List subscribers = this.getVetoSubscribers(topic);
        return this.getProxySubscriber(subscribers, subscribedByProxy);
    }

    private ProxySubscriber getVetoProxySubscriber(Pattern pattern, Object subscribedByProxy) {
        List subscribers = this.getVetoSubscribers(pattern);
        return this.getProxySubscriber(subscribers, subscribedByProxy);
    }

    private ProxySubscriber getProxySubscriber(List subscribers, Object subscribedByProxy) {
        for (Object subscriber : subscribers) {
            ProxySubscriber proxy;
            if (subscriber instanceof WeakReference) {
                WeakReference wr = (WeakReference)subscriber;
                subscriber = wr.get();
            }
            if (!(subscriber instanceof ProxySubscriber) || (subscriber = (proxy = (ProxySubscriber)subscriber).getProxiedSubscriber()) != subscribedByProxy) continue;
            return proxy;
        }
        return null;
    }

    @Override
    public void publish(Object event) {
        if (event == null) {
            throw new IllegalArgumentException("Cannot publish null event.");
        }
        this.publish(event, null, null, this.getSubscribers(event.getClass()), this.getVetoSubscribers(event.getClass()), null);
    }

    @Override
    public void publish(Type genericType, Object event) {
        if (genericType == null) {
            throw new IllegalArgumentException("genericType must not be null.");
        }
        if (event == null) {
            throw new IllegalArgumentException("Cannot publish null event.");
        }
        this.publish(event, null, null, this.getSubscribers(genericType), null, null);
    }

    @Override
    public void publish(String topicName, Object eventObj) {
        this.publish(null, topicName, eventObj, this.getSubscribers(topicName), this.getVetoEventListeners(topicName), null);
    }

    protected void publish(Object event, String topic, Object eventObj, List subscribers, List vetoSubscribers, StackTraceElement[] callingStack) {
        if (event == null && topic == null) {
            throw new IllegalArgumentException("Can't publish to null topic/event.");
        }
        this.setStatus(PublicationStatus.Initiated, event, topic, eventObj);
        this.logEvent(event, topic, eventObj);
        if (this.checkVetoSubscribers(event, topic, eventObj, vetoSubscribers, callingStack)) {
            this.setStatus(PublicationStatus.Vetoed, event, topic, eventObj);
            return;
        }
        this.setStatus(PublicationStatus.Queued, event, topic, eventObj);
        this.addEventToCache(event, topic, eventObj);
        if (subscribers == null || subscribers.isEmpty()) {
            if (LOG.isLoggable(Logger.Level.DEBUG)) {
                LOG.debug("No subscribers for event or topic. Event:" + event + ", Topic:" + topic);
            }
        } else {
            if (LOG.isLoggable(Logger.Level.DEBUG)) {
                LOG.debug("Publishing to subscribers:" + subscribers);
            }
            this.setStatus(PublicationStatus.Publishing, event, topic, eventObj);
            for (int i = 0; i < subscribers.size(); ++i) {
                Object eh = subscribers.get(i);
                if (event != null) {
                    EventSubscriber eventSubscriber = (EventSubscriber)eh;
                    long start = System.currentTimeMillis();
                    try {
                        eventSubscriber.onEvent(event);
                        this.checkTimeLimit(start, event, eventSubscriber, null);
                    }
                    catch (Throwable e) {
                        this.checkTimeLimit(start, event, eventSubscriber, null);
                        this.handleException(event, e, callingStack, eventSubscriber);
                    }
                    continue;
                }
                EventTopicSubscriber eventTopicSubscriber = (EventTopicSubscriber)eh;
                try {
                    eventTopicSubscriber.onEvent(topic, eventObj);
                    continue;
                }
                catch (Throwable e) {
                    this.onEventException(topic, eventObj, e, callingStack, eventTopicSubscriber);
                }
            }
        }
        this.setStatus(PublicationStatus.Completed, event, topic, eventObj);
    }

    protected void setStatus(PublicationStatus status, Object event, String topic, Object eventObj) {
        if (event instanceof PublicationStatusTracker) {
            ((PublicationStatusTracker)event).setPublicationStatus(status);
        }
        if (eventObj instanceof PublicationStatusTracker) {
            ((PublicationStatusTracker)eventObj).setPublicationStatus(status);
        }
    }

    private List sortSubscribers(List subscribers) {
        if (subscribers == null) {
            return null;
        }
        ArrayList<Prioritized> prioritizedSubscribers = null;
        Iterator iterator = subscribers.iterator();
        while (iterator.hasNext()) {
            Prioritized prioritized;
            Object subscriber = iterator.next();
            if (!(subscriber instanceof Prioritized) || (prioritized = (Prioritized)subscriber).getPriority() == 0) continue;
            iterator.remove();
            if (prioritizedSubscribers == null) {
                prioritizedSubscribers = new ArrayList<Prioritized>();
            }
            prioritizedSubscribers.add(prioritized);
        }
        if (prioritizedSubscribers == null) {
            return subscribers;
        }
        ArrayList result = new ArrayList(prioritizedSubscribers.size() + subscribers.size());
        Collections.sort(prioritizedSubscribers, PRIORITIZED_SUBSCRIBER_COMPARATOR);
        boolean haveAddedFIFOSubscribers = false;
        for (Prioritized prioritizedSubscriber : prioritizedSubscribers) {
            if (prioritizedSubscriber.getPriority() > 0 && !haveAddedFIFOSubscribers) {
                for (Object subscriber : subscribers) {
                    result.add(subscriber);
                }
                haveAddedFIFOSubscribers = true;
            }
            result.add(prioritizedSubscriber);
        }
        if (!haveAddedFIFOSubscribers) {
            for (Object subscriber : subscribers) {
                result.add(subscriber);
            }
        }
        return result;
    }

    private boolean checkVetoSubscribers(Object event, String topic, Object eventObj, List vetoSubscribers, StackTraceElement[] callingStack) {
        if (vetoSubscribers != null && !vetoSubscribers.isEmpty()) {
            for (Object vetoer : vetoSubscribers) {
                VetoEventListener vl = null;
                VetoTopicEventListener vtl = null;
                if (event == null) {
                    vtl = (VetoTopicEventListener)vetoer;
                } else {
                    vl = (VetoEventListener)vetoer;
                }
                long start = System.currentTimeMillis();
                try {
                    boolean shouldVeto = false;
                    shouldVeto = event == null ? vtl.shouldVeto(topic, eventObj) : vl.shouldVeto(event);
                    if (!shouldVeto) continue;
                    this.handleVeto(vl, event, vtl, topic, eventObj);
                    this.checkTimeLimit(start, event, null, vl);
                    if (LOG.isLoggable(Logger.Level.DEBUG)) {
                        LOG.debug("Publication vetoed. Event:" + event + ", Topic:" + topic + ", veto subscriber:" + vl);
                    }
                    return true;
                }
                catch (Throwable ex) {
                    this.checkTimeLimit(start, event, null, vl);
                    this.subscribeVetoException(event, topic, eventObj, ex, callingStack, vl);
                }
            }
        }
        return false;
    }

    private void logEvent(Object event, String topic, Object eventObj) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            if (event != null) {
                LOG.debug("Publishing event: class=" + event.getClass() + ", event=" + event);
            } else if (topic != null) {
                LOG.debug("Publishing event: topic=" + topic + ", eventObj=" + eventObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEventToCache(Object event, String topic, Object eventObj) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (event != null) {
                int cacheSizeForEventClass = this.getCacheSizeForEventClass(event.getClass());
                LinkedList<Object> eventClassCache = this.cacheByEvent.get(event.getClass());
                if (cacheSizeForEventClass <= 0) {
                    if (eventClassCache != null) {
                        this.cacheByEvent.remove(event.getClass());
                    }
                } else {
                    if (eventClassCache == null) {
                        eventClassCache = new LinkedList<Object>();
                        this.cacheByEvent.put(event.getClass(), eventClassCache);
                    }
                    eventClassCache.add(0, event);
                    while (eventClassCache.size() > cacheSizeForEventClass) {
                        eventClassCache.remove(eventClassCache.size() - 1);
                    }
                }
            } else {
                int cacheSizeForTopic = this.getCacheSizeForTopic(topic);
                LinkedList<Object> topicCache = this.cacheByTopic.get(topic);
                if (cacheSizeForTopic <= 0) {
                    if (topicCache != null) {
                        topicCache.remove(topic);
                    }
                } else {
                    if (topicCache == null) {
                        topicCache = new LinkedList<Object>();
                        this.cacheByTopic.put(topic, topicCache);
                    }
                    topicCache.add(0, eventObj);
                    while (topicCache.size() > cacheSizeForTopic) {
                        topicCache.remove(topicCache.size() - 1);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getSubscribers(Class<T> eventClass) {
        List<T> exactMatches;
        List<T> hierarchyMatches;
        Object object = this.listenerLock;
        synchronized (object) {
            hierarchyMatches = this.getSubscribersToClass(eventClass);
            exactMatches = this.getSubscribersToExactClass(eventClass);
        }
        List<Object> result = new ArrayList<T>();
        if (exactMatches != null) {
            result.addAll(exactMatches);
        }
        if (hierarchyMatches != null) {
            result.addAll(hierarchyMatches);
        }
        if (this.hasEverUsedPrioritized) {
            result = this.sortSubscribers(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getSubscribersToClass(Class<T> eventClass) {
        Object object = this.listenerLock;
        synchronized (object) {
            Map classMap = this.subscribersByEventClass;
            List result = this.getEventOrVetoSubscribersToClass(classMap, eventClass);
            if (this.hasEverUsedPrioritized) {
                result = this.sortSubscribers(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getSubscribersToExactClass(Class<T> eventClass) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(eventClass, this.subscribersByExactEventClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getSubscribers(Type eventType) {
        List result;
        Object object = this.listenerLock;
        synchronized (object) {
            result = this.getEventOrVetoSubscribersToType(this.subscribersByEventType, eventType);
        }
        if (this.hasEverUsedPrioritized) {
            result = this.sortSubscribers(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getSubscribers(String topic) {
        List<T> patternMatches;
        List<T> exactMatches;
        List<Object> result = new ArrayList<T>();
        Object object = this.listenerLock;
        synchronized (object) {
            exactMatches = this.getSubscribersToTopic(topic);
            patternMatches = this.getSubscribersByPattern(topic);
        }
        if (exactMatches != null) {
            result.addAll(exactMatches);
        }
        if (patternMatches != null) {
            result.addAll(patternMatches);
        }
        if (this.hasEverUsedPrioritized) {
            result = this.sortSubscribers(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getSubscribersToTopic(String topic) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(topic, this.subscribersByTopic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getSubscribers(Pattern pattern) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(pattern, this.subscribersByTopicPattern);
        }
    }

    @Override
    public <T> List<T> getSubscribersByPattern(String topic) {
        return this.getSubscribersByPattern(topic, this.subscribersByTopicPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getVetoSubscribers(Class<T> eventClass) {
        List<T> hierarchyMatches;
        List<T> exactMatches;
        List<Object> result = new ArrayList<T>();
        Object object = this.listenerLock;
        synchronized (object) {
            exactMatches = this.getVetoSubscribersToClass(eventClass);
            hierarchyMatches = this.getVetoSubscribersToExactClass(eventClass);
        }
        if (exactMatches != null) {
            result.addAll(exactMatches);
        }
        if (hierarchyMatches != null) {
            result.addAll(hierarchyMatches);
        }
        if (this.hasEverUsedPrioritized) {
            result = this.sortSubscribers(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getVetoSubscribersToClass(Class<T> eventClass) {
        List result;
        Object object = this.listenerLock;
        synchronized (object) {
            Map classMap = this.vetoListenersByClass;
            result = this.getEventOrVetoSubscribersToClass(classMap, eventClass);
        }
        if (this.hasEverUsedPrioritized) {
            result = this.sortSubscribers(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getVetoSubscribersToExactClass(Class<T> eventClass) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(eventClass, this.vetoListenersByExactClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getVetoEventListeners(String topicOrPattern) {
        List<T> patternMatches;
        List<T> exactMatches;
        List<Object> result = new ArrayList<T>();
        Object object = this.listenerLock;
        synchronized (object) {
            exactMatches = this.getVetoSubscribersToTopic(topicOrPattern);
            patternMatches = this.getVetoSubscribersByPattern(topicOrPattern);
        }
        if (exactMatches != null) {
            result.addAll(exactMatches);
        }
        if (patternMatches != null) {
            result.addAll(patternMatches);
        }
        if (this.hasEverUsedPrioritized) {
            result = this.sortSubscribers(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getVetoSubscribersToTopic(String topic) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getSubscribers(topic, this.vetoListenersByTopic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getVetoSubscribers(String topic) {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.getVetoSubscribersToTopic(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> getVetoSubscribers(Pattern topicPattern) {
        Object object = this.listenerLock;
        synchronized (object) {
            PatternWrapper patternWrapper = new PatternWrapper(topicPattern);
            return this.getSubscribers(patternWrapper, this.vetoListenersByTopicPattern);
        }
    }

    @Override
    public <T> List<T> getVetoSubscribersByPattern(String pattern) {
        return this.getSubscribersByPattern(pattern, this.vetoListenersByTopicPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> getSubscribersByPattern(String topic, Map subscribersByTopicPattern) {
        List result = new ArrayList();
        Object object = this.listenerLock;
        synchronized (object) {
            Set keys = subscribersByTopicPattern.keySet();
            for (PatternWrapper patternKey : keys) {
                if (!patternKey.matches(topic)) continue;
                if (LOG.isLoggable(Logger.Level.DEBUG)) {
                    LOG.debug("Pattern " + patternKey + " matched topic name " + topic);
                }
                Collection subscribers = (Collection)subscribersByTopicPattern.get(patternKey);
                result.addAll(this.createCopyOfContentsRemoveWeakRefs(subscribers));
            }
            if (this.hasEverUsedPrioritized) {
                result = this.sortSubscribers(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> List<T> getSubscribersToPattern(Pattern topicPattern) {
        Object object = this.listenerLock;
        synchronized (object) {
            PatternWrapper patternWrapper = new PatternWrapper(topicPattern);
            return this.getSubscribers(patternWrapper, this.subscribersByTopicPattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getSubscribers(Object classOrTopic, Map subscriberMap) {
        List result;
        Object object = this.listenerLock;
        synchronized (object) {
            List subscribers = (List)subscriberMap.get(classOrTopic);
            result = this.createCopyOfContentsRemoveWeakRefs(subscribers);
        }
        if (this.hasEverUsedPrioritized) {
            result = this.sortSubscribers(result);
        }
        return result;
    }

    private List getEventOrVetoSubscribersToClass(Map classMap, Class eventClass) {
        ArrayList result = new ArrayList();
        Set keys = classMap.keySet();
        for (Class cl : keys) {
            if (!cl.isAssignableFrom(eventClass)) continue;
            if (LOG.isLoggable(Logger.Level.DEBUG)) {
                LOG.debug("Hierarchical match " + cl + " matched event of class " + eventClass);
            }
            Collection subscribers = (Collection)classMap.get(cl);
            result.addAll(this.createCopyOfContentsRemoveWeakRefs(subscribers));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getEventOrVetoSubscribersToType(Map typeMap, Type eventType) {
        ArrayList result = new ArrayList();
        Set mapKeySet = typeMap.keySet();
        for (Object mapKey : mapKeySet) {
            Collection subscribers;
            Type subscriberType = (Type)mapKey;
            if (!(eventType instanceof ParameterizedType) || !(subscriberType instanceof ParameterizedType)) continue;
            ParameterizedType subscriberPT = (ParameterizedType)subscriberType;
            ParameterizedType eventPT = (ParameterizedType)eventType;
            if (!eventPT.getRawType().equals(subscriberPT.getRawType())) continue;
            Type[] mapTypeArgs = subscriberPT.getActualTypeArguments();
            Type[] eventTypeArgs = eventPT.getActualTypeArguments();
            if (mapTypeArgs == null || eventTypeArgs == null || mapTypeArgs.length != eventTypeArgs.length) continue;
            boolean parameterArgsMatch = true;
            for (int argCount = 0; argCount < mapTypeArgs.length; ++argCount) {
                Type eventTypeArg = eventTypeArgs[argCount];
                if (eventTypeArg instanceof WildcardType) {
                    throw new IllegalArgumentException("Only simple Class parameterized types can be published, not wildcards, etc.  Published attempt made for:" + eventTypeArg);
                }
                Type subscriberTypeArg = mapTypeArgs[argCount];
                if (subscriberTypeArg instanceof WildcardType) {
                    WildcardType wildcardSubscriberTypeArg = (WildcardType)subscriberTypeArg;
                    Type[] upperBound = wildcardSubscriberTypeArg.getUpperBounds();
                    Type[] lowerBound = wildcardSubscriberTypeArg.getLowerBounds();
                    if (upperBound != null && upperBound.length > 0) {
                        if (!(upperBound[0] instanceof Class)) throw new IllegalArgumentException("Only Class and Interface types are supported as types of wildcard subscriptions.  Type:" + upperBound[0]);
                        Class upper = (Class)upperBound[0];
                        if (eventTypeArg instanceof Class) {
                            if (!upper.isAssignableFrom((Class)eventTypeArg)) {
                                parameterArgsMatch = false;
                                break;
                            }
                        } else {
                            parameterArgsMatch = false;
                            break;
                        }
                    }
                    if (lowerBound == null || lowerBound.length <= 0) continue;
                    if (!(lowerBound[0] instanceof Class)) throw new IllegalArgumentException("Only Class and Interface types are supported as types of wildcard subscriptions.  Type:" + upperBound[0]);
                    Class lower = (Class)lowerBound[0];
                    if (eventTypeArg instanceof Class) {
                        if (((Class)eventTypeArg).isAssignableFrom(lower)) continue;
                        parameterArgsMatch = false;
                        break;
                    }
                    parameterArgsMatch = false;
                    break;
                }
                if (subscriberTypeArg.equals(eventTypeArg)) continue;
                parameterArgsMatch = false;
                break;
            }
            if (!parameterArgsMatch) continue;
            if (LOG.isLoggable(Logger.Level.DEBUG)) {
                LOG.debug("Exact parameterized subscriberType match for event subscriberType " + eventType);
            }
            if ((subscribers = (Collection)typeMap.get(subscriberType)) == null) continue;
            result.addAll(this.createCopyOfContentsRemoveWeakRefs(subscribers));
        }
        return result;
    }

    private void checkTimeLimit(long start, Object event, EventSubscriber subscriber, VetoEventListener l) {
        if (this.timeThresholdForEventTimingEventPublication == null) {
            return;
        }
        long end = System.currentTimeMillis();
        if (end - start > this.timeThresholdForEventTimingEventPublication) {
            this.publish(new SubscriberTimingEvent(this, new Long(start), new Long(end), this.timeThresholdForEventTimingEventPublication, event, subscriber, l));
        }
    }

    protected void subscribeTiming(SubscriberTimingEvent event) {
        LOG.log(Logger.Level.INFO, event + "");
    }

    protected void handleVeto(VetoEventListener vl, Object event, VetoTopicEventListener vtl, String topic, Object eventObj) {
        if (LOG.isLoggable(Logger.Level.DEBUG)) {
            if (event != null) {
                LOG.debug("Vetoing event: class=" + event.getClass() + ", event=" + event + ", vetoer:" + vl);
            } else {
                LOG.debug("Vetoing event: topic=" + topic + ", eventObj=" + eventObj + ", vetoer:" + vtl);
            }
        }
    }

    private boolean removeFromSetResolveWeakReferences(Map map, Object key, Object toRemove) {
        List subscribers = (List)map.get(key);
        if (subscribers == null) {
            return false;
        }
        if (subscribers.remove(toRemove)) {
            if (toRemove instanceof WeakReference) {
                this.decWeakRefPlusProxySubscriberCount();
            }
            if (toRemove instanceof ProxySubscriber) {
                ((ProxySubscriber)toRemove).proxyUnsubscribed();
                this.decWeakRefPlusProxySubscriberCount();
            }
            return true;
        }
        Iterator iter = subscribers.iterator();
        while (iter.hasNext()) {
            ProxySubscriber proxy;
            ProxySubscriber proxy2;
            Object existingSubscriber = iter.next();
            if (existingSubscriber instanceof ProxySubscriber && (existingSubscriber = (proxy2 = (ProxySubscriber)existingSubscriber).getProxiedSubscriber()) == toRemove) {
                this.removeProxySubscriber(proxy2, iter);
                return true;
            }
            if (!(existingSubscriber instanceof WeakReference)) continue;
            WeakReference wr = (WeakReference)existingSubscriber;
            Object realRef = wr.get();
            if (realRef == null) {
                iter.remove();
                this.decWeakRefPlusProxySubscriberCount();
                return true;
            }
            if (realRef == toRemove) {
                iter.remove();
                this.decWeakRefPlusProxySubscriberCount();
                return true;
            }
            if (!(realRef instanceof ProxySubscriber) || (existingSubscriber = (proxy = (ProxySubscriber)realRef).getProxiedSubscriber()) != toRemove) continue;
            this.removeProxySubscriber(proxy, iter);
            return true;
        }
        return false;
    }

    private List createCopyOfContentsRemoveWeakRefs(Collection subscribersOrVetoListeners) {
        if (subscribersOrVetoListeners == null) {
            return null;
        }
        ArrayList<ProxySubscriber> copyOfSubscribersOrVetolisteners = new ArrayList<ProxySubscriber>(subscribersOrVetoListeners.size());
        Iterator iter = subscribersOrVetoListeners.iterator();
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (elem instanceof ProxySubscriber) {
                ProxySubscriber proxy = (ProxySubscriber)elem;
                if ((elem = proxy.getProxiedSubscriber()) == null) {
                    this.removeProxySubscriber(proxy, iter);
                    continue;
                }
                copyOfSubscribersOrVetolisteners.add(proxy);
                continue;
            }
            if (elem instanceof WeakReference) {
                Object hardRef = ((WeakReference)elem).get();
                if (hardRef == null) {
                    iter.remove();
                    this.decWeakRefPlusProxySubscriberCount();
                    continue;
                }
                copyOfSubscribersOrVetolisteners.add((ProxySubscriber)hardRef);
                continue;
            }
            copyOfSubscribersOrVetolisteners.add((ProxySubscriber)elem);
        }
        return copyOfSubscribersOrVetolisteners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultCacheSizePerClassOrTopic(int defaultCacheSizePerClassOrTopic) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.defaultCacheSizePerClassOrTopic = defaultCacheSizePerClassOrTopic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDefaultCacheSizePerClassOrTopic() {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.defaultCacheSizePerClassOrTopic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheSizeForEventClass(Class eventClass, int cacheSize) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.rawCacheSizesForEventClass == null) {
                this.rawCacheSizesForEventClass = new HashMap<Class, Integer>();
            }
            this.rawCacheSizesForEventClass.put(eventClass, new Integer(cacheSize));
            this.rawCacheSizesForEventClassChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCacheSizeForEventClass(Class eventClass) {
        if (eventClass == null) {
            throw new IllegalArgumentException("eventClass must not be null.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            Integer size;
            if (this.rawCacheSizesForEventClass == null || this.rawCacheSizesForEventClass.size() == 0) {
                return this.getDefaultCacheSizePerClassOrTopic();
            }
            if (this.cacheSizesForEventClass == null) {
                this.cacheSizesForEventClass = new HashMap<Class, Integer>();
            }
            if (this.rawCacheSizesForEventClassChanged) {
                this.cacheSizesForEventClass.clear();
                this.cacheSizesForEventClass.putAll(this.rawCacheSizesForEventClass);
                this.rawCacheSizesForEventClassChanged = false;
            }
            if ((size = this.cacheSizesForEventClass.get(eventClass)) != null) {
                return size;
            }
            for (Class parent = eventClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
                Integer parentSize = this.cacheSizesForEventClass.get(parent);
                if (parentSize == null) continue;
                this.cacheSizesForEventClass.put(eventClass, parentSize);
                return parentSize;
            }
            Class<?>[] interfaces = eventClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> anInterface = interfaces[i];
                Integer interfaceSize = this.cacheSizesForEventClass.get(anInterface);
                if (interfaceSize == null) continue;
                this.cacheSizesForEventClass.put(eventClass, interfaceSize);
                return interfaceSize;
            }
            return this.getDefaultCacheSizePerClassOrTopic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheSizeForTopic(String topicName, int cacheSize) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.rawCacheSizesForTopic == null) {
                this.rawCacheSizesForTopic = new HashMap<String, Integer>();
            }
            this.rawCacheSizesForTopic.put(topicName, new Integer(cacheSize));
            this.rawCacheSizesForTopicChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheSizeForTopic(Pattern pattern, int cacheSize) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.rawCacheSizesForPattern == null) {
                this.rawCacheSizesForPattern = new HashMap<PatternWrapper, Integer>();
            }
            PatternWrapper patternWrapper = new PatternWrapper(pattern);
            this.rawCacheSizesForPattern.put(patternWrapper, new Integer(cacheSize));
            this.rawCacheSizesForPatternChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCacheSizeForTopic(String topic) {
        if (topic == null) {
            throw new IllegalArgumentException("topic must not be null.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            Integer size;
            if ((this.rawCacheSizesForTopic == null || this.rawCacheSizesForTopic != null && this.rawCacheSizesForTopic.size() == 0) && (this.rawCacheSizesForPattern == null || this.rawCacheSizesForPattern != null && this.rawCacheSizesForPattern.size() == 0)) {
                return this.getDefaultCacheSizePerClassOrTopic();
            }
            if (this.cacheSizesForTopic == null) {
                this.cacheSizesForTopic = new HashMap<String, Integer>();
            }
            if (this.rawCacheSizesForTopicChanged || this.rawCacheSizesForPatternChanged) {
                this.cacheSizesForTopic.clear();
                this.cacheSizesForTopic.putAll(this.rawCacheSizesForTopic);
                this.rawCacheSizesForTopicChanged = false;
                this.rawCacheSizesForPatternChanged = false;
            }
            if ((size = this.cacheSizesForTopic.get(topic)) != null) {
                return size;
            }
            if (this.rawCacheSizesForPattern != null) {
                Set<PatternWrapper> patterns = this.rawCacheSizesForPattern.keySet();
                for (PatternWrapper pattern : patterns) {
                    if (!pattern.matches(topic)) continue;
                    size = this.rawCacheSizesForPattern.get(pattern);
                    this.cacheSizesForTopic.put(topic, size);
                    return size;
                }
            }
            return this.getDefaultCacheSizePerClassOrTopic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastEvent(Class eventClass) {
        if (eventClass.isInterface()) {
            throw new IllegalArgumentException("Interfaces are not accepted in get last event, use a specific event class.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List eventCache = this.cacheByEvent.get(eventClass);
            if (eventCache == null || eventCache.size() == 0) {
                return null;
            }
            return eventCache.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCachedEvents(Class eventClass) {
        if (eventClass.isInterface()) {
            throw new IllegalArgumentException("Interfaces are not accepted in get last event, use a specific event class.");
        }
        Object object = this.cacheLock;
        synchronized (object) {
            List eventCache = this.cacheByEvent.get(eventClass);
            if (eventCache == null || eventCache.size() == 0) {
                return null;
            }
            return eventCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getLastTopicData(String topic) {
        Object object = this.cacheLock;
        synchronized (object) {
            List topicCache = this.cacheByTopic.get(topic);
            if (topicCache == null || topicCache.size() == 0) {
                return null;
            }
            return topicCache.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getCachedTopicData(String topic) {
        Object object = this.cacheLock;
        synchronized (object) {
            List topicCache = this.cacheByTopic.get(topic);
            if (topicCache == null || topicCache.size() == 0) {
                return null;
            }
            return topicCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(Class eventClassToClear) {
        Object object = this.cacheLock;
        synchronized (object) {
            Set<Class> classes = this.cacheByEvent.keySet();
            Iterator<Class> iterator = classes.iterator();
            while (iterator.hasNext()) {
                Class cachedClass = iterator.next();
                if (!eventClassToClear.isAssignableFrom(cachedClass)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(String topic) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cacheByTopic.remove(topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(Pattern pattern) {
        Object object = this.cacheLock;
        synchronized (object) {
            Set<String> classes = this.cacheByTopic.keySet();
            Iterator<String> iterator = classes.iterator();
            while (iterator.hasNext()) {
                String cachedTopic = iterator.next();
                if (!pattern.matcher(cachedTopic).matches()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cacheByEvent.clear();
            this.cacheByTopic.clear();
        }
    }

    protected void subscribeVetoException(Object event, String topic, Object eventObj, Throwable e, StackTraceElement[] callingStack, VetoEventListener vetoer) {
        String str = "EventService veto event listener r:" + vetoer;
        if (vetoer != null) {
            str = str + ".  Vetoer class:" + vetoer.getClass();
        }
        this.handleException("vetoing", event, topic, eventObj, e, callingStack, str);
    }

    protected void onEventException(String topic, Object eventObj, Throwable e, StackTraceElement[] callingStack, EventTopicSubscriber eventTopicSubscriber) {
        String str = "EventService topic subscriber:" + eventTopicSubscriber;
        if (eventTopicSubscriber != null) {
            str = str + ".  Subscriber class:" + eventTopicSubscriber.getClass();
        }
        this.handleException("handling event", null, topic, eventObj, e, callingStack, str);
    }

    protected void handleException(Object event, Throwable e, StackTraceElement[] callingStack, EventSubscriber eventSubscriber) {
        String str = "EventService subscriber:" + eventSubscriber;
        if (eventSubscriber != null) {
            str = str + ".  Subscriber class:" + eventSubscriber.getClass();
        }
        this.handleException("handling event topic", event, null, null, e, callingStack, str);
    }

    protected void handleException(String action, Object event, String topic, Object eventObj, Throwable e, StackTraceElement[] callingStack, String sourceString) {
        String eventClassString = event == null ? "none" : event.getClass().getName();
        String eventString = event + "";
        String contextMsg = "Exception " + action + " event class=" + eventClassString + ", event=" + eventString + ", topic=" + topic + ", eventObj=" + eventObj;
        SwingException clientEx = new SwingException(contextMsg, e, callingStack);
        String msg = "Exception thrown by;" + sourceString;
        LOG.log(Logger.Level.WARN, msg, clientEx);
    }

    protected Object getRealSubscriberAndCleanStaleSubscriberIfNecessary(Iterator iterator, Object existingSubscriber) {
        ProxySubscriber existingProxySubscriber = null;
        if (existingSubscriber instanceof WeakReference && (existingSubscriber = ((WeakReference)existingSubscriber).get()) == null) {
            iterator.remove();
            this.decWeakRefPlusProxySubscriberCount();
        }
        if (existingSubscriber instanceof ProxySubscriber) {
            existingProxySubscriber = (ProxySubscriber)existingSubscriber;
            existingSubscriber = existingProxySubscriber.getProxiedSubscriber();
            if (existingProxySubscriber == null) {
                this.removeProxySubscriber(existingProxySubscriber, iterator);
            }
        }
        return existingSubscriber;
    }

    protected void removeProxySubscriber(ProxySubscriber proxy, Iterator iter) {
        iter.remove();
        proxy.proxyUnsubscribed();
        this.decWeakRefPlusProxySubscriberCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incWeakRefPlusProxySubscriberCount() {
        Object object = this.listenerLock;
        synchronized (object) {
            ++this.weakRefPlusProxySubscriberCount;
            if (this.cleanupStartThreshhold == null || this.cleanupPeriodMS == null) {
                return;
            }
            if (this.weakRefPlusProxySubscriberCount >= this.cleanupStartThreshhold) {
                this.startCleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decWeakRefPlusProxySubscriberCount() {
        Object object = this.listenerLock;
        synchronized (object) {
            --this.weakRefPlusProxySubscriberCount;
            if (this.weakRefPlusProxySubscriberCount < 0) {
                this.weakRefPlusProxySubscriberCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCleanup() {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.cleanupTimer == null) {
                this.cleanupTimer = new Timer();
            }
            if (this.cleanupTimerTask == null) {
                this.cleanupTimerTask = new CleanupTimerTask();
                this.cleanupTimer.schedule(this.cleanupTimerTask, 0L, (long)this.cleanupPeriodMS);
            }
        }
    }

    class CleanupTimerTask
    extends TimerTask {
        CleanupTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ThreadSafeEventService.this.listenerLock;
            synchronized (object) {
                ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.STARTING, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, null));
                if (ThreadSafeEventService.this.weakRefPlusProxySubscriberCount <= ThreadSafeEventService.this.cleanupStopThreshold) {
                    this.cancel();
                    ThreadSafeEventService.this.cleanupTimer = null;
                    ThreadSafeEventService.this.cleanupTimerTask = null;
                    LOG.debug("Cancelled scheduled weak reference and proxy cleanup.");
                    ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.UNDER_STOP_THRESHOLD_CLEANING_CANCELLED, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, null));
                    return;
                }
                LOG.debug("Starting a weak reference and proxy cleanup.");
                ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.OVER_STOP_THRESHOLD_CLEANING_BEGUN, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, null));
                ArrayList<Map> allSubscriberMaps = new ArrayList<Map>();
                allSubscriberMaps.add(ThreadSafeEventService.this.subscribersByEventType);
                allSubscriberMaps.add(ThreadSafeEventService.this.subscribersByEventClass);
                allSubscriberMaps.add(ThreadSafeEventService.this.subscribersByExactEventClass);
                allSubscriberMaps.add(ThreadSafeEventService.this.subscribersByTopic);
                allSubscriberMaps.add(ThreadSafeEventService.this.subscribersByTopicPattern);
                allSubscriberMaps.add(ThreadSafeEventService.this.vetoListenersByClass);
                allSubscriberMaps.add(ThreadSafeEventService.this.vetoListenersByExactClass);
                allSubscriberMaps.add(ThreadSafeEventService.this.vetoListenersByTopic);
                allSubscriberMaps.add(ThreadSafeEventService.this.vetoListenersByTopicPattern);
                int staleCount = 0;
                for (Map subscriberMap : allSubscriberMaps) {
                    Set subscriptions = subscriberMap.keySet();
                    for (Object subscription : subscriptions) {
                        List subscribers = (List)subscriberMap.get(subscription);
                        Iterator iter = subscribers.iterator();
                        while (iter.hasNext()) {
                            Object subscriber = iter.next();
                            Object realSubscriber = ThreadSafeEventService.this.getRealSubscriberAndCleanStaleSubscriberIfNecessary(iter, subscriber);
                            if (realSubscriber != null) continue;
                            ++staleCount;
                        }
                    }
                }
                ThreadSafeEventService.this.publish(new CleanupEvent(CleanupEvent.Status.FINISHED_CLEANING, ThreadSafeEventService.this.weakRefPlusProxySubscriberCount, staleCount));
            }
        }
    }

    private class PatternWrapper {
        private Pattern pattern;

        public PatternWrapper(Pattern pat) {
            this.pattern = pat;
        }

        public boolean matches(CharSequence input) {
            return this.pattern.matcher(input).matches();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PatternWrapper that = (PatternWrapper)o;
            if (this.pattern != null) {
                if (!this.pattern.equals(that.pattern)) {
                    return this.pattern.pattern() != null && this.pattern.pattern().equals(this.pattern.pattern());
                }
            } else if (that.pattern != null) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.pattern != null && this.pattern.pattern() != null) {
                return this.pattern.pattern().hashCode();
            }
            return this.pattern != null ? this.pattern.hashCode() : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrioritizedSubscriberComparator
    implements Comparator<Prioritized> {
        private PrioritizedSubscriberComparator() {
        }

        @Override
        public int compare(Prioritized prioritized1, Prioritized prioritized2) {
            if (prioritized1 == null) {
                return -1;
            }
            if (prioritized2 == null) {
                return 1;
            }
            if (prioritized1.getPriority() < prioritized2.getPriority()) {
                return -1;
            }
            if (prioritized1.getPriority() > prioritized2.getPriority()) {
                return 1;
            }
            return 0;
        }
    }
}

