/*
 * Decompiled with CFR 0.152.
 */
package mygame;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;

public class Sprite
extends Geometry {
    Mesh[] mesh;
    Texture texture;
    Material mat;
    float frameWidth;
    Vector2f[] st = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f)};

    public Sprite(AssetManager assetManager, String textureFile, int anims) {
        this.mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.texture = assetManager.loadTexture(textureFile);
        this.frameWidth = 1.0f / (float)anims;
        this.mat.setTexture("ColorMap", this.texture);
        this.mat.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        Vector3f[] vecs = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f)};
        int[] index = new int[]{2, 0, 1, 1, 3, 2};
        this.mesh = new Mesh[anims];
        for (int k = 0; k < anims; ++k) {
            this.st[0].x = this.frameWidth * (float)(k + 0);
            this.st[1].x = this.frameWidth * (float)(k + 1);
            this.st[2].x = this.frameWidth * (float)(k + 0);
            this.st[3].x = this.frameWidth * (float)(k + 1);
            this.mesh[k] = new Mesh();
            this.mesh[k].setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer(vecs));
            this.mesh[k].setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer(this.st));
            this.mesh[k].setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer(index));
            this.mesh[k].updateBound();
        }
        this.setMesh(this.mesh[0]);
        this.setMaterial(this.mat);
    }

    public void setAnimFrame(int k) {
        this.setMesh(this.mesh[k]);
    }
}

