/*
 * Decompiled with CFR 0.152.
 */
package mygame;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import mygame.Level;
import mygame.LevelEvent;
import mygame.LevelGenerator;

public class LevelParser {
    LevelGenerator gen;

    public static Level loadLevel(String name, LevelGenerator gen) {
        try {
            LevelParser p = new LevelParser();
            p.gen = gen;
            return p.parse(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Level parse(String name) throws Exception {
        String line;
        Level level = new Level();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(name)));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            lines.add(line);
        }
        Collections.reverse(lines);
        float time = 0.0f;
        float timeOff = 1.0f;
        for (String l : lines) {
            int len = l.length();
            if (len > 0 && (l.charAt(0) == '+' || l.charAt(0) == '#' || l.charAt(0) == '!' || l.charAt(0) == '*' || l.charAt(0) == '-' || l.charAt(0) == '1' || l.charAt(0) == '2' || l.charAt(0) == '3')) {
                int k;
                float w = 0.0f;
                for (k = 1; k < len; ++k) {
                    if (l.charAt(k) != '|') continue;
                    w = 6.0f / (float)(k - 2);
                }
                for (k = 1; k < len; ++k) {
                    char c = l.charAt(k);
                    this.gen.crEnemies(level.enemies, c, time, (-3.0f + (float)(k - 1) * w) * -1.0f);
                    this.gen.crUpgrades(level.powerups, c, time, (-3.0f + (float)(k - 1) * w) * -1.0f);
                }
                if (l.charAt(0) == '#') {
                    level.levelevents.add(new LevelEvent("boss", time));
                }
                if (l.charAt(0) == '!') {
                    level.levelevents.add(new LevelEvent("start", time));
                }
                if (l.charAt(0) == '*') {
                    level.levelevents.add(new LevelEvent("wave", time));
                }
                if (l.charAt(0) == '-') {
                    level.levelevents.add(new LevelEvent("end", time));
                }
                if (l.charAt(0) == '1') {
                    level.levelevents.add(new LevelEvent("level1", time));
                }
                if (l.charAt(0) == '2') {
                    level.levelevents.add(new LevelEvent("level2", time));
                }
                if (l.charAt(0) == '3') {
                    level.levelevents.add(new LevelEvent("level3", time));
                }
            }
            time += timeOff;
        }
        this.gen.createBg(lines.size() / 10 + 1);
        level.player = this.gen.createPlayerTiming(lines.size() / 10 + 1);
        return level;
    }
}

