#version 150

in vec3 InVertex;
in vec3 InNormal;
in vec2 TexCoords;

out vec2 TexCoord;
out vec3 vNormal;
out vec3 vEye;

uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform mat4 ModelMatrix;
uniform mat4 NormalMatrix;

void main()
{
	TexCoord = TexCoords;
	vEye = vec3( ( ViewMatrix * ModelMatrix ) * vec4( InVertex, 1.0 ) );
	vNormal = mat3( NormalMatrix ) * InNormal;
	gl_Position = ProjectionMatrix * ViewMatrix * ModelMatrix * vec4( InVertex, 1.0 );
}