#version 150

in vec3 vNormal;
in vec3 vEye;
in vec2 TexCoord;

out vec4 out_Color;

uniform sampler2D TexSampler;
uniform samplerCube TexSampler2;

uniform vec3 LightPos;
uniform vec4 HexColor;
uniform float CurrentTime;

void main()
{
	vec3 n = normalize( vNormal );
	vec3 v = normalize( -vEye );
	vec3 l = normalize( LightPos - vEye );
	vec3 h = normalize( v + l );
	vec3 r = reflect( normalize( vEye ), n );

	float specularCoefficient = 60.0;

	vec3 cAmb = vec3( 0.0, 0.0, 0.0 );
	vec3 cDiff = vec3( 0.75, 0.75, 0.75 );

	vec4 ref = texture( TexSampler2, r );
	vec2 finalCoord = TexCoord;
	finalCoord.y = 1.0 - finalCoord.y;
	vec4 texColor = texture2D( TexSampler, finalCoord );

	vec3 cSpec = vec3( 1.0, 1.0, 1.0 );
	float diff = max( 0.0, dot( n, l ) ) * texColor.a;
	float spec = max( pow( dot( n, h ), specularCoefficient ), 0.0 );
	vec4 color = vec4( ( cAmb + (cDiff*texColor.xyz)*diff + cSpec*spec ), 1.0 );

	out_Color = vec4( mix( vec3( color*(HexColor * 2.0 ) ), vec3( ref ), 0.3 ), 1.0 );
	
	//out_Color = vec4( mix( vec3( HexColor*texColor*(vec4(diff)+vec4(.1f) ) ), vec3( ref ), 0.3 ), 1.0 );
}