#version 330

layout( location = 0 ) in vec3 InVertex;
layout( location = 1 ) in float InParticleSize;

out float ParticleSize;

uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform float CurrentTime;

void main()
{
	ParticleSize = InParticleSize;
	vec3 pos = InVertex;
	pos.y = pos.y + sin( ( gl_VertexID ) + ( CurrentTime / 4.0 ) ) * 5.0 * sin( CurrentTime / 4.0 );
	//pos.x = pos.x + cos( CurrentTime / 4.0 ) * 5.0;
	//vec3 dir = pos - vec3( 0.0, 0.0, 0.0 );
	//vec4 finalPos = vec4( pos + ( dir * (sin( CurrentTime / 4.0 ) + 1.5 )/4.0 ), 1.0 );
	gl_Position = ProjectionMatrix * ViewMatrix * vec4( pos, 1.0 );
}