#version 330

in vec2 TexCoord;
out vec4 out_Color;

uniform sampler2D TexSampler;

void main()
{
	vec2 finalCoord = TexCoord;
	finalCoord.y = 1.0 - finalCoord.y;
	vec4 color = texture2D( TexSampler, finalCoord );
	if( color.a < 0.5 )
	{
		discard;
	}
	color = color * vec4( 0.1, 0.1, 0.8, 1.0 );
	out_Color = color;
}