#version 150

in vec3 vNormal;
in vec3 vEye;
in vec2 TexCoord;
in vec3 vLightPos;

out vec4 out_Color;

uniform sampler2D TexSampler;

uniform float CurrentTime;
uniform vec2 Resolution;

void main()
{
	
	vec3 n = normalize( vNormal );
	vec3 v = normalize( -vEye );
	vec3 l = normalize( vLightPos - vEye );
	vec3 h = normalize( v + l );
	
	float specularCoefficient = 40.0;

	vec2 finalCoord = TexCoord;
	finalCoord.y = 1.0 - finalCoord.y;
	vec4 texColor = texture2D( TexSampler, finalCoord );

	vec3 cAmb = vec3( 0.0, 0.0, 0.0 );
	vec3 cDiff = vec3( 0.3, 0.3, 0.3 );
	vec3 cSpec = vec3( 1.0, 1.0, 1.0 );
	float diff = max( 0.0, dot( n, l ) ) * texColor.a;
	float spec = max( pow( dot( n, h ), specularCoefficient ), 0.0 );
	
	out_Color = vec4( ( cAmb + (cDiff*texColor.xyz)*diff + cSpec*spec ), 1.0 );
}