#include version.txt

varying vec3 ViewDirection;
varying vec3 LightDirection;
varying vec3 Normal;

void main( void )
{
   vec3 vLightDirection = normalize(LightDirection);
   vec3 vNormal = normalize(Normal);
   float NDotL = dot(vNormal,vLightDirection );
   vec3 vReflection = normalize(((2.0*vNormal)*NDotL-vLightDirection)); 
   vec3 vViewDirection = normalize(ViewDirection);
   float RDotV = max(0.0, dot(vReflection,vViewDirection));   
   vec4 TDiffuse = gl_FrontMaterial.diffuse*NDotL * gl_FrontMaterial.ambient;
   vec4 TSpecular = gl_FrontMaterial.specular*(pow(RDotV,gl_FrontMaterial.shininess));  
   gl_FragColor = TDiffuse + TSpecular;      
}