uniform sampler2D texture;
uniform sampler2D noise;
uniform vec2 screen;
uniform vec2 noise_scroll0;
uniform vec2 noise_scroll1;
uniform vec2 noise_scroll2;

varying vec4 pos;
varying vec3 normal;

void main( void )
{
	float noise_value0 = texture2D(noise, (gl_TexCoord[0].xy * vec2(1.0, 0.25)) + noise_scroll0).r;
	float noise_value1 = texture2D(noise, (gl_TexCoord[0].xy * vec2(2.0, 0.50)) + noise_scroll1).r;
	float noise_value2 = texture2D(noise, (gl_TexCoord[0].xy * vec2(4.0, 1.00)) + noise_scroll2).r;

    float noise_value_final = (noise_value0 + noise_value1 + noise_value2) / 2.0;

//	float x = dot(vec3(1.0, 0.0, 0.0), normal) + (-2.5 + noise_value_final);
//	float y = dot(vec3(0.0, 1.0, 0.0), normal) + (-2.5 + noise_value_final);
	
//	float x = dot(vec3(1.0, 0.0, 0.0), normal) + (noise_value0 - 0.5) * 2.0;
//	float y = dot(vec3(0.0, 1.0, 0.0), normal) + (noise_value1 - 0.5) * 2.0;

	float x = dot(vec3(1.0, 0.0, 0.0), normal) + sin(noise_value0 * 20.5) / 30.0;
	float y = dot(vec3(0.0, 1.0, 0.0), normal) + cos(noise_value1 * 20.5)  / 30.0;
	
	gl_FragColor = texture2D(texture, (gl_FragCoord.xy / screen + 1.0) + vec2(x,y) / 2.0);
}
