uniform sampler1D values;
uniform vec4 background_color;
uniform vec4 foreground_color;
uniform vec2 scale;

void main() {
	float x = mod(gl_TexCoord[0].x * scale.x, 1.0);
	float y = mod(gl_TexCoord[0].y * scale.y, 1.0);
	float v = 1.0 - texture1D(values, gl_TexCoord[0].x / scale.x).r;
	v = ceil(v * scale.y);
	float ycoord = ceil((1.0 - gl_TexCoord[0].y) * scale.y);

	if(x > 0.1 && x < 0.9 && y > 0.2 && y < 0.8 && ycoord > v) {
		gl_FragColor = foreground_color;
	}
	else {
		gl_FragColor = background_color;
	}
}
