﻿
if (Uno.Controls != undefined && Uno.Controls.Native != undefined) {

    // NativeButtonBehavior
    if (Uno.Controls.Native.NativeButtonBehavior != undefined) {
        Uno.Controls.Native.NativeButtonBehavior.prototype.NotifyControlAttached = function (c) {
            Uno.Controls.Native.NativeButtonBehavior.HookEvents(c);
            var e = c.$html_element = document.createElement("button");
            e.style.display = c.Visible() ? "block" : "none";
            e.control = c;
            e.style.position = "absolute";
            e.style.top = c.YTransformed().toString() + "px";
            e.style.left = c.XTransformed().toString() + "px";
            e.style.width = c.Width().toString() + "px";
            e.style.height = c.Height().toString() + "px";
            e.onclick = function () {
                this.control.OnClick(Uno.Controls.Control.EmptyEventArgs);
            };
            c.$html_element.innerHTML = c.Text();
            document.getElementsByTagName("body")[0].appendChild(e);
        };

        Uno.Controls.Native.NativeButtonBehavior.prototype.NotifyControlDetached = function (c) {
            Uno.Controls.Native.NativeButtonBehavior.UnHookEvents(c);
            document.getElementsByTagName("body")[0].removeChild(c.$html_element);
        };

        Uno.Controls.Native.NativeButtonBehavior.OnTextChanged = function (c) {
            c.$html_element.innerHTML = c.Text();
        };

        Uno.Controls.Native.NativeButtonBehavior.OnVisibleChanged = function (c) {
            c.$html_element.style.display = c.Visible() ? "block" : "none";
        };

        Uno.Controls.Native.NativeButtonBehavior.OnSizeChanged = function (c, e) {
            c.$html_element.style.width = c.Width().toString() + "px";
            c.$html_element.style.height = c.Height().toString() + "px";
        };

        Uno.Controls.Native.NativeButtonBehavior.OnPositionChanged = function (c, e) {
            c.$html_element.style.left = c.XTransformed().toString() + "px";
            c.$html_element.style.top = c.YTransformed().toString() + "px";
        };

        Uno.Controls.Native.NativeButtonBehavior.onParentPositionChanged = Uno.Controls.Native.NativeButtonBehavior.OnPositionChanged;
    }


    // NativeTextBoxBehavior
    if (Uno.Controls.Native.NativeTextBoxBehavior != undefined) {
        Uno.Controls.Native.NativeTextBoxBehavior.prototype.NotifyControlAttached = function (c) {
            Uno.Controls.Native.NativeTextBoxBehavior.HookEvents(c);
            var e = c.$html_element = document.createElement("input");
            
            if (c.PasswordMode()) c.$html_element.setAttribute("type", "password");
            else e.setAttribute("type", "text");

            e.style.display = c.Visible() ? "" : "none";
            e.control = c;
            e.style.position = "absolute";
            e.style.top = c.YTransformed().toString() + "px";
            e.style.left = c.XTransformed().toString() + "px";
            e.style.width = c.Width().toString() + "px";
            e.style.height = c.Height().toString() + "px";
            e.value = c.Text();
            e.onclick = function () {
                this.control.OnClick(Uno.Controls.Control.EmptyEventArgs);
            };
            e.onchange = e.onkeyup = function () {
                this.control.Text(e.value);
            }
            e.onchange = e.onkeypress = function () {
                this.control.Text(e.value);
            }
            c.$html_element.setAttribute("value", c.Text());
            document.getElementsByTagName("body")[0].appendChild(e);
        };

        Uno.Controls.Native.NativeTextBoxBehavior.prototype.NotifyControlDetached = function (c) {
            Uno.Controls.Native.NativeTextBoxBehavior.UnHookEvents(c);
            document.getElementsByTagName("body")[0].removeChild(c.$html_element);
        };

        Uno.Controls.Native.NativeTextBoxBehavior.OnTextChanged = function (c) {
            if (c.$html_element.value != c.Text()) c.$html_element.value = c.Text();
        };

        Uno.Controls.Native.NativeTextBoxBehavior.OnVisibleChanged = function (c) {
            c.$html_element.style.display = c.Visible() ? "" : "none";
        };

        Uno.Controls.Native.NativeTextBoxBehavior.OnSizeChanged = function (c, e) {
            c.$html_element.style.width = c.Width().toString() + "px";
            c.$html_element.style.height = c.Height().toString() + "px";
        };

        Uno.Controls.Native.NativeTextBoxBehavior.OnPositionChanged = function (c, e) {
            c.$html_element.style.left = c.XTransformed().toString() + "px";
            c.$html_element.style.top = c.YTransformed().toString() + "px";
        };

        Uno.Controls.Native.NativeTextBoxBehavior.OnPasswordModeChanged = function (c, e) {
            c.$html_element.setAttribute("type", "password");
        };

        Uno.Controls.Native.NativeTextBoxBehavior.OnParentPositionChanged = Uno.Controls.Native.NativeTextBoxBehavior.OnPositionChanged;
    }

}