function Grid(vid) {
	var t = this;

	// Constants
	t.SNARE_LENGTH = 20;
	
	// Initvar
	t.fn = 0;
	t.vid = vid;
	t.snare = 0;
	t.size = 5;
	
	t.drawImage = function(img) {
		var c = false;		
		var gpos = 0;
		
		for(idx in img) {
			var run = img[idx];
			
			// ctx.fillStyle = "white";
			for(var i = 0; i < run; i++) {
				// Check if it needs changing
				var br = Math.floor((Math.random() * 0.1 + 0.9) * 255);
				ctx.fillStyle = "rgba("+br+","+br+","+br+", 1)";
				if(c) {
					var x = (gpos % 96);
					var y = (gpos - x) / 96;		
					ctx.fillRect(x * 20, y * 20, 20, 20);
				}
				gpos++;
			}
			c = !c;
		}
	}
	
	t.drawFrame = function(img) {
		
		ctx.fillStyle = "rgba(0,0,0,0.3)";
		ctx.fillRect(0, 0, 1920, 1080);
		
		if(t.snare) {
			ctx.save()
			t.drawImage(img);
			ctx.globalAlpha = 0.3 * (t.snare / t.SNARE_LENGTH);
			ctx.translate(960, 540);
			ctx.scale((1 + t.SNARE_LENGTH/10) - t.snare * 0.1, (1 + t.SNARE_LENGTH/10) - t.snare * 0.1);
			ctx.globalAlpha = 0.3 * linToLog(t.snare / t.SNARE_LENGTH);
			ctx.translate(-960, -540);
			t.drawImage(img);	
			ctx.restore()
			t.snare--;
		} else {
			t.drawImage(img);
		}
		
	}
			
	t.proc = function() {
		// Do processing stuff
		// Skip odd frames
		// if(fnum % 2) return;
		t.drawFrame(t.vid[t.fn = ((t.fn + 1) % t.vid.length)])	
		
	}
	
	t.ev = function(ev){
		var ins = ev[1];
		var nte = ev[0];

		if(ins == 2) {
			t.size = -5;
		}
		
		if(ins == 5) {
			t.snare = t.SNARE_LENGTH;
		}
	}
	
};