#ifdef GL_ES
precision highp float;
#endif

uniform vec2 resolution;
uniform vec2 pos;
uniform float intensity;
uniform sampler2D tex0;
uniform sampler2D tex1;

void main(void)
{
	const float gap = 0.005;
	vec2 p0 = gl_TexCoord[0].xy;
	p0.x += 1.0*gap;

	float nx = texture2D(tex0,p0).x;

	p0.x -= 2.0*gap;
	nx -= texture2D(tex0,p0).x;


	p0.x += 1.0*gap;
	p0.y += 1.0*gap;

	float ny = texture2D(tex0,p0).x;
	p0.y -= 2.0*gap;
	ny -= texture2D(tex0,p0).x;

	nx += pos.x;
	ny += pos.y;
	float l = 0.5/sqrt(nx*nx+ny*ny);
	
	l *= l*l*l;
	if (l>1.0) l=1.0;
	if (l<0.0) l=0.0;

	//gl_FragColor = vec4(l,l,l,l);
    gl_FragColor = l*texture2D(tex0,gl_TexCoord[0].xy);
}
