uniform sampler2D t_color;
uniform vec2 direction;
uniform int radius;
uniform float threshold;

void main(void) {
  vec2 texcoord = gl_TexCoord[0].xy;
  float middle = texture2D(t_color, texcoord).r;
  float a = 0.0;
  float pier = 1.0;

  for (int i=-radius; i<radius; i++) {
    float sample=texture2D(t_color, texcoord+float(i)*direction).r;
    float diff=sample-middle;
	  if (abs(diff)<threshold) {
	    float k=1.0-abs(float(i))/float(radius);
      a += sample*k;
	    pier += k;
 	  }
  }
  
  if (pier>0.0) gl_FragColor.r = a/pier;
  else gl_FragColor.r = middle;
}