﻿//http://stackoverflow.com/questions/5919663/how-does-photoshop-blend-two-images-together
//http://blog.deepskycolors.com/archivo/2010/04/21/formulas-for-Photoshop-blending-modes.html
uniform sampler2D tex0;
uniform sampler2D tex1;

void main()
{

//#define ChannelBlend_Overlay(A,B)    ((uint8)((B < 128) ? (2 * A * B / 255):(255 - 2 * (255 - A) * (255 - B) / 255)))

	vec4 col0 = texture2D(tex0,gl_TexCoord[0].st);
	vec4 col1 = texture2D(tex1,gl_TexCoord[1].st);
	vec4 col={1,0,0,0};		// = vec4(color0.x*color1.x,color0.y*color1.y,color0.z*color1.z,1);

	// r
	if(col1.r<0.5) col.r = 2*col0.r*col1.r;
	else col.r = 1 - 2 * (1 - col0.r) * (1 - col1.r);
	if(col1.g<0.5) col.g = 2*col0.g*col1.g;
	else col.g = 1 - 2 * (1 - col0.g) * (1 - col1.g);
	if(col1.b<0.5) col.b = 2*col0.b*col1.b;
	else col.b = 1 - 2 * (1 - col0.b) * (1 - col1.b);

	gl_FragColor = col;
}
