LINEPAD     equ 2
SCREENLINES equ DRAWLINES*(16+LINEPAD)+LINEPAD
PAD         equ LINES-SCREENLINES-32-8
BACKGROUND  equ $02
BORDER      equ $20
TEXTCLR     equ $50
LED         equ $64
TEXTXPOS    equ 60
LEDXPOS     equ 154
SPEEDY      equ 1       ;speedy or not?
STOPONLASTLINE  equ 0   ;shouldn't need this - just time stuff better

Paragraphs
    PARAGRAPHS

    ;yes, I'm quite proud of this one
BeautyLogic         pha
OptionalLogic       pha
PlasmaTextLogic     pha
PaletteLogic        pha
EndtextLogic        pha
MiddleTextLogic     pha
HistoryLogic        pha
IntroLogic

ScreenLogic
    tsx
    txa
    eor #$FF
    tax
    lda Paragraphs,X
    sta firstline
    lda Paragraphs+1,X
    sta lastline

    ;Y points into Measures when we're entered
    lda Measures-1,Y
    asl
#if SPEEDY
    asl
#endif
    clc
    adc #6
    sta temp+1

    lda beat
#if SPEEDY
    lsr
    lsr
    lsr
    sta temp
    lda measure
    asl
    asl
    ora temp
#else
    cmp #16
    lda measure
    rol
#endif
    sec
    sbc temp+1

    ;decode DRAWLINES, then hide the characters whose time hasn't come yet
    clc
    adc firstline
    tax

#if STOPONLASTLINE
    ;see if we should stop on lastline
    ldy #0
    clc
    adc #DRAWLINES-1
    cmp lastline
    bcc XIsOK
    lda lastline
    sec
    sbc #DRAWLINES
    tax
    ldy #1
XIsOK
    sty onlastline
#endif
    ldy #0

DecodeLine
    cpx firstline
    bcc BlankLine
    cpx lastline
    bcs BlankLine
    lda Bytes0,X
    asl
    asl
    asl
    sta col0,Y
    lda Bytes1,X
    asl
    asl
    asl
    sta col1,Y
    lda Bytes2,X
    asl
    asl
    asl
    sta col2,Y
    lda Bytes3,X
    asl
    asl
    asl
    sta col3,Y
    lda Bytes0,X
    lsr
    asr #%01110000
    sta temp
    lda Bytes1,X
    and #%11000000
    ora temp
    sta col4,Y
    lda Bytes2,X
    lsr
    asr #%01110000
    sta temp
    lda Bytes3,X
    and #%11000000
    ora temp
    sta col5,Y
    jmp NextLine
BlankLine
    lda #0
    sta col0,Y
    sta col1,Y
    sta col2,Y
    sta col3,Y
    sta col4,Y
    sta col5,Y
NextLine
    inx
    iny
    cpy #DRAWLINES
    bne DecodeLine

#if STOPONLASTLINE
    lda onlastline
    bne DoneHiding
#endif

    lda beat
#if !SPEEDY
    lsr
#endif
    and #$07
    tax
    lda #0
    clc
ComputeHideOfs
    dex
    bmi DoneComputing
    adc #DRAWLINES
    bne ComputeHideOfs

DoneComputing
    ldy #0
HideChars
    cmp #6*DRAWLINES
    bcs DoneHiding
    ;carry clear
    tax
    sty col0+DRAWLINES-1,X
    adc #DRAWLINES
    bne HideChars

DoneHiding
    lda #$F0
    sta PF0
    lda #1
    sta CTRLPF
    lda #TEXTCLR
    sta COLUP0
    sta COLUP1
    lda #3
    sta NUSIZ0
    sta NUSIZ1
    lda #1
    sta VDELP0
    sta VDELP1

    lda #TEXTXPOS
    ldx #0
    jsr PositionObject
    lda #TEXTXPOS+8
    ldx #1
    jsr PositionObject
    lda #LEDXPOS
    ldx #2
    jsr PositionObject
    sta WSYNC
    sta HMOVE

    lda #>Glyph0
    sta pointers+1
    sta pointers+3
    sta pointers+5
    sta pointers+7
    sta pointers+9
    sta pointers+11

    lda beat
    asl
    asl
    asl
    asl
    tay
    lda SinTab,Y
    lsr
    lsr
    lsr
    lsr
    lsr
    adc #LED
    sta ledclr

    lda #0
    sta curline
    brk ;jmp LogicRet

ScreenKernelWhiteFlash
    sta WSYNC
    ldy #2
    bne ScreenKernelNoWsyncFlash
ScreenKernelFlash
    sta WSYNC
    ldy #1
    lda measure
    cmp #FLASHSTART
    bne ScreenKernelNoWsync
    lda beat
    cmp #8
    bcc ScreenKernelNoWsync
    bcs ScreenKernelNoWsyncFlash
ScreenKernel
    sta WSYNC
ScreenKernelNoWsync
    ldy #0
ScreenKernelNoWsyncFlash
    sty flash

    ldx #PAD/2-1
TopPad
    lda #BACKGROUND
    sta COLUBK
    sta COLUPF
    sta WSYNC
    dex
    bne TopPad

    ;brown border
    ldx #15
TopBorder
    txa
    eor #BORDER + $0F
    sta COLUBK
    sta COLUPF
    sta WSYNC
    dex
    bpl TopBorder

    lda #0
    sta COLUBK

    lda flash
    beq NoFlash
    cmp #2
    beq WhiteFlash
    jmp PaletteKernel

WhiteFlash
    lda #BORDER|$0F
    sta COLUBK
    lda measure
    asl
    asl
    asl
    asl
    sta temp
    ldx #SCREENLINES+6
WhiteFlashLoop
    sta WSYNC
    lda beat
    and #$0F
    ora temp
    eor #$0F
    sta COLUBK
    dex
    bne WhiteFlashLoop
    jmp PaletteKernelRet

NoFlash
    ldx curline
DoLine
    ;a bit of padding
    ldy #LINEPAD
PadText
    sta WSYNC
    dey
    bne PadText

    lda col0,X
    sta pointers
    lda col1,X
    sta pointers+2
    lda col2,X
    sta pointers+4
    lda col3,X
    sta pointers+6
    lda col4,X
    sta pointers+8
    lda col5,X
    sta pointers+10

    dec temp+2  ;SLEEP 5
    dec temp+2  ;SLEEP 5
    dec temp+2  ;SLEEP 5

    ldy #7
DrawText
    sty temp

    dec temp+2  ;SLEEP 5

    lda (pointers),Y
    sta GRP0
    lda (pointers+2),Y
    sta GRP1
    lda (pointers+4),Y
    sta GRP0
    lda (pointers+6),Y
    tax
    lda (pointers+8),Y
    sta temp+1
    lda (pointers+10),Y
    ldy temp+1
    stx GRP1
    sty GRP0
    sta GRP1
    sta GRP0

    ldy temp

    tya
    ora #TEXTCLR
    sta COLUP0
    sta COLUP1

    lda (pointers),Y
    sta GRP0
    lda (pointers+2),Y
    sta GRP1

    SLEEP 4

    lda (pointers+4),Y
    sta GRP0
    lda (pointers+6),Y
    tax
    lda (pointers+8),Y
    sta temp+1
    lda (pointers+10),Y
    ldy temp+1
    stx GRP1
    sty GRP0
    sta GRP1
    sta GRP0

    ldy temp
    dey
    bpl DrawText

    lda #0
    sta GRP0
    sta GRP1
    sta GRP0

    inc curline
    ldx curline
    cpx #DRAWLINES
    beq DoneLines
    jmp DoLine

PaletteKernelRet
DoneLines
    ldy #LINEPAD
BottomBlackPad
    sta WSYNC
    lda #0
    sta GRP0
    sta GRP1
    dey
    bne BottomBlackPad

    ;brown border
    ldx #15
BottomBorder
    sta WSYNC
    lda #$20
    sta NUSIZ0

    txa
    eor #BORDER
    sta COLUBK
    sta COLUPF
    lda #0
    sta GRP0
    sta GRP1
    lda ledclr
    sta COLUP0
    txa
    lsr
    cmp #4
    bne NoLed
    lda #2
    .byte $0C
NoLed
    lda #0
    sta ENAM0
    dex
    bpl BottomBorder

    ldx #PAD/2-1
BottomPad
    sta WSYNC
    lda #BACKGROUND
    sta COLUBK
    sta COLUPF
    dex
    bne BottomPad

    ;we're used a lot, so clean up for the other kernels
    lda #0
    sta PF0
    sta VDELP0
    sta VDELP1

    jmp KernelRet