uniform float t;
uniform float beats;
uniform float bounce;
uniform float kick;
uniform float saw;

uniform float syncdistort;

uniform mat4 matrix;

#ifdef vertexcompile

layout (location=0) in vec3 pos;
layout (location=1) in vec3 nor;
smooth out vec3 ppos, pnor;

void main()
{
	//float syncdistort = 1.0;
	ppos = pos;
	vec3 newpos = pos;
	//newpos.y += sin(0.1f*newpos.x + 0.1f*newpos.y + 0.1f*newpos.z + t) * 3.0f;
	//newpos = pos * mix(1.0, saw, 0.1f);
	float dist = sin(0.5f * length(pos) - t*2.0f) * syncdistort + saw*0.4*syncdistort;
	newpos.y += dist * syncdistort;
	ppos = newpos;
	pnor = -nor * mix(1.0, dist, syncdistort);
	gl_Position = matrix*vec4(newpos, 1.0);
}

#endif

#ifdef fragmentcompile

smooth in vec3 pnor, ppos;
layout (location=0) out vec4 outcol;

uniform sampler2D tex, moss;

void main()
{
	float l = dot(normalize(pnor),normalize(vec3(1.0,1.0,.5)))*.5+.5;
	vec4 ys = l*pnor.y*texture2D(tex, ppos.xz*.1);
	if(pnor.y<.0)
		ys = -l*pnor.y*texture2D(moss, ppos.xz*.1);
	outcol = l*abs(pnor.x)*texture2D(tex, ppos.yz*.1)+ys+l*abs(pnor.z)*texture2D(tex, ppos.xy*.1)+vec4(vec3(.0),1.0);
}
#endif
