uniform float t;
uniform float t_scene;
uniform float beats;
uniform float bounce;
uniform float kick;
uniform float saw;

uniform float syncdistort;

uniform vec3 lightpos;
uniform float lightradius;
uniform float falloff;
uniform vec3 fog_color;

uniform mat4 matrix;

#ifdef vertexcompile

layout (location=0) in vec3 pos;
layout (location=1) in vec3 nor;
smooth out vec3 ppos, pnor;
smooth out vec3 origpos;
smooth out vec3 lightdir;
smooth out vec3 lightpos_world;
smooth out float distort;
smooth out vec4 eyespace_pos;

void rY(inout vec3 p, float a) {
	float c,s;vec3 q=p;
	c = cos(a); s = sin(a);
	p.x = c * q.x + s * q.z;
	p.z = -s * q.x + c * q.z;
}

void main()
{
	//float syncdistort = 1.0;
	distort = 0.0;
	float wavespeed = (t_scene-20.0)/32.0;
	float saw_distort = syncdistort * 1.8;	// beats with the kick drum
	
	float mayhem = max(0.0, (t_scene-25.0))/32.0;
	
	distort = max(0.0, min(1.0, 
		(t_scene-11.0)/14.0 
		));
		
	distort += syncdistort * 0.4;	
	
	origpos = pos;
	ppos = pos;
	vec3 newpos = pos;
	rY(newpos, newpos.y * mayhem * 0.04);
	//newpos.y += sin(0.1f*newpos.x + 0.1f*newpos.y + 0.1f*newpos.z + t) * 3.0f;
	//newpos = pos * mix(1.0, saw, 0.1f);
	float dist = sin(0.5f * length(pos) - t*wavespeed + saw*0.2*saw_distort) * distort + saw*0.4*saw_distort;
	newpos.y += dist * distort;
	ppos = newpos;
	pnor = -nor * mix(1.0, dist, distort);
	eyespace_pos = matrix*vec4(newpos, 1.0);
	lightpos_world = (matrix*vec4(lightpos, 1.0)).xyz;
	//lightdir = lightpos - eyespace_pos.xyz;
	lightdir = lightpos_world.xyz - eyespace_pos.xyz;
	gl_Position = matrix*vec4(newpos, 1.0);
}

#endif

#ifdef fragmentcompile

smooth in vec3 ppos, pnor, lightdir;
smooth in vec3 lightpos_world;
smooth in vec3 origpos;
smooth in float distort;
smooth in vec4 eyespace_pos;

layout (location=0) out vec4 outcol;

uniform sampler2D tex, moss;

void main()
{
	float l = dot(normalize(pnor),normalize(lightdir))*.5+.5;
	//float lightdist = pow(distance(lightpos, ppos), 1.4);
	float lightdist = distance(lightpos, ppos);
	float scale = 0.05;
	vec4 ys = l*pnor.y*texture2D(tex, origpos.xz*scale);
	if(pnor.y<.0)
		ys = -l*pnor.y*texture2D(moss, origpos.xz*scale);
	
	outcol = l*abs(pnor.x)*texture2D(tex, origpos.yz*scale)+ys+l*abs(pnor.z)*texture2D(tex, origpos.xy*.1)+vec4(vec3(.0),1.0);
	outcol *= mix(1.0, length(outcol.rgb), 0.7);	// small contrast boost
	
	outcol.gb *= 0.9;
	
	float lightenergy =  max(0.0, 2000.0/pow(lightdist, 2.0));
	vec4 lightcolor = outcol * lightenergy;
	lightcolor.g *= 0.9;
	lightcolor.b *= 0.7;
	
	float fogFalloff = 1.2; // smaller is thicker
	float fogScale = 2.20; // bigger is thicker
	float fogAmount = pow(abs((eyespace_pos.z * fogScale)/eyespace_pos.w) , fogFalloff); 
	
	outcol.rgb = mix(outcol.rgb, fog_color, fogAmount * (1.0 - distort)) * (1.8 - distort*0.8) ;
	
	// mix the light last so the fog doesn't interfere
	outcol = mix( lightcolor, outcol, distort);
	
	// MEGAFOG (only in intro)
	outcol.rgb = mix(outcol.rgb, fog_color, max(0.0, fogAmount - t_scene*0.4)) ;
}
#endif
