uniform sampler2D texture;
uniform float t;
uniform int id;
uniform mat4 matrix;
uniform float fade;

float rand(vec2 coordinate) {
    return fract(sin(dot(coordinate.xy, vec2(12.9898, 78.233))) * 43758.5453);
}

#ifdef vertexcompile

smooth out vec2 coord;
smooth out float dist;
smooth out float alpha;
smooth out vec3 ppos;
layout (location=0) in vec3 pos;
layout (location=1) in vec3 pnor;
void main()
{
	//tekstuuri
	ppos = pos;
	coord = vec2(pos.x/7+round(rand(vec2(pnor.x+4534))*1)/9,pos.z);		//tekstuurin valinta
	float tt = t + 5.0 * rand(vec2(pos.x, pos.z)) + rand(vec2(pnor.x, pnor.z));
	float cycle = mod(tt, 40.0);
	float ang = pos.x;
	float h = mod(pos.y * 100.0, 120.0) - 24.0 + rand(vec2(pos.z, 0.0))*4.0;
	float radius = 55.0 - sqrt(cycle*4.0);
	
	vec3 startpos = vec3(cos(ang) * radius, h, sin(ang) * radius);
	
	vec3 newpos = startpos + vec3(0.0, cycle, 0.0);

	alpha = 0.5;
	vec4 ppos=vec4(newpos.x, newpos.y, newpos.z, 1.0);
	gl_Position = matrix*ppos;
	dist = gl_Position.z;
}
#endif

#ifdef fragmentcompile

smooth in float dist;
smooth in vec2 coord;
smooth in float alpha;
smooth in vec3 ppos;
layout (location=0) out vec4 outcol;

void main()
{
	//vec2 gl_PointCoord
	vec2 kord = gl_PointCoord;
	float scale = 1.0 + rand(ppos.xz);
	float limit = scale;
	kord *= scale;
	
	kord.x = min(1.0, kord.x);
	kord.y = min(1.0, kord.y);
	
	float frames = 8.0;
	float id = 1.0 + floor(mod(ppos.x + ppos.y, 2.0));
	kord.x /= frames;
	kord.x += id * (1.0/frames);
	vec4 col = texture2D(texture, kord);
	
	/*
	float samples = max(0,round(dist*dist/5)-35);
	for(int i=0;i<samples;i++){
		col += texture2D(texture, coord+vec2(sin(float(i))*i,cos(float(i))*i)*(sqrt(float(i))*0.0001));
	}
	col= col/vec4(1+samples);
	*/
	//col = vec4(1.0, 1.0, 1.0, 1.0);
	//col.r = rand(vec2(gl_FragCoord.x, gl_FragCoord.y));
	col.a *=  0.1;
	
	//col.a = col.a-dist*0.025+fade;
	//col.a = col.a-dist*0.010+fade;
	outcol = col;
	
}
#endif
