/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.util;

import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.Plane;
import com.threed.jpct.PolygonManager;
import com.threed.jpct.Projector;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.World;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReflectionHelper {
    private static int cnt = 0;
    private Object3D planeObj = null;
    private List exclude = new ArrayList(1);
    private Projector proj = new Projector();
    private Texture ref = null;
    private Map camStore = new HashMap(2);
    private Plane plane = new Plane();
    private Color clearCol = Color.black;
    private List worlds = new ArrayList();
    private String name = null;
    private boolean enabled = true;
    private float clippingPlaneOffset = 0.0f;

    public ReflectionHelper(FrameBuffer frameBuffer, Object3D object3D, int n, int n2) {
        int n3;
        this.planeObj = object3D;
        if (n != 8192 && n != 4096 && n != 2048 && n != 1024 && n != 512 && n != 256 && n != 128 && n != 64 && n != 32 && n != 16) {
            n = 256;
            Logger.log("Consider using a power of two lower than 16384 as the reflection map's size. Adjusted to 256*256!", 1);
        }
        int n4 = frameBuffer.getMaxTextureSize();
        Logger.log("Hardware supports textures up to " + n4 + "*" + n4 + " in size!", 2);
        n = Math.min(n, n4);
        int n5 = frameBuffer.getOutputHeight();
        int n6 = frameBuffer.getOutputWidth();
        int n7 = n;
        if (!Config.glUseFBO) {
            for (n3 = n; n3 > n6; n3 /= 2) {
            }
            while (n7 > n5) {
                n7 /= 2;
            }
        }
        if (n7 < (n = n3)) {
            n = n7;
        }
        n3 = n;
        n7 = n;
        this.ref = new Texture(n3, n7, null);
        this.name = "--refMap-" + cnt + "-";
        TextureManager textureManager = TextureManager.getInstance();
        if (textureManager.containsTexture(this.name)) {
            textureManager.replaceTexture(this.name, this.ref);
        } else {
            textureManager.addTexture(this.name, this.ref);
        }
        this.ref.setProjector(this.proj, true);
        this.exclude.add(object3D);
        int n8 = textureManager.getTextureID(this.name);
        PolygonManager polygonManager = object3D.getPolygonManager();
        int n9 = polygonManager.getMaxPolygonID();
        for (int i = 0; i < n9; ++i) {
            polygonManager.addTexture(i, n8, n2);
        }
        ++cnt;
    }

    public void exclude(Object3D object3D) {
        this.exclude.add(object3D);
    }

    public void include(Object3D object3D) {
        this.exclude.remove(object3D);
    }

    public void setClearColor(Color color) {
        this.clearCol = color;
    }

    public Texture getReflectionTexture() {
        return this.ref;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            this.ref.setEnabled(true);
        } else {
            this.ref.setEnabled(false);
        }
    }

    public void drawScene(World world, FrameBuffer frameBuffer) {
        this.drawScene(world, frameBuffer, null);
    }

    public void drawScene(World world, FrameBuffer frameBuffer, World[] worldArray) {
        Camera camera;
        World world2;
        if (!this.enabled || frameBuffer.usesRenderer(1)) {
            return;
        }
        Camera camera2 = world.getCamera();
        this.proj.setPosition(camera2.getPosition());
        Matrix matrix = camera2.getBack().cloneMatrix();
        this.proj.setBack(matrix);
        this.proj.setFOV(camera2.getFOV());
        Iterator iterator = this.exclude.iterator();
        while (iterator.hasNext()) {
            ((Object3D)iterator.next()).setVisibility(false);
        }
        this.worlds.add(world);
        if (worldArray != null) {
            for (int i = 0; i < worldArray.length; ++i) {
                this.worlds.add(worldArray[i]);
            }
        }
        iterator = this.worlds.iterator();
        while (iterator.hasNext()) {
            world2 = (World)iterator.next();
            camera = world2.getCamera();
            Matrix matrix2 = camera.getBack().cloneMatrix();
            this.camStore.put(camera, matrix2);
            world2.invertCulling(true);
        }
        this.setupWaterReflection(frameBuffer);
        frameBuffer.setRenderTarget(this.ref, 1, 1, 1, 1, true);
        frameBuffer.setPaintListenerState(false);
        frameBuffer.clear(this.clearCol);
        iterator = this.worlds.iterator();
        while (iterator.hasNext()) {
            world2 = (World)iterator.next();
            world2.renderScene(frameBuffer);
            world2.draw(frameBuffer);
        }
        frameBuffer.update();
        frameBuffer.displayGLOnly();
        iterator = this.exclude.iterator();
        while (iterator.hasNext()) {
            ((Object3D)iterator.next()).setVisibility(true);
        }
        frameBuffer.setPaintListenerState(true);
        iterator = this.worlds.iterator();
        while (iterator.hasNext()) {
            world2 = (World)iterator.next();
            camera = world2.getCamera();
            camera.setBillBoardMatrix(null);
            camera.getBack().setTo((Matrix)this.camStore.get(camera));
            world2.invertCulling(false);
        }
        this.camStore.clear();
        this.worlds.clear();
        frameBuffer.removeRenderTarget();
        frameBuffer.removeClippingPlane(0);
    }

    private void setupWaterReflection(FrameBuffer frameBuffer) {
        Iterator iterator = this.worlds.iterator();
        while (iterator.hasNext()) {
            World world = (World)iterator.next();
            Camera camera = world.getCamera();
            this.mirror(this.planeObj, camera);
        }
        this.setClippingPlane(this.planeObj, ((World)this.worlds.get(0)).getCamera(), this.plane, frameBuffer);
    }

    private void setClippingPlane(Object3D object3D, Camera camera, Plane plane, FrameBuffer frameBuffer) {
        PolygonManager polygonManager = object3D.getPolygonManager();
        SimpleVector simpleVector = polygonManager.getTransformedVertex(0, 0);
        SimpleVector simpleVector2 = polygonManager.getTransformedVertex(0, 1);
        SimpleVector simpleVector3 = polygonManager.getTransformedVertex(0, 2);
        SimpleVector simpleVector4 = new SimpleVector();
        simpleVector = camera.transform(simpleVector);
        simpleVector2 = camera.transform(simpleVector2);
        simpleVector3 = camera.transform(simpleVector3);
        if (this.clippingPlaneOffset != 0.0f) {
            simpleVector4.createNormal(simpleVector, simpleVector2, simpleVector3);
            simpleVector4.scalarMul(this.clippingPlaneOffset);
            simpleVector.add(simpleVector4);
            simpleVector2.add(simpleVector4);
            simpleVector3.add(simpleVector4);
        }
        plane.setTo(simpleVector2, simpleVector, simpleVector3);
        frameBuffer.setClippingPlane(0, plane);
    }

    private void mirror(Object3D object3D, Camera camera) {
        Matrix matrix = new Matrix();
        matrix.set(1, 1, -1.0f);
        camera.setBillBoardMatrix(camera.getBack().cloneMatrix());
        Matrix matrix2 = new Matrix();
        matrix2.translate(camera.getPosition());
        Matrix matrix3 = matrix2.invert();
        matrix.set(3, 1, 2.0f * object3D.getTransformedCenter().y);
        matrix2.matMul(matrix);
        matrix2.matMul(matrix3);
        matrix2.matMul(camera.getBack());
        camera.getBack().setTo(matrix2);
    }

    public void finalize() {
        TextureManager textureManager;
        if (this.name != null && (textureManager = TextureManager.getInstance()).containsTexture(this.name)) {
            textureManager.removeTexture(this.name);
        }
        this.name = null;
    }

    public void setClippingPlaneOffset(float f) {
        this.clippingPlaneOffset = f;
    }

    public float getClippingPlaneOffset() {
        return this.clippingPlaneOffset;
    }
}

