/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import java.io.Serializable;

public class SimpleVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final SimpleVector ORIGIN = new SimpleVector(0.0f, 0.0f, 0.0f);
    public float x;
    public float y;
    public float z;
    private static final SimpleVector DOWN = new SimpleVector(0.0f, 1.0f, 0.0f);

    public SimpleVector(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public SimpleVector(double d, double d2, double d3) {
        this.x = (float)d;
        this.y = (float)d2;
        this.z = (float)d3;
    }

    public SimpleVector(SimpleVector simpleVector) {
        this.x = simpleVector.x;
        this.y = simpleVector.y;
        this.z = simpleVector.z;
    }

    public SimpleVector() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public SimpleVector(float[] fArray) {
        if (fArray.length == 3) {
            this.x = fArray[0];
            this.y = fArray[1];
            this.z = fArray[2];
        } else {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 0.0f;
            Logger.log("Source-array needs to have a length of 3", 0);
        }
    }

    public static SimpleVector create() {
        return new SimpleVector();
    }

    public static SimpleVector create(float f, float f2, float f3) {
        return new SimpleVector(f, f2, f3);
    }

    public static SimpleVector create(SimpleVector simpleVector) {
        return new SimpleVector(simpleVector);
    }

    public void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public void set(SimpleVector simpleVector) {
        this.x = simpleVector.x;
        this.y = simpleVector.y;
        this.z = simpleVector.z;
    }

    public float[] toArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public boolean equals(Object object) {
        if (object instanceof SimpleVector) {
            SimpleVector simpleVector = (SimpleVector)object;
            return simpleVector.x == this.x && simpleVector.y == this.y && simpleVector.z == this.z;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.x * 100.0f + this.y * 10.0f + this.z);
    }

    public SimpleVector rotate(SimpleVector simpleVector) {
        float f;
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = (float)Math.sin(simpleVector.x);
        float f6 = (float)Math.cos(simpleVector.x);
        float f7 = (float)Math.sin(simpleVector.y);
        float f8 = (float)Math.cos(simpleVector.y);
        float f9 = (float)Math.sin(simpleVector.z);
        float f10 = (float)Math.cos(simpleVector.z);
        float f11 = f2 * f10 - f3 * f9;
        float f12 = f2 * f9 + f3 * f10;
        f2 = f11;
        f3 = f12;
        f11 = f2 * f8 - f4 * f7;
        f4 = f = f2 * f7 + f4 * f8;
        f12 = f3 * f6 - f4 * f5;
        f = f3 * f5 + f4 * f6;
        return new SimpleVector(f11, f12, f);
    }

    public void rotateX(float f) {
        float f2 = this.y;
        float f3 = this.z;
        float f4 = (float)Math.sin(f);
        float f5 = (float)Math.cos(f);
        this.y = f2 * f5 - f3 * f4;
        this.z = f2 * f4 + f3 * f5;
    }

    public void rotateY(float f) {
        float f2 = this.x;
        float f3 = this.z;
        float f4 = (float)Math.sin(f);
        float f5 = (float)Math.cos(f);
        this.x = f2 * f5 - f3 * f4;
        this.z = f2 * f4 + f3 * f5;
    }

    public void rotateZ(float f) {
        float f2 = this.y;
        float f3 = this.x;
        float f4 = (float)Math.sin(f);
        float f5 = (float)Math.cos(f);
        this.x = f3 * f5 - f2 * f4;
        this.y = f3 * f4 + f2 * f5;
    }

    public SimpleVector normalize() {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.z;
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 != 0.0) {
            return new SimpleVector((float)(d / d4), (float)(d2 / d4), (float)(d3 / d4));
        }
        return new SimpleVector(0.0f, 0.0f, 0.0f);
    }

    public SimpleVector normalize(SimpleVector simpleVector) {
        float f;
        if (simpleVector == null) {
            simpleVector = SimpleVector.create();
        }
        if ((f = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z)) != 0.0f) {
            float f2 = 1.0f / f;
            simpleVector.set(this.x * f2, this.y * f2, this.z * f2);
        } else {
            simpleVector.set(0.0f, 0.0f, 0.0f);
        }
        return simpleVector;
    }

    public void createNormal(SimpleVector simpleVector, SimpleVector simpleVector2, SimpleVector simpleVector3) {
        float f = simpleVector2.x - simpleVector.x;
        float f2 = simpleVector2.y - simpleVector.y;
        float f3 = simpleVector2.z - simpleVector.z;
        float f4 = simpleVector3.x - simpleVector.x;
        float f5 = simpleVector3.y - simpleVector.y;
        float f6 = simpleVector3.z - simpleVector.z;
        this.x = f2 * f6 - f3 * f5;
        this.y = f3 * f4 - f * f6;
        this.z = f * f5 - f2 * f4;
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (d != 0.0) {
            this.x = (float)((double)this.x / d);
            this.y = (float)((double)this.y / d);
            this.z = (float)((double)this.z / d);
        }
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float distance(SimpleVector simpleVector) {
        float f = -this.x + simpleVector.x;
        float f2 = -this.y + simpleVector.y;
        float f3 = -this.z + simpleVector.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public SimpleVector calcCross(SimpleVector simpleVector) {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.z;
        double d4 = simpleVector.x;
        double d5 = simpleVector.y;
        double d6 = simpleVector.z;
        double d7 = d2 * d6 - d3 * d5;
        double d8 = d3 * d4 - d * d6;
        double d9 = d * d5 - d2 * d4;
        return new SimpleVector((float)d7, (float)d8, (float)d9);
    }

    public float calcDot(SimpleVector simpleVector) {
        return this.x * simpleVector.x + this.y * simpleVector.y + this.z * simpleVector.z;
    }

    public SimpleVector calcSub(SimpleVector simpleVector) {
        return new SimpleVector(this.x - simpleVector.x, this.y - simpleVector.y, this.z - simpleVector.z);
    }

    public float calcAngle(SimpleVector simpleVector) {
        float f;
        float f2 = this.x * simpleVector.x + this.y * simpleVector.y + this.z * simpleVector.z;
        float f3 = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if ((f2 /= f3 * (f = (float)Math.sqrt(simpleVector.x * simpleVector.x + simpleVector.y * simpleVector.y + simpleVector.z * simpleVector.z))) < -1.0f) {
            f2 = -1.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return (float)Math.acos(f2);
    }

    public void scalarMul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public void matMul(Matrix matrix) {
        float[][] fArray = matrix.mat;
        float f = this.x * fArray[0][0] + this.y * fArray[1][0] + this.z * fArray[2][0] + fArray[3][0];
        float f2 = this.x * fArray[0][1] + this.y * fArray[1][1] + this.z * fArray[2][1] + fArray[3][1];
        float f3 = this.x * fArray[0][2] + this.y * fArray[1][2] + this.z * fArray[2][2] + fArray[3][2];
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public void rotate(Matrix matrix) {
        float[][] fArray = matrix.mat;
        float f = this.x * fArray[0][0] + this.y * fArray[1][0] + this.z * fArray[2][0];
        float f2 = this.x * fArray[0][1] + this.y * fArray[1][1] + this.z * fArray[2][1];
        float f3 = this.x * fArray[0][2] + this.y * fArray[1][2] + this.z * fArray[2][2];
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public void add(SimpleVector simpleVector) {
        this.x += simpleVector.x;
        this.y += simpleVector.y;
        this.z += simpleVector.z;
    }

    public void sub(SimpleVector simpleVector) {
        this.x -= simpleVector.x;
        this.y -= simpleVector.y;
        this.z -= simpleVector.z;
    }

    public void makeEqualLength(SimpleVector simpleVector) {
        float f = simpleVector.length();
        float f2 = this.length();
        if (f2 > f) {
            SimpleVector simpleVector2 = this.normalize();
            simpleVector2.scalarMul(f);
            this.x = simpleVector2.x;
            this.y = simpleVector2.y;
            this.z = simpleVector2.z;
        }
    }

    public Matrix getRotationMatrix() {
        return this.getRotationMatrix(new Matrix(), DOWN);
    }

    public Matrix getRotationMatrix(SimpleVector simpleVector) {
        return this.getRotationMatrix(new Matrix(), simpleVector);
    }

    public Matrix getRotationMatrix(Matrix matrix) {
        return this.getRotationMatrix(matrix, DOWN);
    }

    public Matrix getRotationMatrix(Matrix matrix, SimpleVector simpleVector) {
        double d;
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        if (d2 == 0.0 && d4 == 0.0) {
            d2 += 1.0E-128;
        }
        if ((d = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4)) != 0.0) {
            d2 /= d;
            d3 /= d;
            d4 /= d;
        }
        float[][] fArray = matrix.mat;
        fArray[1][0] = 0.0f;
        fArray[1][1] = 1.0f;
        fArray[1][2] = 0.0f;
        fArray[2][0] = (float)d2;
        fArray[2][1] = (float)d3;
        fArray[2][2] = (float)d4;
        double d5 = simpleVector.x;
        double d6 = simpleVector.y;
        double d7 = simpleVector.z;
        double d8 = d2;
        double d9 = d3;
        double d10 = d4;
        double d11 = d6 * d10 - d7 * d9;
        double d12 = d7 * d8 - d5 * d10;
        double d13 = d5 * d9 - d6 * d8;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        d = Math.sqrt(d11 * d11 + d12 * d12 + d13 * d13);
        if (d != 0.0) {
            d11 /= d;
            d12 /= d;
            d13 /= d;
        }
        if ((d = Math.sqrt((d14 = d9 * d13 - d10 * d12) * d14 + (d15 = d10 * d11 - d8 * d13) * d15 + (d16 = d8 * d12 - d9 * d11) * d16)) != 0.0) {
            d14 /= d;
            d15 /= d;
            d16 /= d;
        }
        fArray[0][0] = (float)d11;
        fArray[0][1] = (float)d12;
        fArray[0][2] = (float)d13;
        fArray[1][0] = (float)d14;
        fArray[1][1] = (float)d15;
        fArray[1][2] = (float)d16;
        matrix.orthonormalizeDouble();
        return matrix;
    }
}

