/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Mesh;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.TextureInfo;
import com.threed.jpct.TextureManager;
import com.threed.jpct.Vectors;

public class PolygonManager {
    Object3D myObj = null;
    TextureManager texMan = null;

    PolygonManager(Object3D object3D) {
        this.myObj = object3D;
        this.texMan = TextureManager.getInstance();
    }

    public int getPolygonTexture(int n) {
        if (this.outOfBounds(n)) {
            return -1;
        }
        return this.myObj.texture[n];
    }

    public int[] getPolygonTextures(int n) {
        if (this.outOfBounds(n)) {
            return null;
        }
        int n2 = 0;
        if (this.myObj.multiTex != null) {
            n2 = this.myObj.multiTex.length;
        }
        int[] nArray = new int[1 + n2];
        nArray[0] = this.myObj.texture[n];
        if (this.myObj.multiTex != null) {
            for (int i = 0; i < this.myObj.multiTex.length; ++i) {
                nArray[1 + i] = this.myObj.multiTex[i][n];
            }
        }
        return nArray;
    }

    public void setPolygonTexture(int n, int n2) {
        if (this.outOfBounds(n)) {
            return;
        }
        this.myObj.texture[n] = n2;
    }

    public void addTexture(int n, int n2, int n3) {
        int n4;
        if (this.myObj.stripped) {
            return;
        }
        if (this.myObj.multiTex == null) {
            this.myObj.multiTex = new int[Config.maxTextureLayers - 1][this.myObj.texture.length];
            this.myObj.multiMode = new int[Config.maxTextureLayers - 1][this.myObj.texture.length];
            for (n4 = 0; n4 < this.myObj.texture.length; ++n4) {
                for (int i = 0; i < Config.maxTextureLayers - 1; ++i) {
                    this.myObj.multiTex[i][n4] = -1;
                }
            }
            this.myObj.objVectors.createMultiCoords();
        }
        for (n4 = 0; n4 < 3; ++n4) {
            if (this.myObj.multiTex[n4][n] != -1) continue;
            this.myObj.multiTex[n4][n] = n2;
            this.myObj.multiMode[n4][n] = n3;
            break;
        }
        this.myObj.usesMultiTexturing = true;
        ++this.myObj.maxStagesUsed;
        if (this.myObj.maxStagesUsed > Config.maxTextureLayers) {
            this.myObj.maxStagesUsed = Config.maxTextureLayers;
        }
    }

    public void setPolygonTexture(int n, TextureInfo textureInfo) {
        if (this.myObj.stripped) {
            return;
        }
        if (textureInfo != null) {
            if (this.myObj.multiTex == null && textureInfo.stageCnt > 1) {
                this.myObj.multiTex = new int[Config.maxTextureLayers - 1][this.myObj.texture.length];
                this.myObj.multiMode = new int[Config.maxTextureLayers - 1][this.myObj.texture.length];
                for (int i = 0; i < this.myObj.texture.length; ++i) {
                    for (int j = 0; j < Config.maxTextureLayers - 1; ++j) {
                        this.myObj.multiTex[j][i] = -1;
                    }
                }
                this.myObj.objVectors.createMultiCoords();
                this.myObj.usesMultiTexturing = true;
            }
            Vectors vectors = this.myObj.objVectors;
            float[] fArray = new float[]{textureInfo.u0[0], textureInfo.u1[0], textureInfo.u2[0]};
            float[] fArray2 = new float[]{textureInfo.v0[0], textureInfo.v1[0], textureInfo.v2[0]};
            int n2 = textureInfo.textures[0];
            if (this.myObj.maxStagesUsed < textureInfo.stageCnt) {
                this.myObj.maxStagesUsed = textureInfo.stageCnt;
            }
            boolean bl = this.myObj.usesMultiTexturing && textureInfo != null;
            this.myObj.texture[n] = n2;
            this.myObj.basemap[n] = n2;
            if (bl) {
                int n3;
                for (n3 = 0; n3 < textureInfo.stageCnt - 1; ++n3) {
                    this.myObj.multiTex[n3][n] = textureInfo.textures[n3 + 1];
                    this.myObj.multiMode[n3][n] = textureInfo.mode[n3 + 1];
                }
                for (n3 = textureInfo.stageCnt - 1; n3 < Config.maxTextureLayers - 1; ++n3) {
                    this.myObj.multiTex[n3][n] = -1;
                }
            }
            float f = 2.0f;
            float f2 = 2.0f;
            if (n2 != -1) {
                f = this.texMan.textures[n2].width;
                f2 = this.texMan.textures[n2].height;
            }
            float[] fArray3 = null;
            float[] fArray4 = null;
            for (int i = 0; i < 3; ++i) {
                int n4 = this.myObj.objMesh.points[n][i];
                vectors.nuOrg[n4] = fArray[i];
                vectors.nvOrg[n4] = fArray2[i];
                vectors.uOrg[n4] = fArray[i] * f;
                vectors.vOrg[n4] = fArray2[i] * f2;
                vectors.buOrg[n4] = fArray[i];
                vectors.bvOrg[n4] = fArray2[i];
                switch (i) {
                    case 0: {
                        fArray3 = textureInfo.u0;
                        fArray4 = textureInfo.v0;
                        break;
                    }
                    case 1: {
                        fArray3 = textureInfo.u1;
                        fArray4 = textureInfo.v1;
                        break;
                    }
                    case 2: {
                        fArray3 = textureInfo.u2;
                        fArray4 = textureInfo.v2;
                    }
                }
                for (int j = 0; j < textureInfo.stageCnt - 1; ++j) {
                    vectors.uMul[j][n4] = fArray3[j + 1];
                    vectors.vMul[j][n4] = fArray4[j + 1];
                }
            }
        }
    }

    public void setVertexAlpha(int n, int n2, float f) {
        if (this.myObj.stripped) {
            return;
        }
        if (this.outOfBounds(n) || n2 < 0 || n2 > 2) {
            return;
        }
        int n3 = this.myObj.objMesh.points[n][n2];
        Vectors vectors = this.myObj.objVectors;
        vectors.createAlpha();
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        vectors.alpha[n3] = f;
    }

    public SimpleVector getTransformedVertex(int n, int n2) {
        if (this.outOfBounds(n) || n2 < 0 || n2 > 2) {
            return null;
        }
        Matrix matrix = this.myObj.getWorldTransformation();
        SimpleVector simpleVector = new SimpleVector();
        Mesh mesh = this.myObj.objMesh;
        int n3 = mesh.coords[mesh.points[n][n2]];
        simpleVector.x = mesh.xOrg[n3];
        simpleVector.y = mesh.yOrg[n3];
        simpleVector.z = mesh.zOrg[n3];
        simpleVector.matMul(matrix);
        return simpleVector;
    }

    public SimpleVector getTextureUV(int n, int n2) {
        if (this.myObj.stripped) {
            return null;
        }
        if (this.outOfBounds(n) || n2 < 0 || n2 > 2) {
            return null;
        }
        int n3 = this.myObj.objMesh.points[n][n2];
        Vectors vectors = this.myObj.objVectors;
        SimpleVector simpleVector = new SimpleVector();
        simpleVector.x = vectors.nuOrg[n3];
        simpleVector.y = vectors.nvOrg[n3];
        return simpleVector;
    }

    public SimpleVector getTransformedNormal(int n) {
        if (this.outOfBounds(n)) {
            return null;
        }
        Matrix matrix = this.myObj.getWorldTransformation();
        SimpleVector simpleVector = new SimpleVector();
        Mesh mesh = this.myObj.objMesh;
        int n2 = mesh.coords[mesh.points[n][0]];
        int n3 = mesh.coords[mesh.points[n][1]];
        int n4 = mesh.coords[mesh.points[n][2]];
        simpleVector.x = mesh.xOrg[n4];
        simpleVector.y = mesh.yOrg[n4];
        simpleVector.z = mesh.zOrg[n4];
        simpleVector.matMul(matrix);
        float f = simpleVector.x;
        float f2 = simpleVector.y;
        float f3 = simpleVector.z;
        simpleVector.x = mesh.xOrg[n3];
        simpleVector.y = mesh.yOrg[n3];
        simpleVector.z = mesh.zOrg[n3];
        simpleVector.matMul(matrix);
        float f4 = simpleVector.x;
        float f5 = simpleVector.y;
        float f6 = simpleVector.z;
        simpleVector.x = mesh.xOrg[n2];
        simpleVector.y = mesh.yOrg[n2];
        simpleVector.z = mesh.zOrg[n2];
        simpleVector.matMul(matrix);
        float f7 = simpleVector.x - f;
        float f8 = simpleVector.y - f2;
        float f9 = simpleVector.z - f3;
        float f10 = f4 - f;
        float f11 = f5 - f2;
        float f12 = f6 - f3;
        simpleVector.x = f8 * f12 - f9 * f11;
        simpleVector.y = f9 * f10 - f7 * f12;
        simpleVector.z = f7 * f11 - f8 * f10;
        return simpleVector.normalize();
    }

    public int getMaxPolygonID() {
        return this.myObj.objMesh.anzTri;
    }

    private boolean outOfBounds(int n) {
        if (n < 0 || n >= this.myObj.objMesh.anzTri) {
            Logger.log("No such polygon!", 0);
            return true;
        }
        return false;
    }
}

