/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Vectors;
import com.threed.jpct.VisList;

public final class Interact2D {
    public static final int EXCLUDE_TRANSPARENT = 1;
    public static final int EXCLUDE_NOT_SELECTABLE = 2;
    private static final float VIEWPLANE_Z_VALUE = 1.0f;
    private static final float EPSILON = 1.0E-16f;
    private static final SimpleVector ORIGIN = new SimpleVector(0.0f, 0.0f, 0.0f);

    private Interact2D() {
    }

    public static SimpleVector reproject2D3D(Camera camera, FrameBuffer frameBuffer, int n, int n2) {
        return Interact2D.reproject2D3D(camera, frameBuffer, n, n2, 1.0f);
    }

    public static SimpleVector reproject2D3D(Camera camera, FrameBuffer frameBuffer, int n, int n2, SimpleVector simpleVector) {
        return Interact2D.reproject2D3D(camera, frameBuffer, n, n2, 1.0f, simpleVector);
    }

    public static SimpleVector reproject2D3DWS(Camera camera, FrameBuffer frameBuffer, int n, int n2) {
        SimpleVector simpleVector = Interact2D.reproject2D3D(camera, frameBuffer, n, n2, 1.0f);
        simpleVector.matMul(camera.backMatrix.invert3x3());
        return simpleVector;
    }

    public static SimpleVector reproject2D3DWS(Camera camera, FrameBuffer frameBuffer, int n, int n2, SimpleVector simpleVector) {
        SimpleVector simpleVector2 = Interact2D.reproject2D3D(camera, frameBuffer, n, n2, 1.0f, simpleVector);
        simpleVector2.matMul(camera.backMatrix.invert3x3());
        return simpleVector2;
    }

    public static SimpleVector reproject2D3D(Camera camera, FrameBuffer frameBuffer, int n, int n2, float f) {
        return Interact2D.reproject2D3D(camera, frameBuffer, n, n2, f, SimpleVector.create());
    }

    public static SimpleVector reproject2D3D(Camera camera, FrameBuffer frameBuffer, int n, int n2, float f, SimpleVector simpleVector) {
        camera.calcFOV(frameBuffer.width, frameBuffer.height);
        float f2 = frameBuffer.middleX + frameBuffer.middleX * 2.0f * Config.viewportOffsetX;
        float f3 = frameBuffer.middleY + frameBuffer.middleY * 2.0f * Config.viewportOffsetY;
        float f4 = ((float)n - f2) * f / camera.scaleX;
        float f5 = ((float)n2 - f3) * f / camera.scaleY;
        simpleVector.set(f4, f5, f);
        return simpleVector;
    }

    public static SimpleVector project3D2D(Camera camera, FrameBuffer frameBuffer, SimpleVector simpleVector) {
        return Interact2D.project3D2DInternal(camera, frameBuffer, simpleVector, null, null);
    }

    public static SimpleVector project3D2D(Camera camera, FrameBuffer frameBuffer, SimpleVector simpleVector, SimpleVector simpleVector2) {
        return Interact2D.project3D2DInternal(camera, frameBuffer, simpleVector, null, simpleVector2);
    }

    public static SimpleVector projectCenter3D2D(FrameBuffer frameBuffer, Object3D object3D) {
        return Interact2D.projectCenter3D2D(null, frameBuffer, object3D);
    }

    public static SimpleVector projectCenter3D2D(Camera camera, FrameBuffer frameBuffer, Object3D object3D) {
        if (camera == null && object3D.myWorld == null) {
            Logger.log("Object doesn't belong to a world!", 0);
            return new SimpleVector();
        }
        if (camera == null) {
            camera = object3D.myWorld.camera;
        }
        return Interact2D.project3D2DInternal(camera, frameBuffer, object3D.getCenter(), object3D.getWorldTransformation(), null);
    }

    public static int getObjectID(int[] nArray) {
        if (nArray == null || nArray.length < 2) {
            return -1;
        }
        return nArray[0];
    }

    public static int getPolygonID(int[] nArray) {
        if (nArray == null || nArray.length < 2) {
            return -1;
        }
        return nArray[1];
    }

    public static int[] pickPolygon(VisList visList, SimpleVector simpleVector) {
        return Interact2D.pickPolygon(visList, ORIGIN, simpleVector, 0);
    }

    public static int[] pickPolygon(VisList visList, SimpleVector simpleVector, int n) {
        return Interact2D.pickPolygon(visList, ORIGIN, simpleVector, n);
    }

    public static int[] pickPolygon(VisList visList, SimpleVector simpleVector, SimpleVector simpleVector2) {
        return Interact2D.pickPolygon(visList, simpleVector, simpleVector2, 0);
    }

    public static int[] pickPolygon(VisList visList, SimpleVector simpleVector, SimpleVector simpleVector2, int n) {
        float[] fArray = simpleVector2.toArray();
        float[] fArray2 = simpleVector.toArray();
        boolean bl = (n & 1) == 1;
        boolean bl2 = (n & 2) == 2;
        float f = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        fArray[0] = fArray[0] / f;
        fArray[1] = fArray[1] / f;
        fArray[2] = fArray[2] / f;
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        for (int i = 0; i <= visList.anzpoly; ++i) {
            Object3D object3D = visList.vorg[i];
            if (bl && object3D.isTrans || bl2 && !object3D.isSelectable || object3D.compiled != null) continue;
            int n6 = visList.vnumOrg[i];
            int n7 = object3D.objMesh.coords[object3D.objMesh.points[n6][0]];
            float f4 = object3D.objVectors.xTr[n7];
            float f5 = object3D.objVectors.yTr[n7];
            float f6 = object3D.objVectors.zTr[n7];
            int n8 = object3D.objMesh.coords[object3D.objMesh.points[n6][2]];
            int n9 = object3D.objMesh.coords[object3D.objMesh.points[n6][1]];
            fArray3[0] = f4;
            fArray3[1] = f5;
            fArray3[2] = f6;
            fArray4[0] = object3D.objVectors.xTr[n9];
            fArray4[1] = object3D.objVectors.yTr[n9];
            fArray4[2] = object3D.objVectors.zTr[n9];
            fArray5[0] = object3D.objVectors.xTr[n8];
            fArray5[1] = object3D.objVectors.yTr[n8];
            fArray5[2] = object3D.objVectors.zTr[n8];
            if ((f3 > f6 || f3 > fArray4[2] || f3 > fArray5[2]) && (f6 > 0.0f || fArray4[2] > 0.0f || fArray5[2] > 0.0f)) {
                float[] fArray6;
                float[] fArray7;
                float[] fArray8 = Vectors.calcSub(fArray4, fArray3);
                float f7 = Vectors.calcDot(fArray8, fArray7 = Vectors.calcCross(fArray, fArray6 = Vectors.calcSub(fArray5, fArray3)));
                if (f7 >= 1.0E-16f) {
                    float[] fArray9;
                    float f8;
                    float f9 = 1.0f / f7;
                    float[] fArray10 = Vectors.calcSub(fArray2, fArray3);
                    float f10 = Vectors.calcDot(fArray10, fArray7) * f9;
                    if ((double)f10 >= 0.0 && f10 <= 1.0f && (double)(f8 = Vectors.calcDot(fArray, fArray9 = Vectors.calcCross(fArray10, fArray8)) * f9) >= 0.0 && (double)(f10 + f8) <= 1.0) {
                        float f11 = Vectors.calcDot(fArray6, fArray9) * f9;
                        if (f11 >= 0.0f && f11 < f2) {
                            f2 = f11;
                            n5 = i;
                            float f12 = fArray3[2];
                            if (fArray4[2] > f12) {
                                f12 = fArray4[2];
                            }
                            if (fArray5[2] > f12) {
                                f12 = fArray5[2];
                            }
                            if (f3 > f12) {
                                f3 = f12;
                            }
                        }
                        ++n2;
                    }
                }
            } else {
                ++n3;
            }
            ++n4;
        }
        if (n5 != -1 && visList.vorg[n5].isSelectable) {
            return new int[]{visList.vorg[n5].number - 2, visList.vnumOrg[n5]};
        }
        return null;
    }

    static SimpleVector reproject2D3DBlit(float f, float f2, FrameBuffer frameBuffer, int n, int n2, float f3, SimpleVector simpleVector) {
        if (simpleVector == null) {
            simpleVector = new SimpleVector();
        }
        float f4 = ((float)n - frameBuffer.middleX) * f3 / f;
        float f5 = ((float)n2 - frameBuffer.middleY) * f3 / f2;
        simpleVector.x = f4;
        simpleVector.y = f5;
        simpleVector.z = f3;
        return simpleVector;
    }

    static SimpleVector reproject2D3DBlit(float f, float f2, FrameBuffer frameBuffer, int n, int n2, float f3, float f4, SimpleVector simpleVector) {
        if (simpleVector == null) {
            simpleVector = new SimpleVector();
        }
        float f5 = 1.0f / f4;
        float f6 = ((float)n - frameBuffer.middleX * f5) * f3 / (f * f5);
        float f7 = ((float)n2 - frameBuffer.middleY * f5) * f3 / (f2 * f5);
        simpleVector.x = f6;
        simpleVector.y = f7;
        simpleVector.z = f3;
        return simpleVector;
    }

    private static SimpleVector project3D2DInternal(Camera camera, FrameBuffer frameBuffer, SimpleVector simpleVector, Matrix matrix, SimpleVector simpleVector2) {
        Matrix matrix2 = camera.backMatrix;
        Matrix matrix3 = new Matrix();
        if (simpleVector2 == null) {
            simpleVector2 = new SimpleVector();
        }
        matrix3.mat[3][0] = -camera.backBx;
        matrix3.mat[3][1] = -camera.backBy;
        matrix3.mat[3][2] = -camera.backBz;
        if (matrix != null) {
            matrix.matMul(matrix3);
        } else {
            matrix = matrix3;
        }
        matrix.matMul(matrix2);
        float f = matrix.mat[2][2];
        float f2 = matrix.mat[1][2];
        float f3 = matrix.mat[0][2];
        float f4 = matrix.mat[3][2];
        float f5 = simpleVector.x;
        float f6 = simpleVector.y;
        float f7 = simpleVector.z;
        float f8 = f5 * f3 + f6 * f2 + f7 * f + f4;
        if (f8 > 0.0f) {
            float f9 = matrix.mat[0][0];
            float f10 = matrix.mat[1][0];
            float f11 = matrix.mat[1][1];
            float f12 = matrix.mat[2][1];
            float f13 = matrix.mat[2][0];
            float f14 = matrix.mat[0][1];
            float f15 = matrix.mat[3][0];
            float f16 = matrix.mat[3][1];
            float f17 = f5 * f9 + f6 * f10 + f7 * f13 + f15;
            float f18 = f5 * f14 + f6 * f11 + f7 * f12 + f16;
            float f19 = frameBuffer.middleX + frameBuffer.middleX * 2.0f * Config.viewportOffsetX;
            float f20 = frameBuffer.middleY + frameBuffer.middleY * 2.0f * Config.viewportOffsetY;
            camera.calcFOV(frameBuffer.width, frameBuffer.height);
            float f21 = 1.0f / f8;
            float f22 = camera.scaleX * (f17 * f21) + f19;
            float f23 = camera.scaleY * (f18 * f21) + f20;
            simpleVector2.set(f22, f23, f21);
            return simpleVector2;
        }
        simpleVector2.set(0.0f, 0.0f, 0.0f);
        return null;
    }
}

