/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.AWTDisplayList;
import com.threed.jpct.AWTGLRenderer;
import com.threed.jpct.Camera;
import com.threed.jpct.Config;
import com.threed.jpct.GLHelper;
import com.threed.jpct.IThreadBuffer;
import com.threed.jpct.Logger;
import com.threed.jpct.VisList;

class GLThreadBuffer
extends Thread
implements IThreadBuffer {
    private static final long serialVersionUID = 1L;
    private static final int PRIORITY = 6;
    private AWTGLRenderer renderer = null;
    private AWTDisplayList[] list = null;
    private AWTDisplayList onceList = null;
    private int curList = 0;
    private Object lock = new Object();
    private boolean paintObserver = false;
    private Object[] result = null;
    private int xs = 0;
    private int ys = 0;
    private int xe = 0;
    private int ye = 0;
    private int samples = 0;
    private boolean hasToDispose = false;
    private boolean hasToRender = false;
    private boolean sleeping = false;

    GLThreadBuffer(AWTGLRenderer aWTGLRenderer) throws Exception {
        this.init(aWTGLRenderer);
    }

    protected void init(AWTGLRenderer aWTGLRenderer) {
        this.renderer = aWTGLRenderer;
        this.list = new AWTDisplayList[2];
        this.list[0] = new AWTDisplayList();
        this.list[1] = new AWTDisplayList();
        this.onceList = new AWTDisplayList();
        this.setDaemon(true);
        this.setPriority(6);
        this.start();
    }

    public void setSamples(int n) {
        this.samples = n;
    }

    public Object getLock() {
        return this.lock;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.xe = n3;
        this.xs = n;
        this.ye = n4;
        this.ys = n2;
        this.hasToRender = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        Object object = this.lock;
        synchronized (object) {
            this.hasToRender = true;
            this.interrupt();
        }
    }

    public void dispose() {
        this.hasToDispose = true;
        this.interrupt();
    }

    public final void add(int n, Object object) {
        this.list[this.curList].add(n, object);
    }

    public void add(Camera camera, int[] nArray) {
        Object[] objectArray = new Object[2];
        Camera camera2 = new Camera();
        camera2.setBack(camera.getBack().cloneMatrix());
        camera2.setPosition(camera.getPosition());
        camera2.setFOVLimits(camera.getMinFOV(), camera.getMaxFOV());
        camera2.setFOV(camera.getFOV());
        objectArray[0] = camera2;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i];
        }
        objectArray[1] = nArray2;
        this.add(21, objectArray);
    }

    public final void addOnce(int n, Object object) {
        this.onceList.addOnce(n, object);
    }

    public final void add(VisList visList, int n, int n2, int n3) {
        this.list[this.curList].add(visList, n, n2, n3);
    }

    public final void setColor(int n) {
        this.list[this.curList].setColor(n);
    }

    public void enableRenderTarget() {
        this.list[this.curList].enableRenderTarget();
    }

    public void disableRenderTarget() {
        this.list[this.curList].disableRenderTarget();
    }

    public boolean hasRenderTarget() {
        return this.list[this.curList].hasRenderTarget();
    }

    public final AWTDisplayList getDisplayList() {
        return this.list[this.curList];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void switchList() {
        Object object = this.lock;
        synchronized (object) {
            this.list[this.curList].switchBuffers();
            this.curList ^= 1;
            this.list[this.curList].reset();
            this.hasToRender = true;
            if (this.sleeping) {
                this.interrupt();
            }
        }
    }

    public final boolean hasBeenPainted() {
        return this.paintObserver;
    }

    public final void observePainting() {
        this.paintObserver = false;
    }

    public final Object[] getPaintResults() {
        if (this.hasBeenPainted()) {
            Object[] objectArray = this.result;
            this.result = null;
            return objectArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Logger.log("Display thread initialized!", 2);
        try {
            boolean bl = false;
            while (!bl) {
                if (!this.hasToRender && !this.hasToDispose) {
                    try {
                        this.sleeping = true;
                        Thread.sleep(100L);
                        this.sleeping = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.hasToDispose) {
                    GLHelper.dispose();
                    bl = true;
                    this.hasToDispose = false;
                    this.hasToRender = false;
                }
                if (!this.hasToRender || this.xe == 0) continue;
                if (!this.renderer.isDisposed()) {
                    if (!this.renderer.isInitialized()) {
                        boolean bl2 = GLHelper.init(this.xe - this.xs, this.ye - this.ys, Config.glColorDepth, Config.glZBufferDepth, this.samples);
                        if (!bl2) {
                            Logger.log("Error initializing display thread!", 0);
                            return;
                        }
                        this.renderer.init();
                    }
                    this.renderer.execute(12, null);
                    Object object = this.lock;
                    synchronized (object) {
                        int n;
                        int n2;
                        this.hasToRender = false;
                        int n3 = this.curList ^ 1;
                        AWTDisplayList aWTDisplayList = this.list[n3];
                        int n4 = aWTDisplayList.count;
                        block15: for (n2 = 0; n2 < n4; ++n2) {
                            n = aWTDisplayList.mode[n2];
                            switch (n) {
                                case 3: {
                                    this.renderer.executeGL(aWTDisplayList, n2);
                                    continue block15;
                                }
                                case 2: {
                                    this.renderer.drawVertexArray(aWTDisplayList, n2);
                                    continue block15;
                                }
                                case 1: {
                                    this.renderer.drawStrip(aWTDisplayList, n2);
                                    continue block15;
                                }
                                case 0: {
                                    this.renderer.drawPolygon(aWTDisplayList, n2);
                                    continue block15;
                                }
                                case 5: {
                                    this.renderer.drawWireframe(aWTDisplayList, n2);
                                }
                            }
                        }
                        n2 = this.paintObserver ? 1 : 0;
                        if (this.onceList.count != 0) {
                            n = 0;
                            for (int i = 0; i < this.onceList.count; ++i) {
                                int n5 = this.onceList.mode[i];
                                if (n5 != 4 || n2 != 0) continue;
                                this.result = this.renderer.executeGL(this.onceList, i);
                                this.onceList.delete(i);
                                n = 1;
                            }
                            this.paintObserver = n;
                        }
                    }
                } else {
                    bl = true;
                }
                this.renderer.execute(13, null);
                this.renderer.endState();
                GLHelper.swap();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        Logger.log("Display thread terminated!", 2);
    }

    public boolean isVisible() {
        return true;
    }
}

