/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Camera;
import com.threed.jpct.CompiledInstance;
import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.GLHelper;
import com.threed.jpct.ICompiledInstance;
import com.threed.jpct.IPaintListener;
import com.threed.jpct.IPostProcessor;
import com.threed.jpct.IRenderHook;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Interact2D;
import com.threed.jpct.Logger;
import com.threed.jpct.Matrix;
import com.threed.jpct.Projector;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Texture;
import com.threed.jpct.TextureManager;
import com.threed.jpct.VideoMode;
import com.threed.jpct.World;
import java.awt.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Util;
import org.lwjgl.util.glu.GLU;

abstract class GLBase {
    static final int MODE_SET_FRUSTUM = 0;
    static final int MODE_SWAP_BUFFERS = 1;
    static final int MODE_CLEAR = 2;
    static final int MODE_PRINT_LOGS = 3;
    static final int MODE_BLIT_TEXTURE = 4;
    static final int MODE_FLUSH = 5;
    static final int MODE_GRAB_SCREEN = 6;
    static final int MODE_BLIT_INT = 7;
    static final int MODE_END_STATE = 8;
    static final int MODE_SET_VIEWPORT = 9;
    static final int MODE_CHECK_EXT = 10;
    static final int MODE_RETURN_CANVAS = 11;
    static final int MODE_START_PAINTING = 12;
    static final int MODE_END_PAINTING = 13;
    static final int MODE_SET_CANVAS_MODE = 14;
    static final int MODE_CLEAR_ZBUFFER = 15;
    static final int MODE_POST_PROCESS = 16;
    static final int MODE_DISPOSE_PROCESSOR = 17;
    static final int MODE_SET_RENDER_TARGET = 18;
    static final int MODE_SET_CAMERA = 21;
    static final int MODE_SET_TEXTURE_PROJECTOR = 22;
    static final int MODE_REINIT = 23;
    static final int MODE_SET_LISTENER_STATE = 24;
    static final int MODE_GET_MAX_TEXTURE_SIZE = 25;
    static final int MODE_ADD_CLIPPING_PLANE = 26;
    static final int MODE_REMOVE_CLIPPING_PLANE = 27;
    static final int MODE_RENDER_TO_TARGET = 1000;
    protected static float COLOR_INV = 0.003921569f;
    protected static final int VERTEX_ARRAY_SIZE = 1000;
    protected static int[] stageMap = new int[]{33984, 33985, 33986, 33987};
    protected static int[] modeMap = new int[]{8448, 8448, 260, 7681, 3042, 34164, 34023};
    protected static int[] blendSrcMap = new int[]{0, 0, 1, 1, 0};
    protected static int[] blendDstMap = new int[]{768, 768, 1, 0, 769};
    private static final int NO_STATE = -999989;
    protected static int rendererID = 0;
    protected int myID;
    protected float lastFOV;
    protected boolean lastFOVMode = Config.autoMaintainAspectRatio;
    protected boolean init = false;
    protected int stateChanges = 0;
    protected World myWorld = null;
    protected IntBuffer pixelBuffer;
    protected int pixelBufferSize = 0;
    protected Texture blitBuffer;
    protected int blitBufferWidth = 0;
    protected int blitBufferHeight = 0;
    protected int currentRGBScaling = 1;
    protected TextureManager texMan = null;
    protected int curPos = 0;
    protected int colPos = 0;
    protected int vertPos = 0;
    protected int texPos = 0;
    protected int[] mtTexPos = null;
    protected boolean wasTransparent = false;
    protected int lastTransMode = 0;
    protected boolean vertexArraysInitialized = false;
    protected int xp;
    protected int yp;
    protected boolean textureMatrixSet = false;
    protected boolean disposed = false;
    protected IPaintListener listener = null;
    protected boolean listenerActive = true;
    protected float scaleX;
    protected float scaleY;
    protected boolean[] stageInitialized = new boolean[4];
    protected int[] lastTextures = new int[4];
    protected int maxStages = 0;
    protected int[] lastMultiTextures = new int[4];
    protected int[] lastIDs = new int[4];
    protected int[] lastMultiModes = new int[4];
    protected int[] lastMode = new int[4];
    protected int minDriverAndConfig = 0;
    protected int lastCoords = 1;
    protected int veryLastCoords = 1;
    protected int lastTexture;
    protected float lastFarPlane = -999.0f;
    protected float lastNearPlane = -999.0f;
    protected FloatBuffer colors = null;
    protected FloatBuffer vertices = null;
    protected FloatBuffer textures = null;
    protected DoubleBuffer clippingBuffer = null;
    protected FloatBuffer[] multiTextures = new FloatBuffer[4];
    protected Texture renderTarget = null;
    protected int yTargetStart = 0;
    protected int xViewStart = 0;
    protected int yViewStart = 0;
    protected int xViewEnd = 0;
    protected int yViewEnd = 0;
    protected Matrix textureScale = new Matrix();
    protected boolean[] projective = new boolean[4];
    protected boolean alphaTest = false;
    protected boolean useFBO = false;
    protected int fbo = -1;
    protected int fboTexture = -1;
    protected boolean fboDepthMode = false;
    protected Texture fboColorStorage = null;
    protected Texture fboDepthStorage = null;
    protected boolean blending = false;
    protected IRenderHook lastHook = null;
    private boolean hasOpenGL12 = false;
    private boolean[] buffersEnabled = new boolean[4];
    private boolean[] enabledStages = new boolean[4];
    private boolean singleTexturing = true;
    private int currentFogColor = -1;
    private boolean currentFoggingState = false;
    private float currentFogDistance = -1.0f;
    private int lastState = -999989;
    private int changeCnt = 0;
    private int supportsRGBScaling = 0;
    private int supportsShadowMapping = 0;
    private int textureBufferSize = 0;
    private IntBuffer smallBuffer = null;
    private ByteBuffer textureBuffer;
    private SimpleVector blitCoords1 = new SimpleVector();
    private SimpleVector blitCoords2 = new SimpleVector();
    private boolean depthBuffer = false;
    protected boolean blitMode = false;
    private boolean blitTrans = false;
    private boolean blitAdditive = false;
    private boolean scissorEnabled = false;
    private boolean scissorClearAll = true;
    private int blitScaling = 0;
    private float[] floatBuffer = new float[16];
    private Map fovMatrixCache = new HashMap();
    private FloatBuffer floatBuffer64 = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private FloatBuffer floatBuffer16 = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected FloatBuffer ambientBuffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private Set toUnload = new HashSet();
    protected Map matrixCache = new HashMap();
    private List toDispose = new ArrayList();
    private List toDisposeVBO = new ArrayList();
    private Set toCompileToDLOrVBO = new HashSet();
    private boolean foggingOn = false;

    protected GLBase() {
        float[] fArray = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 1.0f};
        this.textureScale.setDump(fArray);
        this.resetStates();
        this.myID = rendererID++;
        this.lastFOV = -999.0f;
        this.lastFarPlane = -999.0f;
        this.lastNearPlane = -999.0f;
        this.init = false;
        this.lastTexture = 0;
        this.stateChanges = 0;
        this.pixelBuffer = null;
        this.pixelBufferSize = 0;
        this.textureBuffer = null;
        this.textureBufferSize = 0;
        this.blitBuffer = null;
        this.blitBufferWidth = 0;
        this.blitBufferHeight = 0;
        this.supportsRGBScaling = 0;
        this.texMan = TextureManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int n) {
        GLBase gLBase = this;
        synchronized (gLBase) {
            this.toDispose.add(IntegerC.valueOf(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBuffer(int n) {
        GLBase gLBase = this;
        synchronized (gLBase) {
            this.toDisposeVBO.add(IntegerC.valueOf(n));
        }
    }

    protected void resetStates() {
        for (int i = 0; i < 4; ++i) {
            this.stageInitialized[i] = false;
            this.enabledStages[i] = false;
            this.buffersEnabled[i] = false;
            this.lastTextures[i] = 0;
            this.lastMultiTextures[i] = 0;
            this.lastIDs[i] = 0;
            this.lastMultiModes[i] = 0;
            this.lastMode[i] = -1;
        }
    }

    public final void setPaintListener(IPaintListener iPaintListener) {
        this.listener = iPaintListener;
    }

    public final boolean isInitialized() {
        return this.init;
    }

    public VideoMode[] getAvailableVideoModes() {
        try {
            DisplayMode[] displayModeArray = Display.getAvailableDisplayModes();
            VideoMode[] videoModeArray = new VideoMode[displayModeArray.length];
            for (int i = 0; i < displayModeArray.length; ++i) {
                if (displayModeArray[i] == null) continue;
                videoModeArray[i] = new VideoMode(displayModeArray[i].getWidth(), displayModeArray[i].getHeight(), displayModeArray[i].getBitsPerPixel(), Config.glZBufferDepth, displayModeArray[i].getFrequency());
            }
            return videoModeArray;
        }
        catch (Exception exception) {
            Logger.log("Couldn't get available video modes: " + exception.getMessage(), 0);
            return null;
        }
    }

    protected synchronized void addToCompile(ICompiledInstance iCompiledInstance) {
        this.toCompileToDLOrVBO.add(iCompiledInstance);
    }

    protected synchronized void compileDLOrVBO() {
        if (this.toCompileToDLOrVBO.size() != 0) {
            Iterator iterator = this.toCompileToDLOrVBO.iterator();
            while (iterator.hasNext()) {
                ICompiledInstance iCompiledInstance = (ICompiledInstance)iterator.next();
                if (!iCompiledInstance.isFilled()) {
                    Logger.log("Internal error: Unfilled object!", 0);
                }
                iCompiledInstance.compileToDL();
            }
            if (Config.glUseVBO) {
                Logger.log("Compiled " + this.toCompileToDLOrVBO.size() + " VBO!", 2);
            } else {
                Logger.log("Compiled " + this.toCompileToDLOrVBO.size() + " display lists!", 2);
            }
            this.toCompileToDLOrVBO.clear();
            this.renableVertexArrays();
        }
    }

    protected void unsetBlendingMode() {
        if (this.renderTarget == null || !this.renderTarget.isShadowMap) {
            GL11.glDisable(3042);
        } else {
            GL11.glDisable(3008);
            this.alphaTest = false;
        }
    }

    protected void setDepthBuffer() {
        if (this.renderTarget == null || !this.renderTarget.isShadowMap) {
            GL11.glDepthMask(false);
        }
    }

    protected void clear(Object[] objectArray) {
        if (this.scissorEnabled && this.scissorClearAll) {
            GL11.glDisable(3089);
        }
        int n = 256;
        if (!Config.isIndoor) {
            n |= 0x4000;
            if (objectArray != null) {
                Color color = (Color)objectArray[0];
                GL11.glClearColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
            } else {
                GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        GL11.glClear(n);
        if (this.scissorEnabled && this.scissorClearAll) {
            GL11.glEnable(3089);
        }
    }

    protected void clearZBufferOnly() {
        if (this.scissorEnabled && this.scissorClearAll) {
            GL11.glDisable(3089);
        }
        GL11.glClear(256);
        if (this.scissorEnabled && this.scissorClearAll) {
            GL11.glEnable(3089);
        }
    }

    protected void setBlendingMode(int n) {
        if (this.renderTarget == null || !this.renderTarget.isShadowMap) {
            switch (n) {
                case 0: {
                    GL11.glEnable(3042);
                    GL11.glBlendFunc(770, 771);
                    break;
                }
                case 1: {
                    GL11.glEnable(3042);
                    GL11.glBlendFunc(770, 1);
                }
            }
        } else {
            GL11.glAlphaFunc(518, 0.01f);
            GL11.glEnable(3008);
        }
    }

    protected void doPostProcessing(Object[] objectArray) {
        this.endState();
        IPostProcessor iPostProcessor = (IPostProcessor)objectArray[1];
        if (!iPostProcessor.isInitialized()) {
            iPostProcessor.init((FrameBuffer)objectArray[0]);
        }
        int n = this.currentRGBScaling;
        this.disableAllHigherStages();
        this.enableStage(0);
        if (this.projective[0]) {
            this.projective[0] = false;
            this.disableProjection();
        }
        this.setRGBScaling(1);
        if (this.renderTarget != null) {
            this.resetViewport((FrameBuffer)objectArray[0]);
        }
        this.lastTextures[0] = -1;
        this.switchTextureMode(0, modeMap[0]);
        iPostProcessor.process();
        if (this.renderTarget != null) {
            this.setViewport((FrameBuffer)objectArray[0]);
        }
        this.setRGBScaling(n);
    }

    protected void setTextureMatrix(Matrix matrix) {
        if (this.textureMatrixSet) {
            ARBMultitexture.glActiveTextureARB(stageMap[0]);
            GL11.glMatrixMode(5890);
            GL11.glPopMatrix();
            this.textureMatrixSet = false;
        }
        if (matrix != null) {
            ARBMultitexture.glActiveTextureARB(stageMap[0]);
            GL11.glMatrixMode(5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            float[] fArray = matrix.getDump();
            ((Buffer)this.floatBuffer64).rewind();
            this.floatBuffer64.put(fArray);
            ((Buffer)this.floatBuffer64).rewind();
            GL11.glLoadMatrix(this.floatBuffer64);
            this.textureMatrixSet = true;
        }
    }

    protected void setRenderTarget(Object[] objectArray) {
        this.renderTarget = (Texture)objectArray[0];
        FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
        int n = (Integer)objectArray[2];
        int n2 = (Integer)objectArray[3];
        int n3 = (Integer)objectArray[4];
        int n4 = (Integer)objectArray[5];
        this.scissorClearAll = (Boolean)objectArray[6];
        if (this.renderTarget != null) {
            this.enableScissor(frameBuffer, this.renderTarget, n, n2, n3, n4);
        } else {
            this.disableScissor();
        }
        if (!this.useFBO) {
            if (this.renderTarget == null) {
                this.resetViewport(frameBuffer);
                GL11.glColorMask(true, true, true, true);
            } else {
                this.setViewport(frameBuffer);
                if (this.renderTarget.isShadowMap) {
                    GL11.glColorMask(false, false, false, false);
                }
            }
        } else if (this.renderTarget == null) {
            GL11.glColorMask(true, true, true, true);
            if (this.fbo != -1) {
                EXTFramebufferObject.glBindFramebufferEXT(36160, 0);
                this.resetViewport(frameBuffer);
            }
        } else {
            if (this.fbo == -1 || this.fboTexture != this.renderTarget.getOpenGLID(this.myID) || this.fboDepthMode != this.renderTarget.isShadowMap) {
                IntBuffer intBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
                if (this.fbo != -1) {
                    intBuffer.put(this.fbo);
                    ((Buffer)intBuffer).rewind();
                    EXTFramebufferObject.glDeleteFramebuffersEXT(intBuffer);
                    ((Buffer)intBuffer).rewind();
                    this.fbo = -1;
                }
                EXTFramebufferObject.glGenFramebuffersEXT(intBuffer);
                this.fbo = intBuffer.get();
                if (this.renderTarget.getOpenGLID(this.myID) == 0) {
                    this.renderTarget.setMarker(this.myID, Texture.MARKER_NOTHING);
                    this.endState();
                    this.convertTexture(this.renderTarget);
                    this.lastTextures[0] = -1;
                }
                int n5 = this.renderTarget.getOpenGLID(this.myID);
                this.bindTexture(0, n5);
                this.fboTexture = this.renderTarget.getOpenGLID(this.myID);
                this.fboDepthMode = this.renderTarget.isShadowMap;
                int n6 = 36064;
                if (this.fboDepthMode) {
                    n6 = 36096;
                }
                EXTFramebufferObject.glBindFramebufferEXT(36160, this.fbo);
                EXTFramebufferObject.glFramebufferTexture2DEXT(36160, n6, 3553, n5, 0);
                if (this.fboDepthMode) {
                    if (this.fboColorStorage != null && (this.fboColorStorage.getHeight() != this.renderTarget.getHeight() || this.fboColorStorage.getWidth() != this.renderTarget.getWidth())) {
                        this.removeTexture(this.fboColorStorage);
                        this.fboColorStorage = null;
                    }
                    if (this.fboColorStorage == null) {
                        this.fboColorStorage = new Texture(this.renderTarget.getWidth(), this.renderTarget.getHeight(), null);
                        this.fboColorStorage.setGLFiltering(false);
                        this.fboColorStorage.setMipmap(false);
                        this.convertTexture(this.fboColorStorage);
                        this.fboColorStorage.texels = null;
                    }
                    int n7 = this.fboColorStorage.getOpenGLID(this.myID);
                    if (!Config.glIgnoreAlphaBlendingFBO) {
                        EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36064, 3553, n7, 0);
                    }
                    GL11.glReadBuffer(0);
                    if (Config.glIgnoreAlphaBlendingFBO) {
                        GL11.glDrawBuffer(0);
                    }
                    GL11.glColorMask(false, false, false, false);
                } else {
                    if (this.fboDepthStorage != null && (this.fboDepthStorage.getHeight() != this.renderTarget.getHeight() || this.fboDepthStorage.getWidth() != this.renderTarget.getWidth())) {
                        this.removeTexture(this.fboDepthStorage);
                        this.fboDepthStorage = null;
                    }
                    if (this.fboDepthStorage == null) {
                        this.fboDepthStorage = new Texture(this.renderTarget.getWidth(), this.renderTarget.getHeight(), null);
                        this.fboDepthStorage.setGLFiltering(false);
                        this.fboDepthStorage.setMipmap(false);
                        this.fboDepthStorage.setAsShadowMap(true);
                        this.convertTexture(this.fboDepthStorage);
                        this.fboDepthStorage.texels = null;
                    }
                    int n8 = this.fboDepthStorage.getOpenGLID(this.myID);
                    EXTFramebufferObject.glFramebufferTexture2DEXT(36160, 36096, 3553, n8, 0);
                    GL11.glColorMask(true, true, true, true);
                }
                this.checkFrameBufferObject();
            } else {
                EXTFramebufferObject.glBindFramebufferEXT(36160, this.fbo);
            }
            GL11.glViewport(0, 0, this.renderTarget.getWidth(), this.renderTarget.getHeight());
        }
    }

    private void checkFrameBufferObject() {
        int n = EXTFramebufferObject.glCheckFramebufferStatusEXT(36160);
        if (n != 36053) {
            this.useFBO = false;
            this.fbo = -1;
        }
        switch (n) {
            case 36053: {
                break;
            }
            case 36054: {
                Logger.log("FrameBuffer: " + this.fbo + " has caused a GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT exception", 0);
                break;
            }
            case 36055: {
                Logger.log("FrameBuffer: " + this.fbo + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT exception", 0);
                break;
            }
            case 36057: {
                Logger.log("FrameBuffer: " + this.fbo + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT exception", 0);
                break;
            }
            case 36059: {
                Logger.log("FrameBuffer: " + this.fbo + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT exception", 0);
                break;
            }
            case 36058: {
                Logger.log("FrameBuffer: " + this.fbo + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT exception", 0);
                break;
            }
            case 36060: {
                Logger.log("FrameBuffer: " + this.fbo + ", has caused a GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT exception", 0);
                break;
            }
            default: {
                Logger.log("Unexpected reply from glCheckFramebufferStatusEXT: " + n, 0);
            }
        }
    }

    protected Matrix createTextureProjectionMatrix(Camera camera, Texture texture) {
        float f = camera.getFOV();
        String string = new Float(f + 100.0f * camera.getYFOV()) + texture.toString();
        Matrix matrix = (Matrix)this.fovMatrixCache.get(string);
        if (matrix == null) {
            GL11.glMatrixMode(5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            float f2 = f;
            if (Config.autoMaintainAspectRatio) {
                f2 = f * ((float)texture.width / (float)texture.height);
            }
            if (camera.getYFOV() != -1.0f && (f2 = camera.getYFOV()) == 0.0f) {
                f2 = 1.0E-5f;
            }
            float f3 = Config.farPlane;
            float f4 = 1.0f;
            if (!Config.glIgnoreNearPlane) {
                f4 = Config.nearPlane;
            }
            float f5 = f2 * 0.5f;
            float f6 = -f2 * 0.5f;
            float f7 = -f * 0.5f;
            float f8 = f * 0.5f;
            GL11.glFrustum(f7, f8, f6, f5, f4, f3);
            GL11.glGetFloat(2983, this.floatBuffer64);
            GL11.glPopMatrix();
            ((Buffer)this.floatBuffer64).rewind();
            matrix = new Matrix();
            float[] fArray = this.floatBuffer;
            for (int i = 0; i < 16; ++i) {
                fArray[i] = this.floatBuffer64.get(i);
            }
            matrix.setDump(fArray);
            if (this.fovMatrixCache.size() > 1000) {
                this.fovMatrixCache.clear();
            }
            this.fovMatrixCache.put(string, matrix);
        }
        return matrix;
    }

    protected void resetTextureStates() {
        for (int i = 0; i < 4; ++i) {
            this.lastTextures[i] = -1;
        }
    }

    protected void processProjection(int n, Texture texture, Camera camera) {
        if (texture.projector != null || texture.projectorBuffer != null) {
            int n2;
            Matrix matrix = new Matrix();
            Matrix matrix2 = null;
            SimpleVector simpleVector = camera.getPosition();
            matrix2 = camera.getBack().cloneMatrix();
            matrix2.transformToGL();
            matrix2 = matrix2.invert3x3();
            matrix2.mat[3][0] = simpleVector.x;
            matrix2.mat[3][1] = simpleVector.y;
            matrix2.mat[3][2] = simpleVector.z;
            Projector projector = texture.projectorBuffer;
            if (projector == null) {
                projector = texture.projector;
            }
            simpleVector = projector.getPosition();
            matrix.mat[3][0] = -simpleVector.x;
            matrix.mat[3][1] = -simpleVector.y;
            matrix.mat[3][2] = -simpleVector.z;
            matrix2.matMul(matrix);
            Matrix matrix3 = projector.getBack().cloneMatrix();
            matrix3.rotateX((float)Math.PI);
            matrix2.matMul(matrix3);
            matrix2.matMul(this.createTextureProjectionMatrix(projector, texture));
            matrix2.matMul(this.textureScale);
            float[] fArray = matrix2.getDump();
            ((Buffer)this.floatBuffer16).rewind();
            for (n2 = 0; n2 < 4; ++n2) {
                this.floatBuffer16.put(fArray[n2 << 2]);
            }
            ((Buffer)this.floatBuffer16).flip();
            GL11.glTexGeni(8192, 9472, 9216);
            GL11.glTexGen(8192, 9474, this.floatBuffer16);
            GL11.glEnable(3168);
            ((Buffer)this.floatBuffer16).rewind();
            for (n2 = 0; n2 < 4; ++n2) {
                this.floatBuffer16.put(fArray[1 + (n2 << 2)]);
            }
            ((Buffer)this.floatBuffer16).flip();
            GL11.glTexGeni(8193, 9472, 9216);
            GL11.glTexGen(8193, 9474, this.floatBuffer16);
            GL11.glEnable(3169);
            ((Buffer)this.floatBuffer16).rewind();
            for (n2 = 0; n2 < 4; ++n2) {
                this.floatBuffer16.put(fArray[2 + (n2 << 2)]);
            }
            ((Buffer)this.floatBuffer16).flip();
            GL11.glTexGeni(8194, 9472, 9216);
            GL11.glTexGen(8194, 9474, this.floatBuffer16);
            GL11.glEnable(3170);
            ((Buffer)this.floatBuffer16).rewind();
            for (n2 = 0; n2 < 4; ++n2) {
                this.floatBuffer16.put(fArray[3 + (n2 << 2)]);
            }
            ((Buffer)this.floatBuffer16).flip();
            GL11.glTexGeni(8195, 9472, 9216);
            GL11.glTexGen(8195, 9474, this.floatBuffer16);
            GL11.glEnable(3171);
            if (texture.getOpenGLID(this.myID) == 0) {
                texture.setMarker(this.myID, Texture.MARKER_NOTHING);
                this.endState();
                this.convertTexture(texture);
                this.lastTextures[0] = -1;
            }
            this.projective[n] = true;
            if (texture.isShadowMap) {
                this.enableShadowMapping(texture);
            }
        }
    }

    protected void enableShadowMapping(Texture texture) {
        if (this.renderTarget != texture) {
            GL11.glAlphaFunc(518, 0.01f);
            GL11.glEnable(3008);
            this.alphaTest = true;
        }
    }

    protected void disableProjection() {
        GL11.glDisable(3168);
        GL11.glDisable(3169);
        GL11.glDisable(3170);
        GL11.glDisable(3171);
    }

    protected void disableGlobalAlphaTest() {
        if (this.alphaTest) {
            GL11.glDisable(3008);
            this.alphaTest = false;
        }
    }

    protected void disableShadowMap() {
        this.disableGlobalAlphaTest();
    }

    protected boolean renderToTarget() {
        if (this.renderTarget == null) {
            return false;
        }
        if (this.useFBO) {
            return true;
        }
        this.disableUnusedStages();
        this.switchTextureMode(0, modeMap[0]);
        this.endState();
        int n = this.currentRGBScaling;
        this.setRGBScaling(1);
        if (this.renderTarget.getOpenGLID(this.myID) == 0) {
            this.renderTarget.setMarker(this.myID, Texture.MARKER_NOTHING);
            this.endState();
            this.convertTexture(this.renderTarget);
            this.lastTextures[0] = -1;
        }
        int n2 = this.renderTarget.getOpenGLID(this.myID);
        this.bindTexture(0, n2);
        if (this.renderTarget.isShadowMap) {
            if (this.supportsShadowMapping == 1) {
                GL11.glCopyTexSubImage2D(3553, 0, 0, 0, 0, this.yTargetStart, this.renderTarget.getWidth(), this.renderTarget.getHeight());
            }
        } else if (Config.glFlipRenderTargets) {
            GLBase.toOrtho();
            GL11.glCopyTexImage2D(3553, 0, 6407, 0, this.yTargetStart, this.renderTarget.getWidth(), this.renderTarget.getHeight(), 0);
            this.disableDepthBuffer();
            this.drawQuad();
            this.enableDepthBuffer();
            GL11.glCopyTexImage2D(3553, 0, 6407, 0, this.yTargetStart, this.renderTarget.getWidth(), this.renderTarget.getHeight(), 0);
            GLBase.restorePerspectiveProjection();
        } else {
            GL11.glCopyTexImage2D(3553, 0, 6407, 0, this.yTargetStart, this.renderTarget.getWidth(), this.renderTarget.getHeight(), 0);
        }
        this.setRGBScaling(n);
        return true;
    }

    protected void disableAllHigherStages() {
        for (int i = 1; i < this.maxStages; ++i) {
            this.disableStage(i);
        }
    }

    private void drawQuad() {
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(0.0f, 1.0f, -1.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(0.0f, 0.0f, -1.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(1.0f, 0.0f, -1.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(1.0f, 1.0f, -1.0f);
        GL11.glEnd();
    }

    private static void toOrtho() {
        GL11.glMatrixMode(5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode(5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, 1.0, 1.0, 0.0, 0.1, 100.0);
    }

    private static void restorePerspectiveProjection() {
        GL11.glMatrixMode(5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode(5888);
        GL11.glPopMatrix();
    }

    protected final void init(boolean bl, int n, int n2) {
        if (bl) {
            GL11.glViewport(0, 0, n, n2);
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
            GL11.glShadeModel(7425);
            GL11.glClearDepth(1.0);
            this.enableDepthBuffer();
            GL11.glDepthFunc(515);
            GL11.glHint(3152, 4354);
            GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            GL11.glClear(16640);
            this.initTextureStage(0);
            this.lastFOV = -999.0f;
            this.lastFarPlane = -999.0f;
            this.lastNearPlane = -999.0f;
            Config.glStageCount = this.minDriverAndConfig = this.getTextureStages();
            GLHelper.printDriver();
            this.hasOpenGL12 = GLContext.getCapabilities().OpenGL12;
            boolean bl2 = Config.glBlendingAffectsAlpha = GLContext.getCapabilities().GL_ARB_texture_env_combine && Config.glBlendingAffectsAlpha;
            if (Config.glBlendingAffectsAlpha) {
                Logger.log("GL_ARB_texture_env_combine supported and used!", 2);
            } else {
                Logger.log("GL_ARB_texture_env_combine not supported or disabled!", 2);
            }
            Config.glUseFBO = this.useFBO = GLContext.getCapabilities().GL_EXT_framebuffer_object && Config.glUseFBO;
            if (this.useFBO) {
                Logger.log("FBO supported and used!", 2);
            } else {
                Logger.log("FBO not supported or disabled!", 2);
            }
            if (Config.glUseVBO) {
                Config.glUseVBO = GLContext.getCapabilities().GL_ARB_vertex_buffer_object;
            }
            if (Config.glUseVBO) {
                Logger.log("VBO supported and used!", 2);
            } else {
                Logger.log("VBO not supported or disabled!", 2);
            }
            Logger.log("OpenGL renderer initialized (using " + this.minDriverAndConfig + " texture stages)", 2);
            GL11.glFinish();
            this.init = true;
        }
    }

    protected void reInit() {
        this.endState();
        if (this.depthBuffer && !GL11.glIsEnabled(2929)) {
            GL11.glEnable(2929);
        }
        if (this.enabledStages[0]) {
            ARBMultitexture.glActiveTextureARB(stageMap[0]);
            if (!GL11.glIsEnabled(3553)) {
                GL11.glEnable(3553);
                this.disableAllHigherStages();
            }
        }
    }

    protected void dispose() {
        if (!this.disposed) {
            Object object;
            this.disposed = true;
            this.init = false;
            this.lastFOV = -999.0f;
            this.lastFarPlane = -999.0f;
            this.lastNearPlane = -999.0f;
            this.lastTexture = 0;
            this.pixelBuffer = null;
            this.textureBuffer = null;
            this.blitBuffer = null;
            this.listener = null;
            try {
                if (this.useFBO && this.fbo != -1) {
                    object = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
                    if (this.fbo != -1) {
                        ((IntBuffer)object).put(this.fbo);
                        ((Buffer)object).rewind();
                        EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)object);
                    }
                    if (this.fboColorStorage != null) {
                        this.removeTexture(this.fboColorStorage);
                        this.fboColorStorage = null;
                    }
                    if (this.fboDepthStorage != null) {
                        this.removeTexture(this.fboDepthStorage);
                        this.fboDepthStorage = null;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = TextureManager.getInstance().textures;
            for (int i = 0; i < ((Texture[])object).length; ++i) {
                try {
                    this.removeTexture(object[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.texMan.flushOpenGLIDs(this.myID);
        }
    }

    protected final void initTextureStage(int n, int n2) {
        this.switchTextureMode(n, n2);
        this.stageInitialized[n] = true;
    }

    protected final void disableUnusedStages() {
        if (!this.singleTexturing) {
            this.endState();
            for (int i = 1; i < this.maxStages; ++i) {
                if (!this.enabledStages[i]) continue;
                ARBMultitexture.glActiveTextureARB(stageMap[i]);
                GL11.glDisable(3553);
                this.enabledStages[i] = false;
            }
            this.enableStage(0);
            this.singleTexturing = true;
        }
    }

    protected final void enableStage(int n) {
        this.endState();
        ARBMultitexture.glActiveTextureARB(stageMap[n]);
        if (!this.enabledStages[n]) {
            GL11.glEnable(3553);
            this.enabledStages[n] = true;
            if (n > 0) {
                this.singleTexturing = false;
            }
        }
    }

    protected final void disableStage(int n) {
        if (this.enabledStages[n] && !this.singleTexturing) {
            this.endState();
            ARBMultitexture.glActiveTextureARB(stageMap[n]);
            GL11.glDisable(3553);
            this.enabledStages[n] = false;
            this.singleTexturing = true;
            for (int i = 1; i < this.maxStages; ++i) {
                if (!this.enabledStages[i]) continue;
                this.singleTexturing = false;
                break;
            }
        }
    }

    protected void bindAndProject(int n, Texture texture, Camera camera) {
        boolean bl;
        int n2 = texture.getOpenGLID(this.myID);
        boolean bl2 = bl = texture.projector != null;
        if (n2 != this.lastTextures[n] || bl != this.projective[n] || texture.isShadowMap && !this.alphaTest) {
            this.bindTexture(n, n2, bl);
            this.processProjection(n, texture, camera);
        } else if (n != 0) {
            this.enableStage(n);
        }
    }

    protected final void enableCompiledPipeline() {
        CompiledInstance.lastVertexBuffer = null;
        CompiledInstance.lastVertexBufferId = -1;
        GL11.glEnable(2977);
        GL11.glEnable(2896);
        GL11.glEnable(2884);
        this.clearHook(null);
    }

    protected final void disableCompiledPipeline() {
        CompiledInstance.lastVertexBuffer = null;
        CompiledInstance.lastVertexBufferId = -1;
        GL11.glDisable(2884);
        GL11.glDisable(2896);
        GL11.glDisable(2977);
        if (CompiledInstance.texGenEnabled) {
            GL11.glDisable(3168);
            GL11.glDisable(3169);
            CompiledInstance.texGenEnabled = false;
        }
        this.clearHook(null);
    }

    protected final void bindTexture(int n, int n2, boolean bl) {
        this.enableStage(n);
        GL11.glBindTexture(3553, n2);
        ++this.stateChanges;
        this.lastTextures[n] = n2;
        if (!bl && this.projective[n]) {
            this.disableProjection();
            this.projective[n] = false;
        }
    }

    protected final void bindTexture(int n, int n2) {
        this.bindTexture(n, n2, false);
    }

    protected final void switchTextureMode(int n, int n2) {
        if (this.lastMode[n] != n2) {
            this.endState();
            this.enableStage(n);
            if (Config.glBlendingAffectsAlpha && n2 != 3042) {
                GL11.glTexEnvi(8960, 8704, 34160);
                GL11.glTexEnvi(8960, 34161, n2);
                GL11.glTexEnvi(8960, 34162, n2);
            } else {
                GL11.glTexEnvi(8960, 8704, n2);
            }
            this.lastMode[n] = n2;
        }
    }

    protected final void beginState(int n) {
        if (this.lastState != n) {
            if (this.lastState != -999989) {
                GL11.glEnd();
            }
            GL11.glBegin(n);
            this.lastState = n;
        } else {
            ++this.changeCnt;
        }
    }

    protected final void endState() {
        if (this.lastState != -999989) {
            GL11.glEnd();
        }
        this.changeCnt = 0;
        this.lastState = -999989;
    }

    protected final boolean isDisposed() {
        return this.disposed;
    }

    protected final void removeTexture(Texture texture) {
        if (texture != null && texture.getOpenGLID(this.myID) != 0) {
            IntBuffer intBuffer = this.getSmallBuffer();
            intBuffer.put(texture.getOpenGLID(this.myID));
            ((Buffer)intBuffer).flip();
            GL11.glDeleteTextures(intBuffer);
        }
    }

    protected final void addClippingPlane(int n, float[] fArray) {
        this.endState();
        if (this.clippingBuffer == null) {
            this.clippingBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        }
        ((Buffer)this.clippingBuffer).rewind();
        this.clippingBuffer.put(0, fArray[0]);
        this.clippingBuffer.put(1, fArray[1]);
        this.clippingBuffer.put(2, fArray[2]);
        this.clippingBuffer.put(3, fArray[3]);
        GL11.glClipPlane(12288 + n, this.clippingBuffer);
        GL11.glEnable(12288 + n);
    }

    protected final void removeClippingPlane(int n) {
        GL11.glDisable(12288 + n);
    }

    protected final void initializeVertexArrays() {
        if (this.init) {
            this.colors = ByteBuffer.allocateDirect(16000).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.vertices = ByteBuffer.allocateDirect(12000).order(ByteOrder.nativeOrder()).asFloatBuffer();
            GL11.glColorPointer(4, 16, this.colors);
            GL11.glVertexPointer(3, 12, this.vertices);
            GL11.glEnableClientState(32886);
            GL11.glEnableClientState(32884);
            this.createVertexArrays(this.minDriverAndConfig);
            this.vertexArraysInitialized = true;
        }
    }

    protected final void renableVertexArrays() {
        if (this.colors != null) {
            GL11.glColorPointer(4, 16, this.colors);
            GL11.glVertexPointer(3, 12, this.vertices);
            GL11.glEnableClientState(32886);
            GL11.glEnableClientState(32884);
            GL11.glDisableClientState(32885);
            for (int i = 0; i < this.minDriverAndConfig; ++i) {
                ARBMultitexture.glClientActiveTextureARB(stageMap[i]);
                GL11.glEnableClientState(32888);
                GL11.glTexCoordPointer(2, 8, this.multiTextures[i]);
            }
        }
    }

    protected final void enableVertexArrays(int n, int n2) {
        if (n > this.minDriverAndConfig) {
            return;
        }
        if (n == n2) {
            return;
        }
        if (n < n2) {
            for (int i = n; i < n2; ++i) {
                if (!this.buffersEnabled[i]) continue;
                ARBMultitexture.glClientActiveTextureARB(stageMap[i]);
                GL11.glDisableClientState(32888);
                this.buffersEnabled[i] = false;
            }
            return;
        }
        if (n2 < n) {
            for (int i = n2; i < n; ++i) {
                if (this.buffersEnabled[i]) continue;
                ARBMultitexture.glClientActiveTextureARB(stageMap[i]);
                GL11.glEnableClientState(32888);
                this.buffersEnabled[i] = true;
            }
            return;
        }
    }

    protected final void renderVertexArray(int n) {
        if (n != 0) {
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < this.projective.length; ++n2) {
                if (!this.projective[n2] || !this.buffersEnabled[n2]) continue;
                ARBMultitexture.glClientActiveTextureARB(stageMap[n2]);
                GL11.glDisableClientState(32888);
                bl = true;
            }
            GL11.glDrawArrays(4, 0, n);
            if (bl) {
                for (n2 = 0; n2 < this.projective.length; ++n2) {
                    if (!this.projective[n2] || !this.buffersEnabled[n2]) continue;
                    ARBMultitexture.glClientActiveTextureARB(stageMap[n2]);
                    GL11.glEnableClientState(32888);
                }
            }
        }
    }

    protected final IntBuffer getSmallBuffer() {
        if (this.smallBuffer == null || !Config.glUseCaches) {
            this.smallBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        } else {
            ((Buffer)this.smallBuffer).clear();
        }
        return this.smallBuffer;
    }

    protected final void disableFogging() {
        GL11.glDisable(2912);
        this.currentFoggingState = false;
        this.currentFogColor = -1;
        this.currentFogDistance = -1.0f;
    }

    protected void setFrustum(World world, FrameBuffer frameBuffer) {
        Camera camera = world.getCamera();
        float f = camera.getFOV();
        float f2 = 0.0f;
        if (f != this.lastFOV || Config.farPlane != this.lastFarPlane || !Config.glIgnoreNearPlane && Config.nearPlane != this.lastNearPlane || Config.autoMaintainAspectRatio != this.lastFOVMode) {
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            float f3 = frameBuffer.getOutputHeight();
            float f4 = frameBuffer.getOutputWidth();
            if (frameBuffer.renderTarget != null) {
                if (frameBuffer.virtualHeight > 0 && frameBuffer.virtualWidth > 0) {
                    f3 = frameBuffer.virtualHeight;
                    f4 = frameBuffer.virtualWidth;
                } else {
                    f3 = frameBuffer.renderTarget.height;
                    f4 = frameBuffer.renderTarget.width;
                }
            }
            f2 = Config.autoMaintainAspectRatio ? f * (f3 / f4) : f;
            if (camera.getYFOV() != -1.0f) {
                f2 = camera.getYFOV();
            }
            float f5 = Config.farPlane;
            float f6 = 1.0f;
            if (!Config.glIgnoreNearPlane) {
                f6 = Config.nearPlane;
            }
            float f7 = f2 * 0.5f;
            float f8 = -f2 * 0.5f;
            float f9 = -f * 0.5f;
            float f10 = f * 0.5f;
            GL11.glFrustum(f9, f10, f8, f7, f6, f5);
            this.lastFOV = f + 100.0f * f2;
            this.lastFarPlane = Config.farPlane;
            this.lastNearPlane = Config.nearPlane;
            this.lastFOVMode = Config.autoMaintainAspectRatio;
        }
    }

    private void resetShadows() {
        this.disableShadowMap();
    }

    protected final void setRGBScaling(int n) {
        this.resetShadows();
        try {
            if (n != this.currentRGBScaling) {
                if (this.supportsRGBScaling == 0) {
                    if (this.supportsExtension("GL_ARB_texture_env_combine")) {
                        this.supportsRGBScaling = 1;
                    } else {
                        this.supportsRGBScaling = -1;
                        Logger.log("This hardware or driver doesn't support the GL_ARB_texture_env_combine extension!", 1);
                    }
                }
                if (this.supportsRGBScaling == 1) {
                    this.enableStage(0);
                    GL11.glTexEnvi(8960, 8704, 34160);
                    GL11.glTexEnvi(8960, 34161, 8448);
                    GL11.glTexEnvi(8960, 34163, n);
                    this.currentRGBScaling = n;
                }
            }
        }
        catch (Exception exception) {
            Logger.log("Couldn't initialize the GL_ARB_texture_env_combine extension!", 0);
        }
    }

    protected final void enableFogging(float f, float f2, float f3, float f4, float f5) {
        if (f3 < 0.0f) {
            f3 = 0.0f;
        } else if (f3 > 255.0f) {
            f3 = 255.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        } else if (f4 > 255.0f) {
            f4 = 255.0f;
        }
        if (f5 < 0.0f) {
            f5 = 0.0f;
        } else if (f5 > 255.0f) {
            f5 = 255.0f;
        }
        int n = (int)f3 << 16 | (int)f4 << 8 | (int)f5;
        if (f2 != this.currentFogDistance || n != this.currentFogColor) {
            if (this.currentFoggingState) {
                this.disableFogging();
            }
            this.currentFoggingState = true;
            FloatBuffer floatBuffer = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
            floatBuffer.put(f3 / 255.0f);
            floatBuffer.put(f4 / 255.0f);
            floatBuffer.put(f5 / 255.0f);
            floatBuffer.put(1.0f);
            ((Buffer)floatBuffer).flip();
            GL11.glEnable(2912);
            GL11.glFogf(2915, f);
            GL11.glFogf(2916, f2);
            GL11.glFogi(2917, 9729);
            GL11.glFog(2918, floatBuffer);
            GL11.glFogf(2914, 1.0f);
            this.currentFogColor = n;
            this.currentFogDistance = f2;
        }
    }

    protected final void convertTexture(Texture texture) {
        int n;
        int n2;
        int n3 = texture.getHeight();
        int n4 = texture.getWidth();
        int n5 = n3 * n4;
        int[] nArray = texture.texels;
        ByteBuffer byteBuffer = null;
        int n6 = n5 << 2;
        if (nArray != null) {
            if (Config.glUseCaches && this.textureBuffer != null && n6 == this.textureBufferSize) {
                byteBuffer = this.textureBuffer;
            }
            if (byteBuffer == null) {
                if (Config.glVerbose) {
                    Logger.log("Allocating " + n6 + " bytes of direct memory for texture: " + texture, 2);
                }
                try {
                    byteBuffer = ByteBuffer.allocateDirect(n6);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Logger.log("Unable to allocate " + n6 + " bytes of direct memory", 0);
                    return;
                }
                if (n5 <= 0x100000) {
                    this.textureBuffer = byteBuffer;
                    this.textureBufferSize = n6;
                    if (Config.glVerbose) {
                        Logger.log("Caching " + n6 + " bytes of direct memory!", 2);
                    }
                }
            }
        }
        int[] nArray2 = texture.alpha;
        if (nArray != null) {
            for (int i = 0; i < n5; ++i) {
                int n7 = i << 2;
                n2 = nArray[i];
                n = n2 & 0xFF00 | (n2 & 0xFF) << 16 | n2 >> 16;
                if (nArray2 == null) {
                    if ((n2 & 0xF0F0F0) != 0) {
                        n |= 0xFF000000;
                    }
                } else {
                    n |= nArray2[i];
                }
                byteBuffer.putInt(n7, n);
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        IntBuffer intBuffer = this.getSmallBuffer();
        GL11.glGenTextures(intBuffer);
        n2 = intBuffer.get(0);
        if (n2 == 0) {
            Logger.log("Failed to upload texture!", 0);
        }
        n = this.lastTextures[0];
        this.bindTexture(0, n2);
        int n8 = 9729;
        if (Config.glMipmap) {
            n8 = 9985;
        }
        if (Config.glTrilinear) {
            n8 = 9987;
        }
        if (!texture.mipmap) {
            n8 = 9729;
        }
        int n9 = 6408;
        if (Config.glTextureDepth == 32) {
            n9 = 32856;
        }
        if (Config.glTextureDepth == 16) {
            n9 = 32854;
        }
        if (n8 == 9729 || texture.isShadowMap) {
            if (texture.isShadowMap) {
                if (this.supportsShadowMapping == 0) {
                    if (this.supportsExtension("GL_ARB_shadow") && this.supportsExtension("GL_ARB_depth_texture")) {
                        this.supportsShadowMapping = 1;
                        this.checkLimitations();
                    } else {
                        this.supportsShadowMapping = -1;
                        Logger.log("This hardware or driver doesn't support ARB shadow mapping extensions!", 1);
                    }
                }
                if (this.supportsShadowMapping == 1) {
                    GL11.glTexImage2D(3553, 0, 6402, n4, n3, 0, 6402, 5121, (ByteBuffer)null);
                    GL11.glTexParameteri(3553, 34892, 34894);
                    GL11.glTexParameteri(3553, 34893, 515);
                    GL11.glTexParameteri(3553, 34891, 32841);
                    ((Buffer)this.floatBuffer16).rewind();
                    this.floatBuffer16.put(1.0f);
                    this.floatBuffer16.put(1.0f);
                    this.floatBuffer16.put(1.0f);
                    this.floatBuffer16.put(1.0f);
                    ((Buffer)this.floatBuffer16).flip();
                    GL11.glTexParameter(3553, 4100, this.floatBuffer16);
                }
            } else {
                GL11.glTexImage2D(3553, 0, n9, n4, n3, 0, 6408, 5121, byteBuffer2);
            }
        } else {
            GLU.gluBuild2DMipmaps(3553, n9, n4, n3, 6408, 5121, byteBuffer2);
        }
        int n10 = 10497;
        if (!texture.repeat) {
            n10 = this.hasOpenGL12 ? 33071 : 10496;
        }
        if (texture.isShadowMap) {
            n8 = 9728;
            n10 = 10496;
        }
        GL11.glTexParameteri(3553, 10241, n8);
        if (texture.bilinear) {
            GL11.glTexParameteri(3553, 10240, 9729);
        } else {
            GL11.glTexParameteri(3553, 10240, 9728);
        }
        GL11.glTexParameteri(3553, 10242, n10);
        GL11.glTexParameteri(3553, 10243, n10);
        texture.setOpenGLID(this.myID, n2);
        if (n != 0) {
            this.bindTexture(0, n);
        }
    }

    protected void checkLimitations() {
        if (!Config.glUseFBO) {
            String string = GLHelper.getHardware().toLowerCase();
            String[] stringArray = new String[]{"x800", "x700", "x600", "x500", "x300", "x850", "x1800", "9700", "9800", "9650", "9600", "9500", "9200", "9100", "9000", "8500", "8000", "7500"};
            String[] stringArray2 = new String[]{"x1900", "x1600", "x1950", "x1650", "hd 2900", "hd 2600", "hd 2400", "x1300"};
            if (string.indexOf("ati") != -1) {
                int n;
                for (n = 0; n < stringArray.length; ++n) {
                    if (string.indexOf(stringArray[n]) == -1) continue;
                    Logger.log("This graphics hardware may have performance problems with shadow mapping/depth textures without using FBOs!", 1);
                    break;
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    if (string.indexOf(stringArray2[n]) == -1) continue;
                    Logger.log("This graphics hardware may have problems with shadow mapping in combination with anti-aliasing without using FBOs!", 1);
                    break;
                }
            }
        }
    }

    protected final boolean supportsExtension(String string) {
        String string2 = GL11.glGetString(7939);
        return string2.toLowerCase().indexOf(string.toLowerCase()) != -1;
    }

    protected final int getTextureSize() {
        IntBuffer intBuffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL11.glGetInteger(3379, intBuffer);
        return intBuffer.get(0);
    }

    protected final void enableDepthBuffer() {
        if (!this.depthBuffer) {
            GL11.glEnable(2929);
            this.depthBuffer = true;
        }
    }

    protected final void disableDepthBuffer() {
        if (this.depthBuffer) {
            GL11.glDisable(2929);
            this.depthBuffer = false;
        }
    }

    protected void enableBlitting(Object[] objectArray) {
        int n;
        if (!this.blitMode) {
            GL11.glFlush();
            this.curPos = 0;
            this.colPos = 0;
            this.texPos = 0;
            this.vertPos = 0;
        }
        boolean bl = (Boolean)objectArray[8];
        boolean bl2 = objectArray.length > 11 && (Boolean)objectArray[14] != false;
        this.endState();
        this.resetShadows();
        if (!(!bl || this.blitMode && this.blitTrans)) {
            if (this.blitMode) {
                this.executeBufferedBlits();
            }
            n = 0;
            if (bl2) {
                n = 1;
            }
            this.blitAdditive = bl2;
            this.setBlendingMode(n);
            this.blitTrans = true;
        }
        if (!this.blitMode) {
            this.blitScaling = this.currentRGBScaling;
            if (this.myWorld != null) {
                this.setRGBScaling(1);
            }
            this.disableDepthBuffer();
            this.blitMode = true;
        } else {
            if (this.blitTrans && !bl) {
                this.executeBufferedBlits();
                GL11.glDisable(3042);
                this.blitTrans = false;
            }
            if (this.blitTrans && bl && bl2 != this.blitAdditive) {
                this.executeBufferedBlits();
                this.blitAdditive = bl2;
                n = 0;
                if (bl2) {
                    n = 1;
                }
                this.setBlendingMode(n);
            }
        }
    }

    protected void executeBufferedBlits() {
        if (Config.glVertexArrays && Config.glBufferedBlits) {
            this.renderVertexArray(this.curPos);
            this.curPos = 0;
            this.colPos = 0;
            this.texPos = 0;
            this.vertPos = 0;
        }
    }

    protected void disableBlitting() {
        if (this.blitMode) {
            this.executeBufferedBlits();
            if (this.myWorld != null && this.blitScaling != this.currentRGBScaling) {
                this.setRGBScaling(this.blitScaling);
            }
            if (this.blitTrans) {
                GL11.glDisable(3042);
                this.blitTrans = false;
            }
            this.enableDepthBuffer();
            this.blitMode = false;
        }
    }

    protected void setLightsAndFog(World world) {
        this.setRGBScaling(world.lights.rgbScale);
        boolean bl = false;
        if (world.fogModeChanged == 1) {
            this.enableFogging(world.fogStart, world.fogDistance, world.fogColorR, world.fogColorG, world.fogColorB);
            world.fogModeChanged = 0;
            this.foggingOn = true;
            bl = true;
        } else if (world.fogModeChanged == 2) {
            this.disableFogging();
            world.fogModeChanged = 0;
            this.foggingOn = false;
            bl = true;
        }
        if (!bl) {
            if (!world.useFogging && this.foggingOn) {
                this.disableFogging();
                this.foggingOn = false;
            } else if (world.useFogging && world.perPixelFogging && !this.foggingOn) {
                this.enableFogging(world.fogStart, world.fogDistance, world.fogColorR, world.fogColorG, world.fogColorB);
                this.foggingOn = true;
            }
        }
    }

    protected void grabScreen(Object[] objectArray) {
        int n;
        FrameBuffer frameBuffer = (FrameBuffer)objectArray[0];
        int[] nArray = (int[])objectArray[1];
        int n2 = frameBuffer.getOutputWidth();
        int n3 = frameBuffer.getOutputHeight();
        int n4 = n2 * n3;
        int n5 = n4 << 2;
        IntBuffer intBuffer = null;
        if (this.pixelBuffer != null && n5 == this.pixelBufferSize) {
            intBuffer = this.pixelBuffer;
        }
        if (!Config.glUseCaches) {
            intBuffer = null;
        }
        if (intBuffer == null) {
            this.pixelBuffer = intBuffer = ByteBuffer.allocateDirect(n5).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
            this.pixelBufferSize = n5;
        }
        GL11.glReadPixels(0, 0, n2, n3, 32993, 5121, intBuffer);
        for (n = 0; n < n4; ++n) {
            nArray[n] = intBuffer.get(n);
        }
        for (n = 0; n < n3 >> 1; ++n) {
            int n6 = n * n2;
            int n7 = (n3 - 1 - n) * n2;
            for (int i = 0; i < n2; ++i) {
                int n8 = i + n6;
                int n9 = n7 + i;
                int n10 = nArray[n8];
                nArray[n8] = nArray[n9] & 0xFFFFFF;
                nArray[n9] = n10 & 0xFFFFFF;
            }
        }
    }

    protected void prepareForBlitting(Object[] objectArray) {
        int n = 0;
        int n2 = (Integer)objectArray[9];
        int n3 = (Integer)objectArray[10];
        if (this.blitBuffer != null) {
            n = this.blitBuffer.getOpenGLID(this.myID);
            if (this.blitBufferWidth == n2 && this.blitBufferHeight == n3) {
                if (!Config.glUseIgnorantBlits) {
                    this.blitBuffer.refill((int[])objectArray[0], n2, n3);
                    this.blitBuffer.setMarker(this.myID, Texture.MARKER_DELETE_AND_UPLOAD);
                    this.blitBuffer.setOpenGLID(this.myID, n);
                }
            } else {
                this.removeTexture(this.blitBuffer);
                this.blitBuffer = new Texture((int[])objectArray[0], n2, n3, true);
                this.blitBuffer.setMarker(this.myID, Texture.MARKER_DELETE_AND_UPLOAD);
                this.blitBuffer.setOpenGLID(this.myID, n);
            }
        } else {
            this.blitBuffer = new Texture((int[])objectArray[0], n2, n3, true);
        }
        this.blitBufferWidth = n2;
        this.blitBufferHeight = n3;
    }

    protected void setBufferViewport(Object[] objectArray) {
        this.xViewStart = (Integer)objectArray[0];
        this.yViewStart = (Integer)objectArray[1];
        this.xViewEnd = (Integer)objectArray[2];
        this.yViewEnd = (Integer)objectArray[3];
        if (this.renderTarget == null) {
            GL11.glViewport(this.xViewStart, this.yViewStart, this.xViewEnd, this.yViewEnd);
        }
    }

    protected void blitVA(Object[] objectArray, float f, float f2) {
        if (this.init) {
            if (!this.vertexArraysInitialized) {
                this.initializeVertexArrays();
            }
            FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
            if (this.veryLastCoords != 1) {
                this.enableVertexArrays(1, this.veryLastCoords);
                this.lastCoords = 1;
                this.veryLastCoords = 1;
            }
            this.disableUnusedStages();
            this.switchTextureMode(0, modeMap[0]);
            float f3 = -1.0f;
            if (Config.glFixedBlitting) {
                f3 = -1.0000001f;
            }
            this.endState();
            Texture texture = (Texture)objectArray[0];
            float f4 = texture.getHeight();
            float f5 = texture.getWidth();
            int n = texture.getOpenGLID(this.myID);
            if (n == 0 || texture.getMarker(this.myID) == Texture.MARKER_DELETE_AND_UPLOAD) {
                texture.setMarker(this.myID, Texture.MARKER_NOTHING);
                if (n != 0) {
                    IntBuffer intBuffer = this.getSmallBuffer();
                    intBuffer.put(n);
                    ((Buffer)intBuffer).flip();
                    GL11.glDeleteTextures(intBuffer);
                }
                this.convertTexture(texture);
                n = texture.getOpenGLID(this.myID);
            }
            if (n != this.lastTextures[0]) {
                this.executeBufferedBlits();
                this.bindTexture(0, n);
            }
            int n2 = frameBuffer.getSamplingMode();
            float f6 = 1.0f;
            if (n2 != 0) {
                switch (n2) {
                    case 1: {
                        f6 = 2.0f;
                        break;
                    }
                    case 3: {
                        f6 = 1.5f;
                        break;
                    }
                    case 2: {
                        f6 = 0.5f;
                    }
                }
            }
            float f7 = ((Integer)objectArray[2]).intValue();
            float f8 = ((Integer)objectArray[3]).intValue();
            int n3 = (Integer)objectArray[6];
            int n4 = (Integer)objectArray[7];
            int n5 = n3;
            int n6 = n4;
            float f9 = 1.0f;
            float f10 = 1.0f;
            float f11 = 1.0f;
            float f12 = 1.0f;
            if (objectArray.length > 11) {
                n5 = (Integer)objectArray[11];
                n6 = (Integer)objectArray[12];
                f9 = Config.glTransparencyOffset + (float)((Integer)objectArray[13]).intValue() * Config.glTransparencyMul;
                if (f9 > 1.0f) {
                    f9 = 1.0f;
                }
                f10 = ((Integer)objectArray[15]).floatValue() / 255.0f;
                f11 = ((Integer)objectArray[16]).floatValue() / 255.0f;
                f12 = ((Integer)objectArray[17]).floatValue() / 255.0f;
            }
            int n7 = (Integer)objectArray[4];
            int n8 = (Integer)objectArray[5];
            float f13 = 1.0f / f5;
            float f14 = 1.0f / f4;
            float f15 = f13 * f7;
            float f16 = f14 * f8;
            float f17 = f13 * ((float)n3 + f7);
            float f18 = f14 * ((float)n4 + f8);
            if (this.myWorld != null) {
                if (f6 != 1.0f) {
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, n7, n8, 1.0f, f6, this.blitCoords1);
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, n7 + n5, n8 + n6, 1.0f, f6, this.blitCoords2);
                } else {
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, n7, n8, 1.0f, this.blitCoords1);
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, n7 + n5, n8 + n6, 1.0f, this.blitCoords2);
                }
                if (this.curPos >= 994) {
                    this.executeBufferedBlits();
                }
                for (int i = 0; i < 6; ++i) {
                    this.colors.put(this.colPos, f10);
                    this.colors.put(this.colPos + 1, f11);
                    this.colors.put(this.colPos + 2, f12);
                    this.colors.put(this.colPos + 3, f9);
                    this.colPos += 4;
                }
                this.vertices.put(this.vertPos, this.blitCoords1.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords2.y);
                this.vertices.put(this.vertPos + 2, f3);
                this.vertPos += 3;
                this.vertices.put(this.vertPos, this.blitCoords2.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords2.y);
                this.vertices.put(this.vertPos + 2, f3);
                this.vertPos += 3;
                this.vertices.put(this.vertPos, this.blitCoords1.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords1.y);
                this.vertices.put(this.vertPos + 2, f3);
                this.vertPos += 3;
                this.vertices.put(this.vertPos, this.blitCoords1.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords1.y);
                this.vertices.put(this.vertPos + 2, f3);
                this.vertPos += 3;
                this.vertices.put(this.vertPos, this.blitCoords2.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords1.y);
                this.vertices.put(this.vertPos + 2, f3);
                this.vertPos += 3;
                this.vertices.put(this.vertPos, this.blitCoords2.x);
                this.vertices.put(this.vertPos + 1, -this.blitCoords2.y);
                this.vertices.put(this.vertPos + 2, f3);
                this.vertPos += 3;
                this.textures.put(this.texPos, f15);
                this.textures.put(this.texPos + 1, f18);
                this.texPos += 2;
                this.textures.put(this.texPos, f17);
                this.textures.put(this.texPos + 1, f18);
                this.texPos += 2;
                this.textures.put(this.texPos, f15);
                this.textures.put(this.texPos + 1, f16);
                this.texPos += 2;
                this.textures.put(this.texPos, f15);
                this.textures.put(this.texPos + 1, f16);
                this.texPos += 2;
                this.textures.put(this.texPos, f17);
                this.textures.put(this.texPos + 1, f16);
                this.texPos += 2;
                this.textures.put(this.texPos, f17);
                this.textures.put(this.texPos + 1, f18);
                this.texPos += 2;
                this.curPos += 6;
            }
        }
    }

    protected void blit(Object[] objectArray, float f, float f2) {
        if (this.init) {
            if (Config.glVertexArrays && Config.glBufferedBlits) {
                this.blitVA(objectArray, f, f2);
                return;
            }
            FrameBuffer frameBuffer = (FrameBuffer)objectArray[1];
            this.disableUnusedStages();
            this.switchTextureMode(0, modeMap[0]);
            float f3 = 1.0f;
            if (Config.glFixedBlitting) {
                f3 = -1.0000001f;
            }
            if (!Config.glIgnoreNearPlane) {
                f3 = -Config.nearPlane;
                if (Config.glFixedBlitting) {
                    f3 = -Config.nearPlane - 6.0E-8f;
                }
            }
            this.endState();
            Texture texture = (Texture)objectArray[0];
            if (texture == null) {
                return;
            }
            float f4 = texture.getHeight();
            float f5 = texture.getWidth();
            int n = texture.getOpenGLID(this.myID);
            if (n == 0 || texture.getMarker(this.myID) == Texture.MARKER_DELETE_AND_UPLOAD) {
                texture.setMarker(this.myID, Texture.MARKER_NOTHING);
                if (n != 0) {
                    IntBuffer intBuffer = this.getSmallBuffer();
                    intBuffer.put(n);
                    ((Buffer)intBuffer).flip();
                    GL11.glDeleteTextures(intBuffer);
                }
                this.convertTexture(texture);
                n = texture.getOpenGLID(this.myID);
            }
            if (n != this.lastTextures[0]) {
                this.bindTexture(0, n);
            }
            int n2 = frameBuffer.getSamplingMode();
            float f6 = 1.0f;
            if (n2 != 0) {
                switch (n2) {
                    case 1: {
                        f6 = 2.0f;
                        break;
                    }
                    case 3: {
                        f6 = 1.5f;
                        break;
                    }
                    case 2: {
                        f6 = 0.5f;
                    }
                }
            }
            float f7 = ((Integer)objectArray[2]).intValue();
            float f8 = ((Integer)objectArray[3]).intValue();
            int n3 = (Integer)objectArray[6];
            int n4 = (Integer)objectArray[7];
            int n5 = n3;
            int n6 = n4;
            float f9 = 1.0f;
            float f10 = 1.0f;
            float f11 = 1.0f;
            float f12 = 1.0f;
            if (objectArray.length > 11) {
                n5 = (Integer)objectArray[11];
                n6 = (Integer)objectArray[12];
                f9 = Config.glTransparencyOffset + (float)((Integer)objectArray[13]).intValue() * Config.glTransparencyMul;
                if (f9 > 1.0f) {
                    f9 = 1.0f;
                }
                f10 = ((Integer)objectArray[15]).floatValue() / 255.0f;
                f11 = ((Integer)objectArray[16]).floatValue() / 255.0f;
                f12 = ((Integer)objectArray[17]).floatValue() / 255.0f;
            }
            int n7 = (Integer)objectArray[4];
            int n8 = (Integer)objectArray[5];
            float f13 = 1.0f / f5;
            float f14 = 1.0f / f4;
            float f15 = f13 * f7;
            float f16 = f14 * f8;
            float f17 = f13 * ((float)n3 + f7);
            float f18 = f14 * ((float)n4 + f8);
            if (this.myWorld != null) {
                if (f6 != 1.0f) {
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, n7, n8, 1.0f, f6, this.blitCoords1);
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, n7 + n5, n8 + n6, 1.0f, f6, this.blitCoords2);
                } else {
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, n7, n8, 1.0f, this.blitCoords1);
                    Interact2D.reproject2D3DBlit(f, f2, frameBuffer, n7 + n5, n8 + n6, 1.0f, this.blitCoords2);
                }
                GL11.glBegin(5);
                GL11.glColor4f(f10, f11, f12, f9);
                GL11.glTexCoord2f(f15, f18);
                GL11.glVertex3f(this.blitCoords1.x, -this.blitCoords2.y, f3);
                GL11.glTexCoord2f(f17, f18);
                GL11.glVertex3f(this.blitCoords2.x, -this.blitCoords2.y, f3);
                GL11.glTexCoord2f(f15, f16);
                GL11.glVertex3f(this.blitCoords1.x, -this.blitCoords1.y, f3);
                GL11.glTexCoord2f(f17, f16);
                GL11.glVertex3f(this.blitCoords2.x, -this.blitCoords1.y, f3);
                GL11.glEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addForUnload(Texture texture) {
        GLBase gLBase = this;
        synchronized (gLBase) {
            this.toUnload.add(texture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unloadTextures() {
        if (this.toUnload.size() > 0) {
            GLBase gLBase = this;
            synchronized (gLBase) {
                this.endState();
                Iterator iterator = this.toUnload.iterator();
                while (iterator.hasNext()) {
                    Texture texture = (Texture)iterator.next();
                    if (texture.getOpenGLID(this.myID) == 0) continue;
                    this.removeTexture(texture);
                    texture.clearIDs(this.myID);
                }
                this.toUnload.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upload(Texture texture) {
        GLBase gLBase = this;
        synchronized (gLBase) {
            this.endState();
            if (texture.getOpenGLID(this.myID) == 0 && texture != this.renderTarget) {
                texture.setMarker(this.myID, Texture.MARKER_NOTHING);
                this.convertTexture(texture);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListsAndBuffers() {
        int n;
        GLBase gLBase;
        if (this.toDispose != null && this.toDispose.size() > 0) {
            gLBase = this;
            synchronized (gLBase) {
                GL11.glFlush();
                GL11.glFinish();
                for (int i = 0; i < this.toDispose.size(); ++i) {
                    try {
                        n = (Integer)this.toDispose.get(i);
                        GL11.glDeleteLists(n, 1);
                        Util.checkGLError();
                        Logger.log("Display list " + n + " deleted!", 2);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.log("Failed to delete display list: " + this.toDispose.get(i), 1);
                    }
                }
                GL11.glFlush();
                GL11.glFinish();
                this.toDispose.clear();
            }
        }
        if (this.toDisposeVBO != null && this.toDisposeVBO.size() > 0) {
            gLBase = this;
            synchronized (gLBase) {
                GL11.glFlush();
                GL11.glFinish();
                IntBuffer intBuffer = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
                for (n = 0; n < this.toDisposeVBO.size(); ++n) {
                    try {
                        int n2 = (Integer)this.toDisposeVBO.get(n);
                        if (n2 == 0) continue;
                        ((Buffer)intBuffer).rewind();
                        intBuffer.put(n2);
                        ((Buffer)intBuffer).rewind();
                        GL15.glDeleteBuffers(intBuffer);
                        Util.checkGLError();
                        Logger.log("VBO " + n2 + " deleted!", 2);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.log("Failed to delete VBO: " + this.toDisposeVBO.get(n), 1);
                    }
                }
                GL11.glFlush();
                GL11.glFinish();
                this.toDisposeVBO.clear();
            }
        }
    }

    private final void createVertexArrays(int n) {
        GL11.glEnableClientState(32888);
        for (int i = 0; i < n; ++i) {
            this.multiTextures[i] = ByteBuffer.allocateDirect(8000).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ARBMultitexture.glClientActiveTextureARB(stageMap[i]);
            GL11.glTexCoordPointer(2, 8, this.multiTextures[i]);
            if (i != 0) continue;
            this.textures = this.multiTextures[0];
            this.buffersEnabled[0] = true;
        }
    }

    private final int getTextureStages() {
        IntBuffer intBuffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL11.glGetInteger(34018, intBuffer);
        int n = intBuffer.get(0);
        if (Config.glOverrideStageCount > 0) {
            n = Config.glOverrideStageCount;
        }
        if (n > 4) {
            n = 4;
        }
        return n;
    }

    private final void initTextureStage(int n) {
        this.initTextureStage(n, modeMap[0]);
    }

    private void resetViewport(FrameBuffer frameBuffer) {
        if (this.xViewStart == 0 && this.xViewEnd == 0) {
            this.xViewStart = 0;
            this.xViewEnd = frameBuffer.getOutputWidth();
            this.yViewStart = 0;
            this.yViewEnd = frameBuffer.getOutputHeight();
        }
        GL11.glViewport(this.xViewStart, this.yViewStart, this.xViewEnd, this.yViewEnd);
    }

    private void setViewport(FrameBuffer frameBuffer) {
        if (!Config.glUseFBO) {
            this.yTargetStart = frameBuffer.getOutputHeight() - this.renderTarget.getHeight();
            GL11.glViewport(0, this.yTargetStart, this.renderTarget.getWidth(), this.renderTarget.getHeight());
        } else {
            GL11.glViewport(0, 0, this.renderTarget.getWidth(), this.renderTarget.getHeight());
        }
    }

    private void enableScissor(FrameBuffer frameBuffer, Texture texture, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (!this.useFBO) {
            n6 = frameBuffer.getOutputHeight() - texture.getHeight();
        }
        int n7 = texture.getWidth();
        int n8 = texture.getHeight();
        if (n != -1) {
            this.scissorEnabled = true;
            n5 += n;
        }
        if (n2 != -1) {
            this.scissorEnabled = true;
            n6 += n2;
        }
        if (n3 != -1) {
            this.scissorEnabled = true;
            n7 -= n + n3;
        }
        if (n4 != -1) {
            this.scissorEnabled = true;
            n8 -= n2 + n4;
        }
        if (this.scissorEnabled) {
            GL11.glEnable(3089);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n7 < 0) {
                n7 = 0;
            }
            if (n6 < 0) {
                n6 = 0;
            }
            if (n8 < 0) {
                n8 = 0;
            }
            GL11.glScissor(n5, n6, n7, n8);
        }
    }

    private void disableScissor() {
        if (this.scissorEnabled) {
            GL11.glDisable(3089);
            this.scissorEnabled = false;
        }
    }

    protected void clearHook(IRenderHook iRenderHook) {
        if (this.lastHook != null && this.lastHook != iRenderHook) {
            this.lastHook.clear();
            this.lastHook = null;
        }
    }
}

