#version 330

invariant out vec4 gl_Position;

in vec4 A0;

uniform mat4 mp;
uniform float len, time, rad = 1.0;
uniform vec2 q, a;

out vec2 tc;

void main()
{
	tc = vec2(A0.z * 8.0 - time, A0.w * 2.0);

	vec3 v = A0.xyz * vec3(rad, rad, len) + vec3(a, 0.0);

	vec2 r = mix(vec2(0.0), q, -A0.z);

	mat3 rot = mat3(cos(r.y),				0.0,		-sin(r.y),
					sin(r.x) * sin(r.y),	cos(r.x),	cos(r.y) * sin(r.x),
					cos(r.x) * sin(r.y),	-sin(r.x),	cos(r.x) * cos(r.y));

	v = rot * v;

	gl_Position = mp * vec4(v, 1.0);	
}
