/*
 * Decompiled with CFR 0.152.
 */
package gui.time;

import gui.App;
import gui.menus.PopupTimeline;
import gui.time.ViewTimeline;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import timeline.TimeEntity;
import timeline.TimeEntityMasterAudio;
import timeline.TimeLine;

public class TimePanel
extends JPanel {
    TimePanel timePanel = this;
    private TimeEntity selected;
    private int drag = 0;
    public final double scalingFactor = 1.2;
    public static final double translateFactor = 10.0;
    private MouseEvent button;
    TimeLine timeLine = TimeLine.getInstance();
    JPanel panel = this;
    private double currentTime = 0.0;
    ViewTimeline parent;
    private Point2D oldPosition;
    public Graphics2D g2;
    public AffineTransform transformation = new AffineTransform();

    @Override
    public ViewTimeline getParent() {
        return this.parent;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(double currentTime) {
        this.currentTime = currentTime;
    }

    public TimePanel(ViewTimeline parent) {
        this.parent = parent;
        MyMouseListener ml = new MyMouseListener();
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double newScaling = TimePanel.this.transformation.getScaleX();
                newScaling = e.getWheelRotation() > 0 ? (newScaling *= (double)e.getWheelRotation() * 1.2) : (newScaling /= -((double)e.getWheelRotation()) * 1.2);
                if (newScaling < 0.2) {
                    newScaling = 0.2;
                }
                if (newScaling > 5.0) {
                    newScaling = 5.0;
                }
                Point oldPosition = e.getPoint();
                TimePanel.this.pointToUserSpace(oldPosition);
                TimePanel.this.transformation.setToScale(newScaling, 1.0);
                Point newPosition = e.getPoint();
                TimePanel.this.pointToUserSpace(newPosition);
                TimePanel.this.transformation.translate(((Point2D)newPosition).getX() - ((Point2D)oldPosition).getX(), ((Point2D)newPosition).getY() - ((Point2D)oldPosition).getY());
                TimePanel.this.repaint();
            }
        });
    }

    public void pointToUserSpace(Point2D deviceSpace) {
        try {
            this.transformation.inverseTransform(deviceSpace, deviceSpace);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int draggerwidth = (int)(14.0 / this.transformation.getScaleX());
        if (g != null) {
            int height;
            int width;
            int y;
            int x;
            this.g2 = (Graphics2D)g;
            this.g2.setBackground(new Color(55, 55, 55));
            this.g2.clearRect(0, 0, this.getWidth(), this.getHeight());
            this.g2.transform(this.transformation);
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Point2D.Float startPoint = new Point2D.Float(0.0f, 0.0f);
            Point2D.Float endPoint = new Point2D.Float(0.0f, 16.0f);
            Color back = new Color(77, 120, 159);
            GradientPaint gradientPaint = new GradientPaint(startPoint, back, endPoint, this.getBackground(), false);
            this.g2.setPaint(gradientPaint);
            this.g2.fillRect(0, 0, 65536, 16);
            int i = 0;
            while (i < 16) {
                back = i % 2 == 0 ? Color.darkGray : new Color(55, 66, 88);
                int x2 = 0;
                int y2 = (i + 1) * 18;
                int width2 = 65536;
                int height2 = 18;
                this.g2.setPaint(back);
                this.g2.fillRect(x2, y2, width2, height2);
                ++i;
            }
            Font font = new Font("Arial", 0, 9);
            this.g2.setFont(font);
            for (TimeEntity e : this.timeLine.getEntities()) {
                x = (int)e.getStartTime();
                y = (e.getLevel() + 1) * 18;
                width = (int)(e.getEndTime() - e.getStartTime());
                height = 16;
                startPoint = new Point2D.Float(x, y);
                endPoint = new Point2D.Float(x, y + 16);
                double a = (double)e.getName().hashCode() / 1280.0;
                back = new Color(128 + (int)(Math.sin(a) * 50.0), 128 + (int)(Math.cos(a) * 50.0), 128);
                gradientPaint = new GradientPaint(startPoint, back, endPoint, this.getBackground(), false);
                this.g2.setPaint(gradientPaint);
                this.g2.fillRect(x, y, width, height);
                this.g2.setColor(new Color(188, 188, 188));
                this.g2.drawRect(x, y, width, height);
                if (e.isLockEdit()) {
                    this.g2.setPaint(new Color(128, 0, 0, 128));
                    this.g2.fillRect(x, y, width, height);
                }
                if (e.isLockPosition()) {
                    this.g2.setPaint(new Color(0, 0, 0, 128));
                    this.g2.fillRect(x, y, width, height);
                }
                this.g2.setColor(Color.white);
                Shape clip = this.g2.getClip();
                this.g2.setClip(x, y, width, height);
                this.g2.drawString(e.getName(), x, y + 12);
                this.g2.setClip(clip);
                if (this.selected == null || !this.selected.equals(e)) continue;
                this.g2.setColor(new Color(33, 255, 25, 188));
                this.g2.drawRect(x - 1, y - 1, width + 2, height + 2);
                this.g2.setColor(Color.blue);
                this.g2.drawLine(x, y, x, 0);
                this.g2.drawLine(x + width, y, x + width, 0);
                this.g2.drawLine(x, 0, x - draggerwidth, 8);
                this.g2.drawLine(x - draggerwidth, 8, x, 16);
                this.g2.drawLine(x, 16, x, 0);
                this.g2.drawLine(x + width, 0, x + width + draggerwidth, 8);
                this.g2.drawLine(x + width + draggerwidth, 8, x + width, 16);
                this.g2.drawLine(x + width, 16, x + width, 0);
                this.g2.setColor(Color.white);
            }
            if (this.timeLine.getMasterAudio() != null) {
                TimeEntityMasterAudio audio = this.timeLine.getMasterAudio();
                x = (int)audio.getStartTime();
                y = (audio.getLevel() + 1) * 18;
                width = (int)TimeEntityMasterAudio.getAudio().getLength();
                height = 16;
                startPoint = new Point2D.Float(x, y);
                endPoint = new Point2D.Float(x + width, y);
                Color col1 = new Color(128, 128, 128, 128);
                Color col2 = new Color(128, 100, 44, 128);
                gradientPaint = new GradientPaint(startPoint, col1, endPoint, col2, false);
                this.g2.setPaint(gradientPaint);
                this.g2.fillRect(x - 1, y - 1, width + 2, height + 2);
                Shape clip = this.g2.getClip();
                this.g2.setColor(Color.white);
                this.g2.setClip(x, y, width, height);
                this.g2.drawString("Master Audio", x, y + 12);
                this.g2.setClip(clip);
            }
            this.g2.setColor(new Color(188, 188, 188, 44));
            if (this.parent.grid > 0.0f) {
                if (this.parent.grid == 1.0f) {
                    this.parent.grid = 2.0f;
                }
                Point2D.Double start = new Point2D.Double(-this.g2.getClipBounds().x, this.g2.getClipBounds().y);
                Point2D.Double dim = new Point2D.Double(this.g2.getClipBounds().width, this.g2.getClipBounds().height);
                this.pointToUserSpace(start);
                this.pointToUserSpace(dim);
                float i2 = 0.0f;
                while (i2 < 8192.0f) {
                    this.g2.drawLine((int)i2, 0, (int)i2, 288);
                    i2 += this.parent.grid;
                }
                if (this.parent.grid == 2.0f) {
                    this.parent.grid = 1.0f;
                }
            }
            this.g2.setColor(Color.white);
            this.g2.drawLine((int)this.currentTime, 0, (int)this.currentTime, 306);
        }
    }

    private int getDragAt(Point2D point) {
        int draggerwidth = (int)(14.0 / this.transformation.getScaleX());
        if (this.selected != null) {
            int height;
            int width;
            int y;
            int x = (int)this.selected.getStartTime() - draggerwidth;
            Rectangle s = new Rectangle(x, y = 0, width = draggerwidth, height = 16);
            if (s.contains(point)) {
                return 1;
            }
            x = (int)this.selected.getEndTime();
            s = new Rectangle(x, y = 0, width = draggerwidth, height = 16);
            if (s.contains(point)) {
                return 2;
            }
        }
        return 0;
    }

    public TimeEntity getElementAt(Point2D point) {
        for (TimeEntity e : this.timeLine.getEntities()) {
            int height;
            int width;
            int y;
            int x = (int)e.getStartTime();
            Rectangle s = new Rectangle(x, y = (e.getLevel() + 1) * 18, width = (int)(e.getEndTime() - e.getStartTime()), height = 16);
            if (!s.contains(point)) continue;
            return e;
        }
        return null;
    }

    private class MyMouseListener
    implements MouseListener,
    MouseMotionListener {
        Point2D startDrag;

        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TimePanel.this.button = e;
            Point p = e.getPoint();
            TimePanel.this.pointToUserSpace(p);
            if (e.getButton() == 1) {
                TimePanel.this.drag = TimePanel.this.getDragAt(p);
                this.startDrag = p;
                TimePanel.this.currentTime = ((Point2D)p).getX();
                if (TimePanel.this.getElementAt(p) == null && TimeLine.getInstance().getMasterAudio() != null) {
                    TimeLine.getInstance().getMasterAudio();
                    TimeEntityMasterAudio.getAudio().setTime(TimePanel.this.currentTime - TimeLine.getInstance().getMasterAudio().getStartTime());
                }
                TimeLine.getInstance().setCurrentTime(TimePanel.this.currentTime);
                App.frame.paintAll(App.frame.getGraphics());
                if (TimePanel.this.drag == 0) {
                    TimePanel.this.selected = TimePanel.this.getElementAt(p);
                    TimePanel.this.panel.updateUI();
                }
            }
            if (e.getButton() == 2) {
                TimePanel.this.oldPosition = e.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (TimePanel.this.selected != null && TimePanel.this.parent.gridenabled) {
                if (TimePanel.this.drag == 1) {
                    TimePanel.this.selected.setStartTime(TimePanel.this.selected.getStartTime() - (TimePanel.this.selected.getStartTime() + (double)(TimePanel.this.parent.grid / 2.0f)) % (double)TimePanel.this.parent.grid + (double)(TimePanel.this.parent.grid / 2.0f));
                }
                if (TimePanel.this.drag == 2) {
                    TimePanel.this.selected.setEndTime(TimePanel.this.selected.getEndTime() - (TimePanel.this.selected.getEndTime() + (double)(TimePanel.this.parent.grid / 2.0f)) % (double)TimePanel.this.parent.grid + (double)(TimePanel.this.parent.grid / 2.0f));
                }
            }
            Point p = e.getPoint();
            TimePanel.this.pointToUserSpace(p);
            TimePanel.this.drag = 0;
            if (e.isPopupTrigger()) {
                TimePanel.this.selected = TimePanel.this.getElementAt(p);
                Point2D pnt = (Point2D)e.getPoint().clone();
                TimePanel.this.pointToUserSpace(pnt);
                PopupTimeline popup = new PopupTimeline(TimePanel.this.timePanel, TimePanel.this.selected, pnt);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
            TimePanel.this.oldPosition = null;
            TimePanel.this.updateUI();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (TimePanel.this.button.getButton() == 1) {
                Point p = e.getPoint();
                TimePanel.this.pointToUserSpace(p);
                TimePanel.this.currentTime = ((Point2D)p).getX();
                TimeLine.getInstance().setCurrentTime(TimePanel.this.currentTime);
                App.frame.paintAll(App.frame.getGraphics());
                TimePanel.this.updateUI();
                if (TimePanel.this.selected != null) {
                    if (!TimePanel.this.selected.isLockPosition() && TimePanel.this.drag == 0) {
                        if (TimePanel.this.selected.getLevel() < (int)((Point2D)p).getY() / 18 - 1) {
                            TimePanel.this.selected.setLevel((int)((Point2D)p).getY() / 18 - 1);
                        }
                        if (TimePanel.this.selected.getLevel() > (int)((Point2D)p).getY() / 18 - 1 && TimePanel.this.selected.getLevel() > 0) {
                            TimePanel.this.selected.setLevel((int)((Point2D)p).getY() / 18 - 1);
                        }
                        if (TimePanel.this.selected.getLevel() > 15) {
                            TimePanel.this.selected.setLevel(15);
                        }
                        TimePanel.this.selected.setStartTime(TimePanel.this.selected.getStartTime() + ((Point2D)p).getX() - this.startDrag.getX());
                        TimePanel.this.selected.setEndTime(TimePanel.this.selected.getEndTime() + ((Point2D)p).getX() - this.startDrag.getX());
                    }
                    if (TimePanel.this.drag == 1) {
                        TimePanel.this.selected.setStartTime(TimePanel.this.selected.getStartTime() + ((Point2D)p).getX() - this.startDrag.getX());
                    }
                    if (TimePanel.this.drag == 2) {
                        TimePanel.this.selected.setEndTime(TimePanel.this.selected.getEndTime() + ((Point2D)p).getX() - this.startDrag.getX());
                    }
                    if (TimePanel.this.drag > 0 && TimePanel.this.selected.getStartTime() > TimePanel.this.selected.getEndTime()) {
                        double t = TimePanel.this.selected.getStartTime();
                        TimePanel.this.selected.setStartTime(TimePanel.this.selected.getEndTime());
                        TimePanel.this.selected.setEndTime(t);
                    }
                    TimePanel.this.panel.updateUI();
                    this.startDrag = p;
                }
            }
            if (TimePanel.this.button.getButton() == 2) {
                Point newPosition = null;
                newPosition = e.getPoint();
                if (TimePanel.this.oldPosition != null) {
                    Point2D.Double p = new Point2D.Double(((Point2D)newPosition).getX() - TimePanel.this.oldPosition.getX(), 0.0);
                    TimePanel.this.transformation.translate(((Point2D)p).getX(), 0.0);
                }
                TimePanel.this.oldPosition = newPosition;
                TimePanel.this.panel.updateUI();
            }
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
        }
    }
}

