/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.PanelShaderEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import model.MyShaderProgram;
import opengl.Renderer;

public class ViewShaders
extends JPanel {
    private JList listShaders;
    private DefaultListModel model = new DefaultListModel();
    ViewShaders dialog = this;
    private JButton btnAddShader = new JButton("Add");
    private JButton btnDelShader = new JButton("Del");
    private JButton btnRenameShader = new JButton("Rename");
    private BorderLayout layout1 = new BorderLayout();
    private PanelShaderEditor panEditor = new PanelShaderEditor(0);

    public ViewShaders() {
        this.setLayout(new BorderLayout());
        this.refreshList();
        this.listShaders = new JList(this.model);
        JPanel panel1 = new JPanel(this.layout1);
        JScrollPane spList = new JScrollPane(this.listShaders);
        panel1.add((Component)spList, "Center");
        Box boxAddRem = new Box(0);
        boxAddRem.add(this.btnAddShader);
        boxAddRem.add(this.btnDelShader);
        boxAddRem.add(this.btnRenameShader);
        panel1.add((Component)boxAddRem, "South");
        this.add((Component)this.panEditor, "Center");
        this.add((Component)panel1, "East");
        this.btnAddShader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String oldName = "New Shader";
                String name = (String)JOptionPane.showInputDialog(ViewShaders.this.dialog, "Enter a name for the new shader:\n", "Create a new shader", -1, null, null, oldName);
                if (!"".equals(name) && name != null) {
                    for (MyShaderProgram sp : Renderer.getInstance().getShaders()) {
                        if (!sp.enabled) {
                            sp.enabled = true;
                            sp.setName(name);
                            ViewShaders.this.refreshList();
                            break;
                        }
                        if (!sp.getName().equals(name)) continue;
                        JOptionPane.showMessageDialog(ViewShaders.this.dialog, "Shader with that name already exists!");
                        break;
                    }
                }
            }
        });
        this.btnDelShader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int answer = JOptionPane.showConfirmDialog(ViewShaders.this.dialog, "Do you want to delete selected shader?", "Delete shader", 0);
                if (answer == 0) {
                    MyShaderProgram selected = (MyShaderProgram)ViewShaders.this.listShaders.getSelectedValue();
                    for (MyShaderProgram sp : Renderer.getInstance().getShaders()) {
                        if (sp != selected) continue;
                        sp.enabled = false;
                        sp.setName("DELETED!");
                        ViewShaders.this.refreshList();
                        break;
                    }
                }
            }
        });
        this.listShaders.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (ViewShaders.this.listShaders.getModel().getSize() > 0) {
                    int shaderNum = Renderer.getInstance().getShaders().indexOf((MyShaderProgram)ViewShaders.this.listShaders.getSelectedValue());
                    ViewShaders.this.panEditor.SetShader((MyShaderProgram)ViewShaders.this.listShaders.getSelectedValue(), shaderNum);
                }
            }
        });
        this.btnRenameShader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String oldName;
                String name;
                MyShaderProgram selected = (MyShaderProgram)ViewShaders.this.listShaders.getSelectedValue();
                if (selected != null && (name = (String)JOptionPane.showInputDialog(ViewShaders.this.dialog, "Enter a name for the new shader:\n", "Rename", -1, null, null, oldName = selected.getName())) != null && !name.equals("")) {
                    boolean exists = false;
                    for (MyShaderProgram sp : Renderer.getInstance().getShaders()) {
                        if (!sp.getName().equals(name) || !sp.enabled) continue;
                        exists = true;
                    }
                    if (!exists) {
                        selected.setName(name);
                        ViewShaders.this.refreshList();
                    } else {
                        JOptionPane.showMessageDialog(ViewShaders.this.dialog, "Shader with that name already exists!");
                    }
                }
            }
        });
    }

    public void refreshList() {
        this.model.removeAllElements();
        int i = 0;
        System.out.println("refreshList");
        for (MyShaderProgram sp : Renderer.getInstance().getShaders()) {
            if (!sp.enabled) continue;
            this.model.add(i, sp);
            ++i;
        }
        if (this.model.size() == 0) {
            this.panEditor.setEnabled(false);
            this.panEditor.setVisible(false);
        } else {
            this.panEditor.setEnabled(true);
            this.panEditor.setVisible(true);
        }
        try {
            this.listShaders.setSelectedIndex(this.model.getSize() - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

