/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ScreenSelector;
import java.awt.Color;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import model.Project;
import opengl.Renderer;
import timeline.TimeLine;

public class Play {
    static String inProject = "project.project";
    static DisplayMode dm_old;
    public static JFrame frame;
    public static ScreenSelector selscreen;
    static GraphicsDevice dev;
    static JFrame frmSplash;

    static {
        frmSplash = new JFrame();
    }

    private static void showSplash() {
        frmSplash.setSize(800, 600);
        frmSplash.setLocationRelativeTo(null);
        frmSplash.setAlwaysOnTop(true);
        JButton btn = new JButton(new ImageIcon("Splash.jpg"));
        btn.setBackground(new Color(0, 0, 0));
        btn.setForeground(new Color(0, 0, 0));
        frmSplash.add(btn);
        frmSplash.setIconImage(Toolkit.getDefaultToolkit().getImage("icon.PNG"));
        frmSplash.setUndecorated(true);
        frmSplash.show(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        ArrayList screens = new ArrayList();
        dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        selscreen = new ScreenSelector();
        selscreen.setVisible(true);
    }

    public static void selectScreen(DisplayMode newmode) {
        if (newmode == null) {
            selscreen.dispose();
            System.exit(0);
        }
        int initWidth = 0;
        int initHeight = 0;
        dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (dev.isFullScreenSupported()) {
            if (newmode != null) {
                initWidth = newmode.getWidth();
                initHeight = newmode.getHeight();
            }
        } else {
            System.err.println("NOTE: full-screen mode not supported; running in window instead");
        }
        frame = new JFrame("demo");
        frame.setIconImage(Toolkit.getDefaultToolkit().getImage("icon.PNG"));
        if (newmode != null) {
            frame.setSize(initWidth, initHeight);
            frame.setLocationRelativeTo(null);
        }
        Play.start();
    }

    private static void start() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GLProfile profile = GLProfile.getDefault();
        GLCapabilities capabilities = new GLCapabilities(profile);
        GLCanvas glcanvas = new GLCanvas((GLCapabilitiesImmutable)capabilities);
        glcanvas.addGLEventListener((GLEventListener)Renderer.getInstance());
        glcanvas.setSize(300, 300);
        glcanvas.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent event) {
                double w = frame.getWidth();
                double x = event.getX();
                Renderer.getInstance().setSceneTime((float)(500.0 * x / w));
            }

            @Override
            public void mouseDragged(MouseEvent arg0) {
            }
        });
        glcanvas.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyCode() == 27) {
                    System.exit(0);
                }
            }
        });
        frame.getContentPane().add((Component)glcanvas);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
        ActionListener tp2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        ActionListener taskPerformer = new ActionListener(){
            int loaded = 0;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (this.loaded == 0) {
                    try {
                        Project.getInstance().tool = 0;
                        Play.showSplash();
                        frmSplash.paintAll(frmSplash.getGraphics());
                        Project.getInstance().LoadProject(inProject);
                        frmSplash.setVisible(false);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Renderer.getInstance().setGLobjectToDraw(TimeLine.getInstance());
                    this.loaded = 1;
                }
                frame.paintAll(frame.getGraphics());
            }
        };
        frame.paintAll(frame.getGraphics());
        new Timer(10, taskPerformer).start();
    }
}

