//pointlight.frag

#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

varying vec3 normal, lightDir, eyeVec;
uniform sampler2D tex0;

void main (void)
{
	vec4 final_color = (gl_FrontLightModelProduct.sceneColor * gl_FrontMaterial.ambient) + 
	(gl_LightSource[0].ambient * gl_FrontMaterial.ambient);
							
	vec3 N = normalize(normal);
	vec3 L = normalize(lightDir);
	
	float lambertTerm = dot(N,L);
	
	if(lambertTerm > 0.0)
	{
		final_color += gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse * lambertTerm;	
		
		// TODO: A 3ds szabvany szerinti specular ertek mast jelent mint a phong szerinti !!! 
		//vec3 E = normalize(eyeVec);
		//vec3 R = reflect(-L, N);
		//float specular = pow( max(dot(R, E), 0.0), gl_FrontMaterial.shininess );
		//final_color += gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;	
	}

	//gl_FragColor = final_color;
	vec4 texture_color = texture2D(tex0, gl_TexCoord[0].st);
	
	// color 
	gl_FragData[0].rgb = (final_color * texture_color).rgb;
	gl_FragData[0].a = texture_color.a;

}