// particle1.frag

#ifdef GL_FRAGMENT_PRECISION_HIGH
   precision highp float;
#else
   precision mediump float;
#endif

// The following uniforms are comes from the shader API
uniform vec2 resolution;
uniform float time;

uniform sampler2D tex0;
uniform sampler2D alphaMap;

uniform int mode;
uniform float csoda;

varying float ZValue;

//uniform float near;
//uniform float far;

const float near = 3.0;
const float far = 800.;

float varazslat(vec2 position){
	float color = 0.0;
	float t = 2.*time;
	color += sin(position.x*cos(t/10.0)*20.0 )+cos(position.x*cos(t/15.)*10.0 );
	color += sin(position.y*sin(t/ 5.0)*15.0 )+cos(position.x*sin(t/25.)*20.0 );
	color += sin(position.x*sin(t/10.0)*  .2 )+sin(position.y*sin(t/35.)*10.);
	color *= sin(t/10.)*.5;
	
	return color;
}

void main()
{	
	vec2 p = gl_TexCoord[0].st;
	vec4 sample = texture2D(tex0, p);
	vec4 color;
	
	if (mode == 2){
		color.rgb = sample.rgb;
		color.a = float(texture2D(alphaMap, p));
	}
	else if (mode == 3){
		color.rgb = gl_Color.rgb * sample.rgb;
		color.a   = sample.r ;
		color.a *= gl_Color.a;
	}
	else if (mode == 4){
		color.rgb = sample.rgb;
		color.a = float(texture2D(alphaMap, p)) * clamp(2.* csoda + varazslat(p),0.,1.);
	}
	else {
		color.rgb = gl_Color.rgb * sample.rgb;
		color.a   = sample.r ;
		color.a *= gl_Color.a;
	}
	
	gl_FragData[0] = color;
}
