; Set all 8 values to zero
; if you want all sounds at full volume.  10 is probably 
; about the highest amount of attenuation you'll want.
;
; 000=square  001=bass  010=pitfall  011=noise
; 100=buzz    101=lead  110=saw      111=engine
soundVolArray
	byte 10,10,6,10,7,10,4,10

; Default Sound Type Setup:
; 000 0 Square  = 4
; 001 1 Bass    = 6
; 010 2 Pitfall = 7
; 011 3 Noise   = 8
;
; 100 4 Buzz    = 15
; 101 5 Lead    = 12
; 110 6 Saw     = 1
; 111 7 Engine  = 3
;
soundTypeArray
    byte 4,6,7,8
    byte 15,12,1,3

HATVOLUME equ 8
HATPITCH  equ 0
HATSOUND  equ 8
HATSTATIC equ 0         ;if non-zero, use static hat pattern (saves 5 B)
HATPATTRN equ %10000000 ;if HATSTATIC

#if !HATSTATIC
hatPattern
    byte %10000000
    byte %10000000
    byte %10000000
    byte %10001000
#endif

    MAC MEASURES        ;saves 3 B in player by premultiplying by eight
    byte {1}*8,{2}*8,{3}*8,{4}*8
    ENDM
song1   ;hi-hat always runs in this channel. having it non-configurable saves ROM
    byte 0                  ;let the picture stabilize
    MEASURES 1, 2, 1, 3
HATSTART    equ *-song1     ;saves 6 B if == 0 (@ song1)
    MEASURES 1, 2, 1, 3
INTROLENGTH equ *-song1
    MEASURES 1, 2, 1, 3
    MEASURES 1, 2, 1, 12
    MEASURES 1, 2, 1, 3
    MEASURES 1, 2, 1, 12
    MEASURES 0, 0, 0, 0
    MEASURES 0, 0, 0, 0
    MEASURES 10,11,10,11
    MEASURES 10,11,10,13
    MEASURES 10,11,10,11
    MEASURES 10,11,10,13
SONGEND     equ *-song1

song2
    byte 0
    MEASURES 0, 0, 0, 0
    MEASURES 0, 0, 0, 0
    MEASURES 4, 5, 4, 5
    MEASURES 4, 5, 4, 5
    MEASURES 6, 7, 6, 9
    MEASURES 6, 7, 6, 8
    MEASURES 4, 5, 4, 5
    MEASURES 4, 5, 4, 5
    MEASURES 4, 5, 4, 5
    MEASURES 4, 5, 4, 5
    MEASURES 6, 7, 6, 9
    MEASURES 6, 7, 6, 8

patternArray    ; starts at 1
    word Bass0,Bass1,Bass0,Bass1
    word Bass0,Bass1,Bass2,Bass2
    word Bass0,Bass1,Bass2,Bass3
    word Drum,0,Drum,0
    word Drum,0,Drum,Drum
    word Drum,PreDrum,Drum,PreDrum
    word Drum,PreDrum,Drum,Drum
    word Drum,PreDrum,Drum,DoubleDrum
    word Drum,PreDrum,Drum,DrumPreDrum
    word Melody0,Melody1,Melody2,Melody3
    word Melody0,Melody1,Melody2,Melody4
    word Bass0,Bass1,Bass4,Bass5
    word Melody0,Melody1,Melody5,Melody4

Bass0
    byte %11101110,%11101110,%11101110,%11101110
    byte %11101001,%11101001,%11101001,%11101001
    byte %11001000
Bass1
    byte %11101011,%11101011,%11101011,%11101011
    byte %11101001,%11101001,%11101001,%11101001
    byte %11001000
Bass2
    byte %11101000,%11101000,%11101000,%11101000
    byte %11101001,%11101001,%11101001,%11101001
    byte %11001000
Bass3
    byte %11101010,%11101010,%11101010,%11101010
    byte %11101011,%11101011,%11101011,%11101011
    byte %11001000
Bass4
    byte %11101010,%11101010,%11101010,%11101010
    byte %11101011,%11101011,%11101011,%11101011
    byte %11001100
Bass5
    byte %11101011,%11101011,%11101011,%11101011
    byte %11101011,%11101011,%11101011,%11101011
    byte %11110000
Drum
    byte %01100111,%01100111,%01100111,%01100111
    byte %01100111,%01100111,%01100111,%01100111
    byte %11000000
PreDrum
    byte %01100111,%01100111,%01100111,%01100111
    byte %01101011,%01101011,%01101011,%01101011
    byte %00001000
DrumPreDrum         ;note super necessary - can be replace with just Drum
    byte %01100111,%01100111,%01100111,%01100111
    byte %01101011,%01101011,%01101011,%01101011
    byte %11001000
DoubleDrum
    byte %01100111,%01100111,%01100111,%01100111
    byte %01100111,%01100111,%01100111,%01100111
    byte %11001100
Melody0
    byte %10101110,%10101110,%10101110,%10101110
    byte %10101001,%10101001,%10101001,%10101001
    byte %11001010
Melody1
    byte %10101001,%10101001,%10101001,%10101001
    byte %10101011,%10101011,%10101011,%10101011
    byte %10001100
Melody2
    byte %10101001,%10101001,%10101001,%10101001
    byte %10101001,%10101001,%10101001,%10101001
    byte %11001100
Melody3
    byte %10101000,%10101000,%10101000,%10101000
    byte %10101001,%10101001,%10101001,%10101001
    byte %11001100
Melody4
    byte %10101010,%10101010,%10101010,%10101010
    byte %10101011,%10101011,%10101011,%10101011
    byte %11001100
Melody5
    byte %10101001,%10101001,%10101001,%10101001
    byte %10101001,%10101001,%10101001,%10101001
    byte %10101010
