    processor 6502
    include vcs.h
    include macro.h

;FPS = 50 or 60
;PAL = 0 or 1
#if FPS==50         ;PAL
VBLNK   equ 48
LINES2  equ 228
OVERSCN equ 36
#else               ;NTSC
VBLNK   equ 40
LINES2  equ 192
OVERSCN equ 30
#endif

TEMPO   equ 48
SONGDBG equ 0
FADEOUT equ 0
YRES    equ 24
TEXTLINES   equ 50
LINES   equ LINES2-TEXTLINES

    ;RAM
    SEG.U VARS
    org $80

frame   ds  1
temp    ds  5
    ;song player vars
vol1    ds  1
vol2    ds  1
beat    ds  1
tempoCount  ds  1           ;bit 7 (sign) = whether it's the first frame in the beat
measure ds  1
#if SONGDBG
note1   ds  1               ;introspection
note2   ds  1
sound1  ds  1
sound2  ds  1
#endif
#if FADEOUT
atten   ds  1               ;attenuation counter for fadeout
#endif

scene       ds  1
    ;vars for text scroller
toppos      ds  1
textline    ds  1

SCENERAM    equ *

charptr     ds  24
toppad      ds  1
bottompad   ds  1
textend     ds  1   ;-1 - 7
linesleft   ds  1

    org SCENERAM

col0    ds  YRES
col1    ds  YRES
col2    ds  YRES
col3    ds  YRES

    org SCENERAM

beergfx ds 8    ;PF1, PF2, four rows

    echo "RAM:", ($100 - *), "bytes left"

    ;ROM
    SEG CODE
    org $1000

    include build/sintab.asm
    include build/font.asm
    include fbbobs.asm
    include mass.asm
    include metaballs.asm

    FONT
    TEXT

bitMaskArray
    byte #%10000000
    byte #%01000000
    byte #%00100000
    byte #%00010000
    byte #%00001000
    byte #%00000100
    byte #%00000010
    byte #%00000001

    include utils.asm

    FBBOBS_LOGIC
    FBBOBS_KERNEL
    MASS_LOGIC
    MASS_KERNEL
    METABALLS_KERNEL

Music
    include song.asm
    echo "Music:",*-Music

Start
    CLEAN_START

    lda #38
    sta toppos

MainLoop
    lda #OVERSCN*19/16
    sta TIM64T
    lda #2
    sta VBLANK

    inc frame

    lda beat
    and #1
    bne TopPosOK
    lda tempoCount
    bpl TopPosOK

    lda measure
    beq TopPosOK
    dec toppos
    bne TopPosOK
    lda #20
    sta toppos
    inc textline
    lda textline
    cmp #NUM_LINES-1
    bcc TopPosOK
    lda #0
    sta textline
TopPosOK

    ;play song by falling into songPlayer
Player
    include songplay.h
    echo "Player:",*-Player
    ;we fall back out of the player here

WaitForOverscanEnd
    lda INTIM
    bmi WaitForOverscanEnd_Overflow
    bne WaitForOverscanEnd
WaitForOverscanEnd_Overflow

    VERTICAL_SYNC
    lda #VBLNK*19/16-1
    sta TIM64T

    lda measure
    beq WaitForVblankEnd    ;intro
    sec
    sbc #1
    and #%1111
    sta scene

    cmp #15
    beq GoMass
    cmp #8
    bcs GoBalls
    jsr fbbobsLogic
    jmp WaitForVblankEnd
GoMass
    jsr massLogic
GoBalls

WaitForVblankEnd
    lda INTIM
    bmi WaitForVblankEnd_Overflow
    bne WaitForVblankEnd
WaitForVblankEnd_Overflow
    lda #0
    sta VBLANK
    ;NOTE: Don't set COLUBK before VBLANK has been turned off (above)
    ;      Otherwise you get ugly colors for the first few lines

    sta WSYNC
    lda measure
    bne GoNormal
    ldx #LINES2
BlackScreen
    sta WSYNC
    dex
    bne BlackScreen
    jmp MainLoop
GoNormal
    lda scene
    cmp #15
    beq GoMassKernel
    cmp #8
    bcs GoBallsKernel
    jsr fbbobsKernel
    jmp ShowText
GoMassKernel
    jsr massKernel
    jmp ShowText
GoBallsKernel
    jsr metaballsKernel
ShowText
    include twelvechar.asm
    jmp MainLoop

    echo "ROM:", ($1FFC - *), "bytes left"

    org $1FFC
    .word Start
    .word Start
