    MAC FBBOBS_LOGIC
ColTab
    .byte #0
    .byte #YRES
    .byte #YRES*2
    .byte #YRES*3

fbbobsLogic
    ;NOTE: this used to be in overscan - maybe it takes too long time?
    lda #0
    ldx #YRES/2-1
ClearScreen
    sta col0,X
    sta col0+YRES/2,X
    sta col1,X
    sta col1+YRES/2,X
    sta col2,X
    sta col2+YRES/2,X
    sta col3,X
    sta col3+YRES/2,X
    dex
    bpl ClearScreen     ;37 cy/iter * 10 + 4 = 374

    lda #51
    ldx #0
    jsr PositionObject
    lda #83
    inx
    jsr PositionObject
    sta WSYNC
    sta HMOVE

    stx CTRLPF  ;reflect

    lda #7
    sta NUSIZ0
    sta NUSIZ1  ;quad sized
    lda #$92
    sta COLUP0
    sta COLUP1
    sta COLUPF
    ;end old overscan logic

    ldx #15
DrawBob
    txa
    asl
    asl
    asl
    clc
    adc frame
    sta temp
    tay
    lda SinTab,Y
    lsr
    lsr
    lsr
    sta temp+1
    lsr
    lsr
    lsr
    tay
    lda ColTab,Y
    sta temp+2

    lda temp
    clc
    adc #37
    adc frame
    tay
    lda SinTab,Y
    lsr
    lsr
    lsr
    lsr
    sta temp
    asr #$FE
    adc temp
    clc
    adc temp+2
    sta temp+2

    lda temp+1
    and #7
    tay
    lda #YRES*3-1
    cmp temp+2
    bcs UseBitmaskRef
    tya
    eor #7
    tay
UseBitmaskRef
    lda bitMaskArray,Y
    ldy temp+2
    ora col0,Y
    sta col0,Y

    dex
    bpl DrawBob
    rts
    ENDM

    MAC FBBOBS_KERNEL
fbbobsKernel
    ldx #YRES-1
Kernel
    ldy #7
KernelInner
    lda frame
    lsr
    lsr
    lsr
    sta temp+1
    sty temp
    txa

    sta WSYNC

    adc temp
    adc temp+1
    and #$0F
    ora #$40
    sta COLUBK

    lda col0,X
    sta PF1
    lda col1,X
    sta GRP0
    lda col2,X
    sta GRP1
    lda col3,X
    dey
    sta PF1
    bne KernelInner
    dex
    bpl Kernel

    ldx #LINES-YRES*7-1
Burn
    sta WSYNC
    lda #0
    sta GRP0
    sta GRP1
    sta PF1
#if TEXTBK
    lda #TEXTBK
#endif
    sta COLUBK
    dex
    bne Burn
    rts
    ENDM
