from .gl2 import *


class Mesh(object):
    def __init__(self):
        self.vertex_count = len(self.vertices)
        self.vertex_size = len(self.vertices[0])

        vertices_flat = []
        for vertex in self.vertices:
            vertices_flat += vertex
        self.gl_vertices = GLfloats(vertices_flat)

    def draw(self, vertex_position_attr):
        # if using glBindAttribLocation
        # glVertexAttribPointer(0, self.vertex_size, GL_FLOAT, GL_FALSE, 0, self.gl_vertices)

        check_gl_error()
        # if using glGetAttribLocation
        glVertexAttribPointer(vertex_position_attr, self.vertex_size, GL_FLOAT, GL_FALSE, 0, self.gl_vertices)
        check_gl_error()

        # if using arraybuffers with glGetAttribLocation
        #glBindBuffer(gl.ARRAY_BUFFER, self.bg_vertex_position_buffer)
        #glVertexAttribPointer(vertex_position_attr, self.vertex_size, gl.FLOAT, GL_FALSE, 0, 0)

        glEnableVertexAttribArray(vertex_position_attr)
        check_gl_error()
        glDrawArrays(self.mode, 0, self.vertex_count)
        check_gl_error()
