#version 330 core

uniform sampler2D texSequenceFrom;
uniform sampler2D texSequenceTo;
uniform float transitionTime;

in vec2 ex_TexCoord;

out vec4 out_color;

// fade to black from 0 to 0.5, then from black 

void main()
{
	vec3 color;

	if (transitionTime < 0.5)
	{
		color = texture(texSequenceFrom, ex_TexCoord).rgb;
		color = mix(color, vec3(0.0), transitionTime * 2.0);
	}
	else
	{
		color = texture(texSequenceTo, ex_TexCoord).rgb;
		color = mix(color, vec3(0.0), (1.0 - transitionTime) * 2.0);
	}

	out_color = vec4(color, 1.0);
}