#version 330 core

layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

// Input
in vec3 _color[];
in float _life[];

// Output
out vec2 ex_TexCoord;
flat out float ex_Life;

// Uniforms
uniform mat4 projMatrix;
uniform float size;

//void main()
//{
//	// transform the point in view view space
//	vec4 posInView = gl_in[0].gl_Position;
//
//	gl_Position = projMatrix * posInView;
//	EmitVertex();
//}

void main()
{
	// transform the point in view view space
	vec4 posInView = gl_in[0].gl_Position;

	// emit a screen-aligned quad, with texture coordinates
	gl_Position = projMatrix * vec4(posInView.xyz + vec3(-size, -size, 0.), 1.);
	ex_TexCoord = vec2(0.0, 0.0);
	//ex_Color = _color[0];
	ex_Life = _life[0];
	EmitVertex();

	gl_Position = projMatrix * vec4(posInView.xyz + vec3(-size, +size, 0.), 1.);
	ex_TexCoord = vec2(0.0, 1.0);
	//ex_Color = _color[0];
	ex_Life = _life[0];
	EmitVertex();

	gl_Position = projMatrix * vec4(posInView.xyz + vec3(+size, -size, 0.), 1.);
	ex_TexCoord = vec2(1.0, 0.0);
	//ex_Color = _color[0];
	ex_Life = _life[0];
	EmitVertex();

	gl_Position = projMatrix * vec4(posInView.xyz + vec3(+size, +size, 0.), 1.);
	ex_TexCoord = vec2(1.0, 1.0);
	//ex_Color = _color[0];
	ex_Life = _life[0];
	EmitVertex();
}
