#version 330 core

// Input
in block
{
	vec3 positionInWorld;
	vec3 positionInView;
	vec3 texCoord;
} In;

// Output
out vec4 out_FragColor;

// Uniforms
uniform sampler2D noiseSampler;
uniform float time;

vec3 evaluateAt(vec2 p)
{
	// sample the noise in the given direction
	float n = texture(noiseSampler, p).r;

	// manipulate the noise
	float d = n;
	d = abs(d);
	d = 1. - clamp(10. * d, 0., 1.);
	//d = pow(1. - d, 5.);

	// colorize
	//return vec3(.29, .8, .13) * d;
	//return vec3(0.8, 0.27, 0.0) * d;
	return vec3(0.19, 0.34, 0.8) * d;
}

void main()
{
	// transform 2d texcoords to a 3d direction
	vec2 texCoord = In.texCoord.xy;

	// add some noise layers.
	float t = 0.;//0.05 * time;

	vec3 color;
	color  = 1.0 * evaluateAt(In.texCoord.xy + vec2(+t, 0.));
	color += .50 * evaluateAt(In.texCoord.yx + vec2(0., -t + 0.5));
	color += .25 * evaluateAt(In.texCoord.yx + vec2(+t + 0.2, 0.));

	out_FragColor  = vec4(color, 1.);
	//out_FragColor = vec4(vec3(1. - n), 1.);
	//out_FragColor = vec4(color, 1.);
}
